<?php
// Exit if accessed directly.
defined('ABSPATH') || exit;


if (!function_exists('wbls_register_form_block')) {
    function wbls_register_form_block() {

        $dir = WBLS_DIR . '/blocks/form/';
        $url = WBLS_URL . '/blocks/form/';
        wp_register_style(
            'wbls-frontend-style',
            WBLS_URL . '/frontend/assets/css/style.css', // 🔹 remove extra slash before /frontend if WBLS_URL already ends with /
            [],
            defined('WBLS_VERSION') ? WBLS_VERSION : '1.0.0'
        );

        wp_register_style(
            'wbls-frontend-default-style',
            WBLS_URL . '/frontend/assets/css/default.css', // 🔹 remove extra slash before /frontend if WBLS_URL already ends with /
            [],
            defined('WBLS_VERSION') ? WBLS_VERSION : '1.0.0'
        );

        // Editor JS (no build step). Declare dependencies on wp packages we use.
        wp_register_script(
            'wbls-form-editor',
            $url . 'index.js',
            array('wp-blocks', 'wp-element', 'wp-i18n', 'wp-components', 'wp-block-editor', 'wp-data', 'wp-core-data', 'wp-server-side-render'),
            defined('WBLS_VERSION') ? WBLS_VERSION : '1.0.0',
            true
        );

        $wp_upload_dir = wp_upload_dir();
        $wbls_style_url = $wp_upload_dir[ 'baseurl' ];
        wp_localize_script('wbls-form-editor', 'WBLS_BLOCK', [
            'iconUrl' => $url . 'logo.svg', // e.g. .../blocks/form/icon.svg
            'themeBaseUrl' => $wbls_style_url, // Add this line
        ]);

        // Register through metadata (block.json)
        register_block_type(
            $dir . 'block.json',
            array(
                'render_callback' => 'wbls_render_form_block',
            )
        );
    }
    add_action('init', 'wbls_register_form_block');
}

if (!function_exists('wbls_render_form_block')) {
    function wbls_render_form_block($attributes, $content, $block) {
        $form_id = isset($attributes['formId']) ? intval($attributes['formId']) : 0;
        $display_type = isset($attributes['displayType']) ? sanitize_text_field($attributes['displayType']) : 'tab';
        $theme_id = isset($attributes['themeId']) ? intval($attributes['themeId']) : 0;
        wp_enqueue_style('wbls-frontend-style');

        if( $theme_id ) {
            $wp_upload_dir = wp_upload_dir();
            $wbls_style_dir = $wp_upload_dir[ 'basedir' ] . '/wbls-system/wbls-theme-style_' . $theme_id . '.css';
            $wbls_style_url = $wp_upload_dir[ 'baseurl' ] . '/wbls-system/wbls-theme-style_' . $theme_id . '.css';
            if( file_exists($wbls_style_dir) ) {
                wp_enqueue_style(WBLS_PREFIX . '-theme-style_' . $theme_id, $wbls_style_url, array(), WBLS_VERSION);
            }
        } else {
            wp_enqueue_style('wbls-frontend-default-style');
        }

        if (!$form_id) {
            if (current_user_can('edit_posts')) {
                return '<div class="wbls-block-placeholder" style="padding: 20px; border: 2px dashed #ccc; text-align: center; background: #f9f9f9;">
                            <p><strong>' . __('Whistleblowing Form', 'whistleblowing-system') . '</strong></p>
                            <p>' . __('No form selected. Please choose a form in block settings.', 'whistleblowing-system') . '</p>
                        </div>';
            }
            return '';
        }

        // Build shortcode with correct name: wblsform
        $shortcode_parts = ['[wblsform'];

        // Add id
        $shortcode_parts[] = 'id="' . esc_attr($form_id) . '"';

        // Add type if not default
        if ( $display_type !== 'popup' ) {
            $shortcode_parts[] = 'type="' . esc_attr($display_type) . '"';
        }

        if ( $theme_id !== 0 ) {
            $shortcode_parts[] = 'theme_id="' . esc_attr($theme_id) . '"';
        }

        $shortcode = implode(' ', $shortcode_parts) . ']';
        return do_shortcode($shortcode);
    }
}
