<?php
namespace WBLS_WhistleBlower\Free;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
class WBLS_Encryption {

    private static $method = 'AES-256-CBC';

    private static function get_key() {
        $key = get_option('wbls_encryption_key');
        return $key ? hash('sha256', $key) : '';
    }

    private static function get_iv() {
        $iv = get_option('wbls_encryption_iv');
        return $iv ? substr(hash('sha256', $iv), 0, 16) : '';
    }

    public static function encrypt($data) {
        // Auto-encode arrays/objects as JSON and prefix
        if( $data === '' ) {
            return $data;
        }
        elseif (is_array($data) || is_object($data)) {
            $data = '__JSON__' . json_encode($data);
        }

        return base64_encode(openssl_encrypt($data, self::$method, self::get_key(), 0, self::get_iv()));
    }

    public static function decrypt($string) {
        try {
            if ( $string === '' ) {
                return $string;
            }
            // Base64 decode and decrypt
            $decrypted = openssl_decrypt(base64_decode($string), self::$method, self::get_key(), 0, self::get_iv());

            // Fallback: if decryption failed (not encrypted), assume plain text
            if ( $decrypted === false || $decrypted === '' ) {
                return $string;
            }

            // Handle JSON-encoded arrays
            if ( strpos($decrypted, '__JSON__') === 0 ) {
                $json = substr($decrypted, 8);
                $decoded = json_decode($json, true);
                return (json_last_error() === JSON_ERROR_NONE) ? $decoded : $json;
            }

            return $decrypted;
        } catch (\Throwable $e) {
            return $string; // fallback to plain text
        }
    }
}
