<?php
namespace WBLS_WhistleBlower\Free;

if ( ! defined( 'ABSPATH' ) ) exit;

class WBLS_Logger {

    public static function maybe_create_table() {
        global $wpdb;
        $table_name = $wpdb->prefix . 'wbls_logs';
        $charset_collate = $wpdb->get_charset_collate();

        $sql = "CREATE TABLE IF NOT EXISTS $table_name (
            id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            form_id BIGINT(20) UNSIGNED DEFAULT NULL,
            case_id BIGINT(20) UNSIGNED DEFAULT NULL,
            submission_id BIGINT(20) UNSIGNED DEFAULT NULL,
            type VARCHAR(50) NOT NULL,
            status VARCHAR(20) DEFAULT 'info',
            message TEXT NOT NULL,
            created_by VARCHAR(100) DEFAULT 'system',
            wp_user_name VARCHAR(100) DEFAULT 'system',
            ip_address VARCHAR(45) DEFAULT NULL,
            meta_data LONGTEXT DEFAULT NULL,
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (id),
            KEY idx_form_id (form_id),
            KEY idx_case_id (case_id),
            KEY idx_submission_id (submission_id),
            KEY idx_type (type),
            KEY idx_status (status),
            KEY idx_created_at (created_at)
        ) $charset_collate;";

        require_once ABSPATH . 'wp-admin/includes/upgrade.php';
        dbDelta( $sql );
    }

    public static function log( $type, $status = 'info', $message = '', $args = [] ) {
        $wbls_global_settings = json_decode( get_option( 'wbls_global_settings' ), true );
        $enabled = wp_validate_boolean( $wbls_global_settings['logs_active'] ?? false );

        if ( ! $enabled ) {
            return;
        }

        global $wpdb;
        $table = $wpdb->prefix . 'wbls_logs';

        $data = [
            'form_id'       => $args['form_id'] ?? null,
            'case_id'       => $args['case_id'] ?? null,
            'submission_id' => $args['submission_id'] ?? null,
            'type'          => sanitize_text_field( $type ),
            'status'        => sanitize_text_field( $status ),
            'message'       => wp_kses_post( $message ),
            'created_by'    => $args['created_by'] ?? 'system',
            'ip_address'    => null,
            'meta_data'     => isset( $args['meta'] ) ? wp_json_encode( $args['meta'] ) : null,
            'created_at'    => current_time( 'mysql' ),
        ];

        $wpdb->insert( $table, $data );
    }

    /**
     * Purge wp_wbls_logs rows older than logs_lifetime days.
     *
     * @return int Deleted rows count.
     */
    public static function wbls_purge_old_logs() {
        global $wpdb;

        $raw      = get_option('wbls_global_settings', '{}');
        $settings = json_decode(is_string($raw) ? $raw : '{}', true) ?: [];
        $days = isset($settings['logs_lifetime']) ? (int) $settings['logs_lifetime'] : 30;
        if ( $days < 1 ) {
            return 0;
        }

        $table = $wpdb->prefix . 'wbls_logs';

        $sql = $wpdb->prepare(
            "DELETE FROM `{$table}` WHERE created_at < (NOW() - INTERVAL %d DAY)", // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
            $days
        );

        // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared
        return (int) $wpdb->query($sql);
    }
}
