<?php
namespace WBLS_WhistleBlower\Free;
class WBLS_DefaultForms {

    private $forms = [];

    public function __construct()
    {
        $this->defaultsData();
        $this->createForms();
    }

    public function defaultsData() {


        $countriesOptions = '';
        foreach ( WBLSLibrary::$country_list as $country ) {
            $countriesOptions .= '<option value="' . $country . '"' . $country . '</option>';
        }

        $this->forms = [
            '0' => [
                'post_title' => 'Simple Contact Form',
                'post_metas' => [
                    'wbls_form_content' => '<div class="wblsform-page-and-images wbls-form-builder">
                                                <div class="wblsform_section">                                            
                                                    <div class="wblsform_column">
                                                        <div class="wblsform-row wbls-label-top" data-field-id="0">
                                                        <label class="wbls-field-label">Name</label>
                                                        <input class="wbls-field" type="text" name="wbls_field_0" value="">
                                                        <p class="wbls-field-description"></p>        
                                                        </div>
                                                    </div>
                                                    <div class="wblsform_column">
                                                        <div class="wblsform-row wbls-label-top" data-field-id="1">
                                                        <label class="wbls-field-label">Email*</label>
                                                        <input class="wbls-field" type="email" name="wbls_field_1" value="" required="">
                                                        <p class="wbls-field-description"></p>        
                                                        </div>
                                                    </div>
                                                    <div class="wblsform_column">
                                                        <div class="wblsform-row wbls-label-top" data-field-id="2">
                                                        <label class="wbls-field-label">Subject*</label>
                                                        <input class="wbls-field" type="text" name="wbls_field_2" value="" required="">
                                                        <p class="wbls-field-description"></p>        
                                                        </div>
                                                    </div>
                                                    <div class="wblsform_column">    
                                                        <div class="wblsform-row wbls-label-top" data-field-id="4">
                                                        <label class="wbls-field-label">Message*</label>
                                                        <textarea class="wbls-field" name="wbls_field_4" required=""></textarea>
                                                        <p class="wbls-field-description"></p>        
                                                        </div>
                                                    </div>
                                                    <div class="wblsform_column">
                                                        <div class="wblsform-row wblsform-row-submit wbls-label-top wblsform-row-edit-active" data-field-id="5">
                                                        <button class="wbls-submit-form">Submit</button>        
                                                        </div>
                                                    </div>                                            
                                                </div>
                                            </div>',
                    'wbls_field_options' => [
                        0 => [
                            'type'        => 'text',
                            'title'       => 'Single Line Text',
                            'description' => '',
                            'value'       => '',
                            'name'        => 'wbls_field_0',
                            'icon'        => '',
                            'order'       => 0,
                            'public'      => true,
                            'class'       => '',
                            'id'          => '',
                            'label'       => 'Name',
                            'placeholder' => '',
                            'pro'         => 0,
                            'required'    => 0,
                            'tabs'        => [
                                'general',
                                'conditions',
                            ],
                        ],
                        1 => [
                            'type'            => 'email',
                            'title'           => 'Email',
                            'description'     => '',
                            'value'           => '',
                            'name'            => 'wbls_field_1',
                            'icon'            => '',
                            'order'           => 8,
                            'public'          => true,
                            'class'           => '',
                            'id'              => '',
                            'label'           => 'Email',
                            'placeholder'     => '',
                            'pro'             => 0,
                            'required'        => 1,
                            'tabs'            => [
                                'general',
                                'conditions',
                            ],
                            'required_single' => 0,
                        ],
                        2 => [
                            'type'            => 'text',
                            'title'           => 'Single Line Text',
                            'description'     => '',
                            'value'           => '',
                            'name'            => 'wbls_field_2',
                            'icon'            => '',
                            'order'           => 0,
                            'public'          => true,
                            'class'           => '',
                            'id'              => '',
                            'label'           => 'Subject',
                            'placeholder'     => '',
                            'pro'             => 0,
                            'required'        => 1,
                            'tabs'            => [
                                'general',
                                'conditions',
                            ],
                            'required_single' => 0,
                        ],
                        4 => [
                            'type'            => 'textarea',
                            'title'           => 'Paragraph Text',
                            'description'     => '',
                            'value'           => '',
                            'name'            => 'wbls_field_4',
                            'icon'            => '',
                            'order'           => 1,
                            'public'          => true,
                            'class'           => '',
                            'id'              => '',
                            'label'           => 'Message',
                            'placeholder'     => '',
                            'pro'             => 0,
                            'required'        => 1,
                            'tabs'            => [
                                'general',
                                'conditions',
                            ],
                            'required_single' => 0,
                        ],
                        5 => [
                            'type'        => 'submit',
                            'title'       => 'Submit Button',
                            'description' => '',
                            'value'       => '',
                            'name'        => '',
                            'icon'        => '',
                            'order'       => 14,
                            'public'      => true,
                            'class'       => '',
                            'id'          => '',
                            'label'       => 'Submit',
                            'placeholder' => '',
                            'pro'         => 0,
                            'required'    => 0,
                            'tabs'        => [
                                'general',
                                'conditions',
                            ],
                        ],
                    ],
                    'wbls_email_options' => [
                        'sendemail'     => 0,
                        'admin_mail'    => '',
                        'wbls_mail_from'=> '',
                    ],
                    'wbls_form_settings' => [
                        'whistleblower_active'         => 0,
                        'new_case'                     => 'Report a new case',
                        'follow_case'                  => 'Follow up on a case',
                        'login_case'                   => 'Login',
                        'reply_button'                 => 'Send',
                        'success_message'              => 'Form successfully submitted',
                        'success_message_copy_token'   => 'Please copy and retain this token for future login and for follow-up on the response.',
                        'error_message'                => 'Something went wrong',
                        'wbls_show_form_after_submit'  => 1,
                        'active_theme'                 => 6,
                        'file_max_size'                => 10,
                        'file_types'                   => [
                            'jpg',
                            'png',
                            'gif',
                        ],
                        'show_form_header'             => 1,
                        'form_header'                  => "You may contact us by filling in this form any time you need professional support or have any questions. You can also fill in the form to leave your comments or feedback.",
                        'token_header'                 => '',
                        'login_header'                 => '',
                    ],
                    'wbls_fieldNameLastId' => 6,
                ]
            ],
            '1' => [
                'post_title' => 'Client List Form',
                'post_metas' => [
                    'wbls_form_content' => '<div class="wblsform-page-and-images wbls-form-builder">
                                                <div class="wblsform_section">
                                                    <div class="wblsform_column">
                                                        <div class="wblsform-row wbls-label-top" data-field-id="0">
                                                        <label class="wbls-field-label">Name</label>
                                                        <div class="wbls-field-fullName-container">
                                                        <div class="wbls-field-firstName">
                                                        <input class="wbls-field" type="text" name="wbls_field_0_f" value="">
                                                        <label class="wbls-field-miniLabel">First</label>
                                                        </div>
                                                        <div class="wbls-field-lastName">
                                                        <input class="wbls-field" type="text" name="wbls_field_0_l" value="">
                                                        <label class="wbls-field-miniLabel">Last</label>
                                                        </div>
                                                        </div>
                                                        <p class="wbls-field-description"></p>        
                                                        </div>
                                                    </div>
                                                    <div class="wblsform_column">    
                                                        <div class="wblsform-row wbls-label-top" data-field-id="1">
                                                        <label class="wbls-field-label">Email*</label>
                                                        <input class="wbls-field" type="email" name="wbls_field_1" value="" required="">
                                                        <p class="wbls-field-description"></p>        
                                                        </div>
                                                    </div>
                                                    <div class="wblsform_column">
                                                        <div class="wblsform-row wbls-label-top wblsform-row-edit-active" data-field-id="2">
                                                        <label class="wbls-field-label">Phone*</label>
                                                        <input class="wbls-field" type="tel" name="wbls_field_2" value="" required="">
                                                        <p class="wbls-field-description"></p>        
                                                        </div>
                                                    </div>
                                                    <div class="wblsform_column">
                                                        <div class="wblsform-row wbls-label-top" data-field-id="3">
                                                        <label class="wbls-field-label">Website</label>
                                                        <input class="wbls-field" type="text" name="wbls_field_3" value="" placeholder="https://example.com">
                                                        <p class="wbls-field-description"></p>        
                                                        </div>
                                                    </div>
                                                    <div class="wblsform_column">
                                                        <div class="wblsform-row wbls-label-top" data-field-id="4">
                                                        <label class="wbls-field-label">Address</label>
                                                        <div class="wbls-field-address-container">
                                                        <div class="wbls-field-street">
                                                        <input class="wbls-field" type="text" name="wbls_field_4_street" value="">
                                                        <label class="wbls-field-miniLabel">Street Address</label>
                                                        </div>
                                                        <div class="wbls-field-street1">
                                                        <input class="wbls-field" type="text" name="wbls_field_4_street1" value="">
                                                        <label class="wbls-field-miniLabel">Street Address Line 2</label>
                                                        </div>
                                                        <div class="wbls-address-row"><div class="wbls-field-city">
                                                        <input class="wbls-field" type="text" name="wbls_field_4_city" value="">
                                                        <label class="wbls-field-miniLabel">City</label>
                                                        </div>
                                                        <div class="wbls-field-state">
                                                        <input class="wbls-field" type="text" name="wbls_field_4_state" value="">
                                                        <label class="wbls-field-miniLabel">State / Province / Region</label>
                                                        </div>
                                                        </div>
                                                        <div class="wbls-address-row">
                                                        <div class="wbls-field-postal">
                                                        <input class="wbls-field" type="text" name="wbls_field_4_postal" value="">
                                                        <label class="wbls-field-miniLabel">Postal / Zip Code</label>
                                                        </div>
                                                        <div class="wbls-field-country">
                                                        <select class="wbls-field" name="wbls_field_4_country"><option value="">Choose a Country</option>' . $countriesOptions . '</select>
                                                        <label class="wbls-field-miniLabel">Country</label>
                                                        </div>
                                                        </div>
                                                        </div>
                                                        <p class="wbls-field-description"></p>        
                                                        </div>
                                                    </div>
                                                    <div class="wblsform_column">
                                                        <div class="wblsform-row wblsform-row-submit wbls-label-top" data-field-id="5">
                                                        <button class="wbls-submit-form">Submit</button>        
                                                        </div>
                                                    </div>                                                    
                                                </div>
                                            </div>',
                    'wbls_field_options' => [
                        0 => [
                            'type'                  => 'fullName',
                            'title'                 => 'Full Name',
                            'description'           => '',
                            'value'                 => '',
                            'name'                  => 'wbls_field_0',
                            'icon'                  => '',
                            'order'                 => 7,
                            'public'                => true,
                            'class'                 => '',
                            'id'                    => '',
                            'label'                 => 'Name',
                            'placeholder'           => '',
                            'pro'                   => 0,
                            'required'              => 0,
                            'fname'                 => 'wbls_field_0_f',
                            'mname'                 => 'wbls_field_0_m',
                            'lname'                 => 'wbls_field_0_l',
                            'firstNamePlaceholder'  => '',
                            'firstNameMiniLabel'    => 'First',
                            'lastNamePlaceholder'   => '',
                            'lastNameMiniLabel'     => 'Last',
                            'middleNamePlaceholder' => '',
                            'middleNameMiniLabel'   => 'Middle',
                            'hideMiddleName'        => 0,
                            'tabs'                  => [
                                'general',
                                'conditions',
                            ],
                        ],
                        1 => [
                            'type'            => 'email',
                            'title'           => 'Email',
                            'description'     => '',
                            'value'           => '',
                            'name'            => 'wbls_field_1',
                            'icon'            => '',
                            'order'           => 8,
                            'public'          => true,
                            'class'           => '',
                            'id'              => '',
                            'label'           => 'Email',
                            'placeholder'     => '',
                            'pro'             => 0,
                            'required'        => 1,
                            'tabs'            => [
                                'general',
                                'conditions',
                            ],
                            'required_single' => 0,
                        ],
                        2 => [
                            'type'            => 'tel',
                            'title'           => 'Phone',
                            'description'     => '',
                            'value'           => '',
                            'name'            => 'wbls_field_2',
                            'icon'            => '',
                            'order'           => 10,
                            'public'          => true,
                            'class'           => '',
                            'id'              => '',
                            'label'           => 'Phone',
                            'placeholder'     => '',
                            'pro'             => 0,
                            'required'        => 1,
                            'tabs'            => [
                                'general',
                                'conditions',
                            ],
                            'required_single' => 0,
                        ],
                        3 => [
                            'type'        => 'text',
                            'title'       => 'Single Line Text',
                            'description' => '',
                            'value'       => '',
                            'name'        => 'wbls_field_3',
                            'icon'        => '',
                            'order'       => 0,
                            'public'      => true,
                            'class'       => '',
                            'id'          => '',
                            'label'       => 'Website',
                            'placeholder' => 'https://example.com',
                            'pro'         => 0,
                            'required'    => 0,
                            'tabs'        => [
                                'general',
                                'conditions',
                            ],
                        ],
                        4 => [
                            'type'                => 'address',
                            'title'               => 'Address',
                            'description'         => '',
                            'value'               => '',
                            'name'                => 'wbls_field_4',
                            'icon'                => '',
                            'order'               => 9,
                            'public'              => true,
                            'class'               => '',
                            'id'                  => '',
                            'label'               => 'Address',
                            'placeholder'         => '',
                            'pro'                 => 0,
                            'required'            => 0,
                            'streetName'          => 'wbls_field_4_street',
                            'street1Name'         => 'wbls_field_4_street1',
                            'cityName'            => 'wbls_field_4_city',
                            'stateName'           => 'wbls_field_4_state',
                            'postalName'          => 'wbls_field_4_postal',
                            'countryName'         => 'wbls_field_4_country',
                            'streetPlaceholder'   => '',
                            'streetMiniLabel'     => 'Street Address',
                            'street1Placeholder'  => '',
                            'street1MiniLabel'    => 'Street Address Line 2',
                            'cityPlaceholder'     => '',
                            'cityMiniLabel'       => 'City',
                            'statePlaceholder'    => '',
                            'stateMiniLabel'      => 'State / Province / Region',
                            'postalPlaceholder'   => '',
                            'postalMiniLabel'     => 'Postal / Zip Code',
                            'countryPlaceholder'  => '',
                            'countryMiniLabel'    => 'Country',
                            'hideStreet'          => 0,
                            'hideStreet1'         => 0,
                            'hideCity'            => 0,
                            'hideState'           => 0,
                            'hidePostal'          => 0,
                            'hideCountry'         => 0,
                            'tabs'                => [
                                'general',
                                'conditions',
                            ],
                        ],
                        5 => [
                            'type'        => 'submit',
                            'title'       => 'Submit Button',
                            'description' => '',
                            'value'       => '',
                            'name'        => '',
                            'icon'        => '',
                            'order'       => 14,
                            'public'      => true,
                            'class'       => '',
                            'id'          => '',
                            'label'       => 'Submit',
                            'placeholder' => '',
                            'pro'         => 0,
                            'required'    => 0,
                            'tabs'        => [
                                'general',
                                'conditions',
                            ],
                        ],
                    ],
                    'wbls_email_options' => [
                        'sendemail'     => 0,
                        'admin_mail'    => '',
                        'wbls_mail_from'=> '',
                    ],
                    'wbls_form_settings' => [
                        'whistleblower_active'        => 0,
                        'new_case'                    => 'Report a new case',
                        'follow_case'                 => 'Follow up on a case',
                        'login_case'                  => 'Login',
                        'reply_button'                => 'Send',
                        'success_message'             => 'Form successfully submitted',
                        'success_message_copy_token'  => 'Please copy and retain this token for future login and for follow-up on the response.',
                        'error_message'               => 'Something went wrong',
                        'wbls_show_form_after_submit' => 1,
                        'active_theme'                => 6,
                        'file_max_size'               => 10,
                        'file_types'                  => [
                            'jpg',
                            'png',
                            'gif',
                        ],
                        'form_header'                 => '',
                        'token_header'                => '',
                        'login_header'                => '',
                    ],
                    'wbls_fieldNameLastId' => 6,
                ]
            ],
            '2' => [
                'post_title' => 'Innercompany Reporting Form',
                'post_metas' => [
                    'wbls_form_content' => '<div class="wblsform-page-and-images wbls-form-builder">
                                                <div class="wblsform_section">                                            
                                                    <div class="wblsform_column">
                                                        <div class="wblsform-row wbls-label-top wblsform-row-edit-active" data-field-id="0">
                                                        <label class="wbls-field-label">Report Type*</label>
                                                        <div class="wbls-field-row-radio">
                                                        <input class="wbls-field" type="radio" name="wbls_field_0" value="Fraud" required="">
                                                        <label class="wbls-field-miniLabel wbls-radio-label">Fraud</label>
                                                        </div>
                                                        <div class="wbls-field-row-radio">
                                                        <input class="wbls-field" type="radio" name="wbls_field_0" value="Harassment" required="">
                                                        <label class="wbls-field-miniLabel wbls-radio-label">Harassment</label>
                                                        </div>
                                                        <div class="wbls-field-row-radio">
                                                        <input class="wbls-field" type="radio" name="wbls_field_0" value="Compliance Violation" required="">
                                                        <label class="wbls-field-miniLabel wbls-radio-label">Compliance Violation</label>
                                                        </div>
                                                        <div class="wbls-field-row-radio wbls-field-row-radio-new">
                                                        <input class="wbls-field" type="radio" name="wbls_field_5" value="Safety Issue" required="">
                                                        <label class="wbls-field-miniLabel wbls-radio-label">Safety Issue</label>
                                                        </div>
                                                        <div class="wbls-field-row-radio wbls-field-row-radio-new">
                                                        <input class="wbls-field" type="radio" name="wbls_field_5" value="Other" required="">
                                                        <label class="wbls-field-miniLabel wbls-radio-label">Other</label>
                                                        </div>
                                                        <p class="wbls-field-description"></p>            
                                                        </div>
                                                    </div>
                                                    <div class="wblsform_column">
                                                        <div class="wblsform-row wbls-label-top" data-field-id="5">
                                                        <label class="wbls-field-label">Department*</label>
                                                        <div class="wbls-field-row-radio">
                                                        <input class="wbls-field" type="radio" name="wbls_field_5" value="Finance" required="">
                                                        <label class="wbls-field-miniLabel wbls-radio-label">Finance</label>
                                                        </div>
                                                        <div class="wbls-field-row-radio">
                                                        <input class="wbls-field" type="radio" name="wbls_field_5" value="Human Resources" required="">
                                                        <label class="wbls-field-miniLabel wbls-radio-label">Human Resources</label>
                                                        </div>
                                                        <div class="wbls-field-row-radio">
                                                        <input class="wbls-field" type="radio" name="wbls_field_5" value="Legal &amp; Compliance" required="">
                                                        <label class="wbls-field-miniLabel wbls-radio-label">Legal &amp; Compliance</label>
                                                        </div>
                                                        <div class="wbls-field-row-radio wbls-field-row-radio-new">
                                                        <input class="wbls-field" type="radio" name="wbls_field_5" value="IT / Technology" required="">
                                                        <label class="wbls-field-miniLabel wbls-radio-label">IT / Technology</label>
                                                        </div>
                                                        <div class="wbls-field-row-radio wbls-field-row-radio-new">
                                                        <input class="wbls-field" type="radio" name="wbls_field_5" value="Operations" required="">
                                                        <label class="wbls-field-miniLabel wbls-radio-label">Operations</label>
                                                        </div>
                                                        <div class="wbls-field-row-radio wbls-field-row-radio-new">
                                                        <input class="wbls-field" type="radio" name="wbls_field_5" value="Sales &amp; Marketing" required="">
                                                        <label class="wbls-field-miniLabel wbls-radio-label">Sales &amp; Marketing</label>
                                                        </div>
                                                        <div class="wbls-field-row-radio wbls-field-row-radio-new">
                                                        <input class="wbls-field" type="radio" name="wbls_field_5" value="Management" required="">
                                                        <label class="wbls-field-miniLabel wbls-radio-label">Management</label>
                                                        </div>
                                                        <div class="wbls-field-row-radio wbls-field-row-radio-new">
                                                        <input class="wbls-field" type="radio" name="wbls_field_5" value="Other" required="">
                                                        <label class="wbls-field-miniLabel wbls-radio-label">Other</label>
                                                        </div>
                                                        <p class="wbls-field-description"></p>            
                                                        </div>
                                                    </div>
                                                    <div class="wblsform_column">
                                                        <div class="wblsform-row wbls-label-top" data-field-id="1">
                                                        <label class="wbls-field-label">Subject*</label>
                                                        <input class="wbls-field" type="text" name="wbls_field_1" value="" required="">
                                                        <p class="wbls-field-description"></p>            
                                                        </div>
                                                    </div>
                                                    <div class="wblsform_column">    
                                                        <div class="wblsform-row wbls-label-top" data-field-id="2">
                                                        <label class="wbls-field-label">Description*</label>
                                                        <textarea class="wbls-field" name="wbls_field_2" required=""></textarea>
                                                        <p class="wbls-field-description"></p>            
                                                        </div>
                                                    </div>
                                                    <div class="wblsform_column">    
                                                        <div class="wblsform-row wbls-label-top" data-field-id="3">
                                                        <label class="wbls-field-label">Persons Involved (optional)</label>
                                                        <textarea class="wbls-field" name="wbls_field_3"></textarea>
                                                        <p class="wbls-field-description"></p>            
                                                        </div>
                                                    </div>
                                                    <div class="wblsform_column">    
                                                        <div class="wblsform-row wblsform-row-submit wbls-label-top" data-field-id="4">
                                                        <button class="wbls-submit-form">Submit</button>            
                                                        </div>
                                                    </div>                                            
                                                </div>
                                            </div>
                                            ',
                    'wbls_field_options' => [
                        0 => [
                            'type'           => 'radio',
                            'title'          => 'Single Choice',
                            'description'    => '',
                            'value'          => '',
                            'name'           => 'wbls_field_0',
                            'options'        => [
                                ['key' => 'Fraud',               'val' => 'Fraud',               'order' => 1],
                                ['key' => 'Harassment',          'val' => 'Harassment',          'order' => 2],
                                ['key' => 'Compliance Violation','val' => 'Compliance Violation','order' => 3],
                                ['key' => 'Safety Issue',        'val' => 'Safety Issue',        'order' => 3],
                                ['key' => 'Other',               'val' => 'Other',               'order' => 4],
                            ],
                            'default_option' => '',
                            'icon'           => '',
                            'order'          => 3,
                            'public'         => true,
                            'class'          => '',
                            'id'             => '',
                            'label'          => 'Report Type',
                            'pro'            => 0,
                            'required'       => 1,
                            'tabs'           => ['general','conditions'],
                            'required_single'=> 0,
                        ],
                        1 => [
                            'type'           => 'text',
                            'title'          => 'Single Line Text',
                            'description'    => '',
                            'value'          => '',
                            'name'           => 'wbls_field_1',
                            'icon'           => '',
                            'order'          => 0,
                            'public'         => true,
                            'class'          => '',
                            'id'             => '',
                            'label'          => 'Subject',
                            'placeholder'    => '',
                            'pro'            => 0,
                            'required'       => 1,
                            'tabs'           => ['general','conditions'],
                            'required_single'=> 0,
                        ],
                        2 => [
                            'type'           => 'textarea',
                            'title'          => 'Paragraph Text',
                            'description'    => '',
                            'value'          => '',
                            'name'           => 'wbls_field_2',
                            'icon'           => '',
                            'order'          => 1,
                            'public'         => true,
                            'class'          => '',
                            'id'             => '',
                            'label'          => 'Description',
                            'placeholder'    => '',
                            'pro'            => 0,
                            'required'       => 1,
                            'tabs'           => ['general','conditions'],
                            'required_single'=> 0,
                        ],
                        3 => [
                            'type'           => 'textarea',
                            'title'          => 'Paragraph Text',
                            'description'    => '',
                            'value'          => '',
                            'name'           => 'wbls_field_3',
                            'icon'           => '',
                            'order'          => 1,
                            'public'         => true,
                            'class'          => '',
                            'id'             => '',
                            'label'          => 'Persons Involved (optional)',
                            'placeholder'    => '',
                            'pro'            => 0,
                            'required'       => 0,
                            'tabs'           => ['general','conditions'],
                        ],
                        4 => [
                            'type'           => 'submit',
                            'title'          => 'Submit Button',
                            'description'    => '',
                            'value'          => '',
                            'name'           => '',
                            'icon'           => '',
                            'order'          => 14,
                            'public'         => true,
                            'class'          => '',
                            'id'             => '',
                            'label'          => 'Submit',
                            'placeholder'    => '',
                            'pro'            => 0,
                            'required'       => 0,
                            'tabs'           => ['general','conditions'],
                        ],
                        5 => [
                            'type'           => 'radio',
                            'title'          => 'Single Choice',
                            'description'    => '',
                            'value'          => '',
                            'name'           => 'wbls_field_5',
                            'options'        => [
                                ['key' => 'Finance',           'val' => 'Finance',           'order' => 1],
                                ['key' => 'Human Resources',   'val' => 'Human Resources',   'order' => 2],
                                ['key' => 'Legal & Compliance','val' => 'Legal & Compliance','order' => 3],
                                ['key' => 'IT / Technology',   'val' => 'IT / Technology',   'order' => 3],
                                ['key' => 'Operations',        'val' => 'Operations',        'order' => 4],
                                ['key' => 'Sales & Marketing', 'val' => 'Sales & Marketing', 'order' => 5],
                                ['key' => 'Management',        'val' => 'Management',        'order' => 6],
                                ['key' => 'Other',             'val' => 'Other',             'order' => 7],
                            ],
                            'default_option' => '',
                            'icon'           => '',
                            'order'          => 3,
                            'public'         => true,
                            'class'          => '',
                            'id'             => '',
                            'label'          => 'Department',
                            'pro'            => 0,
                            'required'       => 1,
                            'tabs'           => ['general','conditions'],
                            'required_single'=> 0,
                        ],
                    ],
                    'wbls_email_options' => [
                        'sendemail'     => 0,
                        'admin_mail'    => '',
                        'wbls_mail_from'=> '',
                    ],
                    'wbls_form_settings' => [
                        'whistleblower_active'        => 1,
                        'new_case'                    => 'Report a new case',
                        'follow_case'                 => 'Follow up on a case',
                        'login_case'                  => 'Login',
                        'reply_button'                => 'Send',
                        'success_message'             => 'Form successfully submitted',
                        'success_message_copy_token'  => 'Please copy and retain this token for future login and for follow-up on the response.',
                        'error_message'               => 'Something went wrong',
                        'wbls_show_form_after_submit' => 1,
                        'active_theme'                => 6,
                        'file_max_size'               => 10,
                        'file_types'                  => [
                            'jpg',
                            'png',
                            'gif',
                        ],
                        'show_form_header'            => 1,
                        'form_header'                 => "This is our confidential reporting channel. Use this form to report concerns such as fraud, harassment, safety issues, or other violations. Your identity will remain protected, and your report will be treated with respect and seriousness.",
                        'token_header'                => '',
                        'login_header'                => '',
                    ],
                    'wbls_fieldNameLastId' => '6',
                ]
            ],
            '3' => [
                'post_title' => 'Whistleblowing Report Form',
                'post_metas' => [
                    'wbls_form_content' => '<div class="wblsform-page-and-images wbls-form-builder">
                                              <div class="wblsform_section">                                                
                                                <div class="wblsform_column">      
                                                  <div class="wblsform-row wbls-label-top" data-field-id="1">
                                                    <label class="wbls-field-label">Who is make report*</label>
                                                    <div class="wbls-field-row-radio">
                                                      <input class="wbls-field" type="radio" name="wbls_field_1" value="I am a consumer or shareholder" required>
                                                      <label class="wbls-field-miniLabel wbls-radio-label">I am a consumer or shareholder</label>
                                                    </div>
                                                    <div class="wbls-field-row-radio">
                                                      <input class="wbls-field" type="radio" name="wbls_field_1" value="I am an employee or ex-employee with concerns" required>
                                                      <label class="wbls-field-miniLabel wbls-radio-label">I am an employee or ex-employee with concerns</label>
                                                    </div>
                                                    <div class="wbls-field-row-radio">
                                                      <input class="wbls-field" type="radio" name="wbls_field_1" value="Someone I know well witnessed wrongdoing at work" required>
                                                      <label class="wbls-field-miniLabel wbls-radio-label">Someone I know well witnessed wrongdoing at work</label>
                                                    </div>
                                                    <div class="wbls-field-row-radio wbls-field-row-radio-new">
                                                      <input class="wbls-field" type="radio" name="wbls_field_1" value="Someone I know well is committing wrongdoing at work" required>
                                                      <label class="wbls-field-miniLabel wbls-radio-label">Someone I know well is committing wrongdoing at work</label>
                                                    </div>
                                                    <div class="wbls-field-row-radio wbls-field-row-radio-new">
                                                      <input class="wbls-field" type="radio" name="wbls_field_1" value="I want to report wrongdoing on behalf of my employer" required>
                                                      <label class="wbls-field-miniLabel wbls-radio-label">I want to report wrongdoing on behalf of my employer</label>
                                                    </div>
                                                    <p class="wbls-field-description"></p>
                                                  </div>
                                                </div>  
                                                <div class="wblsform_column">  
                                                  <div class="wblsform-row wbls-label-top" data-field-id="2">
                                                    <label class="wbls-field-label">Please provide a brief outline of the issue*</label>
                                                    <textarea class="wbls-field" name="wbls_field_2" required></textarea>
                                                    <p class="wbls-field-description"></p>
                                                  </div>
                                                </div>  
                                                <div class="wblsform_column">  
                                                  <div class="wblsform-row wbls-label-top" data-field-id="3">
                                                    <label class="wbls-field-label">Please provide the names and/or designation of the people involved*</label>
                                                    <textarea class="wbls-field" name="wbls_field_3" required></textarea>
                                                    <p class="wbls-field-description"></p>
                                                  </div>
                                                </div>  
                                                <div class="wblsform_column">  
                                                  <div class="wblsform-row wbls-label-top" data-field-id="4">
                                                    <label class="wbls-field-label">Please enter the time period of the issue in question</label>
                                                    <input class="wbls-field" type="text" name="wbls_field_4" value="">
                                                    <p class="wbls-field-description"></p>
                                                  </div>
                                                </div>  
                                                <div class="wblsform_column">  
                                                  <div class="wblsform-row wbls-label-top" data-field-id="5">
                                                    <label class="wbls-field-label">Is the alleged conduct still ongoing?*</label>
                                                    <div class="wbls-field-row-radio">
                                                      <input class="wbls-field" type="radio" name="wbls_field_5" value="Yes" required>
                                                      <label class="wbls-field-miniLabel wbls-radio-label">Yes</label>
                                                    </div>
                                                    <div class="wbls-field-row-radio">
                                                      <input class="wbls-field" type="radio" name="wbls_field_5" value="No" required>
                                                      <label class="wbls-field-miniLabel wbls-radio-label">No</label>
                                                    </div>
                                                    <div class="wbls-field-row-radio">
                                                      <input class="wbls-field" type="radio" name="wbls_field_5" value="Don\'t know" required>
                                                      <label class="wbls-field-miniLabel wbls-radio-label">Don\'t know</label>
                                                    </div>
                                                    <p class="wbls-field-description"></p>
                                                  </div>
                                                </div>  
                                                <div class="wblsform_column">  
                                                  <div class="wblsform-row wbls-label-top" data-field-id="6">
                                                    <label class="wbls-field-label">Please provide links to documents, photographs and any other proofs supporting your claim</label>
                                                    <textarea class="wbls-field" name="wbls_field_6"></textarea>
                                                    <p class="wbls-field-description"></p>
                                                  </div>
                                                </div>  
                                                <div class="wblsform_column">  
                                                  <div class="wblsform-row wbls-label-top" data-field-id="7">
                                                    <label class="wbls-field-label">What is the nature of your information?*</label>
                                                    <div class="wbls-field-row-radio">
                                                      <input class="wbls-field" type="radio" name="wbls_field_7" value="I heard/saw it myself" checked required>
                                                      <label class="wbls-field-miniLabel wbls-radio-label">I heard/saw it myself</label>
                                                    </div>
                                                    <div class="wbls-field-row-radio">
                                                      <input class="wbls-field" type="radio" name="wbls_field_7" value="I heard people talking about it" required>
                                                      <label class="wbls-field-miniLabel wbls-radio-label">I heard people talking about it</label>
                                                    </div>
                                                    <p class="wbls-field-description"></p>
                                                  </div>
                                                </div>  
                                                <div class="wblsform_column">  
                                                  <div class="wblsform-row wbls-label-top" data-field-id="8">
                                                    <label class="wbls-field-label">Please provide names of superiors you have communicated this with beforehand, if any</label>
                                                    <textarea class="wbls-field" name="wbls_field_8"></textarea>
                                                    <p class="wbls-field-description"></p>
                                                  </div>
                                                </div>  
                                                <div class="wblsform_column">  
                                                  <div class="wblsform-row wbls-label-top" data-field-id="9">
                                                    <label class="wbls-field-label">Declaration of Policy Awareness*</label>
                                                    <div class="wbls-field-row-checkbox">
                                                      <input class="wbls-field" type="checkbox" name="wbls_field_9" value="I hereby confirm that I have read and understood the organization’s Whistleblowing Policy." required>
                                                      <label class="wbls-field-miniLabel wbls-checkbox-label">I hereby confirm that I have read and understood the organization’s Whistleblowing Policy.</label>
                                                    </div>
                                                    <p class="wbls-field-description"></p>
                                                  </div>
                                                </div>  
                                                <div class="wblsform_column">  
                                                  <div class="wblsform-row wbls-label-top" data-field-id="10">
                                                    <label class="wbls-field-label">Declaration of Truthfulness*</label>
                                                    <div class="wbls-field-row-checkbox">
                                                      <input class="wbls-field" type="checkbox" name="wbls_field_10" value="I hereby declare that, to the best of my knowledge, the information I have provided is true and has been submitted voluntarily." required>
                                                      <label class="wbls-field-miniLabel wbls-checkbox-label">I hereby declare that, to the best of my knowledge, the information I have provided is true and has been submitted voluntarily.</label>
                                                    </div>
                                                    <p class="wbls-field-description"></p>
                                                  </div>
                                                </div>  
                                                <div class="wblsform_column">  
                                                  <div class="wblsform-row wbls-label-top wblsform-row-edit-active" data-field-id="11">
                                                    <label class="wbls-field-label">Acknowledgment of Use*</label>
                                                    <div class="wbls-field-row-checkbox">
                                                      <input class="wbls-field" type="checkbox" name="wbls_field_11" value="I understand and acknowledge that the information provided may be used during the investigation and reporting process, and that disclosure of my identity may be required by law, regulatory authorities, or judicial proceedings." required>
                                                      <label class="wbls-field-miniLabel wbls-checkbox-label">I understand and acknowledge that the information provided may be used during the investigation and reporting process, and that disclosure of my identity may be required by law, regulatory authorities, or judicial proceedings.</label>
                                                    </div>
                                                    <p class="wbls-field-description"></p>
                                                  </div>
                                                </div>  
                                                <div class="wblsform_column">  
                                                  <div class="wblsform-row wblsform-row-submit wbls-label-top" data-field-id="0">
                                                    <button class="wbls-submit-form">Submit</button>
                                                  </div>
                                                </div>
                                              </div>
                                            </div>
                                            ',
                    'wbls_field_options' => [
                        0 => [
                            'type'        => 'submit',
                            'title'       => 'Submit Button',
                            'description' => '',
                            'value'       => '',
                            'name'        => '',
                            'icon'        => '',
                            'order'       => 14,
                            'public'      => true,
                            'class'       => '',
                            'id'          => '',
                            'label'       => 'Submit',
                            'placeholder' => '',
                            'pro'         => 0,
                            'required'    => 0,
                            'tabs'        => ['general','conditions'],
                        ],
                        1 => [
                            'type'           => 'radio',
                            'title'          => 'Single Choice',
                            'description'    => '',
                            'value'          => '',
                            'name'           => 'wbls_field_1',
                            'options'        => [
                                ['key' => 'I am a consumer or shareholder',                 'val' => 'I am a consumer or shareholder',                 'order' => 1],
                                ['key' => 'I am an employee or ex-employee with concerns', 'val' => 'I am an employee or ex-employee with concerns', 'order' => 2],
                                ['key' => 'Someone I know well witnessed wrongdoing at work','val' => 'Someone I know well witnessed wrongdoing at work','order' => 3],
                                ['key' => 'Someone I know well is committing wrongdoing at work','val' => 'Someone I know well is committing wrongdoing at work','order' => 3],
                                ['key' => 'I want to report wrongdoing on behalf of my employer','val' => 'I want to report wrongdoing on behalf of my employer','order' => 4],
                            ],
                            'default_option' => '',
                            'icon'           => '',
                            'order'          => 3,
                            'public'         => true,
                            'class'          => '',
                            'id'             => '',
                            'label'          => 'Who is make report',
                            'pro'            => 0,
                            'required'       => 1,
                            'tabs'           => ['general','conditions'],
                            'required_single'=> 0,
                        ],
                        2 => [
                            'type'           => 'textarea',
                            'title'          => 'Paragraph Text',
                            'description'    => '',
                            'value'          => '',
                            'name'           => 'wbls_field_2',
                            'icon'           => '',
                            'order'          => 1,
                            'public'         => true,
                            'class'          => '',
                            'id'             => '',
                            'label'          => 'Please provide a brief outline of the issue',
                            'placeholder'    => '',
                            'pro'            => 0,
                            'required'       => 1,
                            'tabs'           => ['general','conditions'],
                            'required_single'=> 0,
                        ],
                        3 => [
                            'type'           => 'textarea',
                            'title'          => 'Paragraph Text',
                            'description'    => '',
                            'value'          => '',
                            'name'           => 'wbls_field_3',
                            'icon'           => '',
                            'order'          => 1,
                            'public'         => true,
                            'class'          => '',
                            'id'             => '',
                            'label'          => 'Please provide the names and/or designation of the people involved',
                            'placeholder'    => '',
                            'pro'            => 0,
                            'required'       => 1,
                            'tabs'           => ['general','conditions'],
                            'required_single'=> 0,
                        ],
                        4 => [
                            'type'           => 'text',
                            'title'          => 'Single Line Text',
                            'description'    => '',
                            'value'          => '',
                            'name'           => 'wbls_field_4',
                            'icon'           => '',
                            'order'          => 0,
                            'public'         => true,
                            'class'          => '',
                            'id'             => '',
                            'label'          => 'Please enter the time period of the issue in question',
                            'placeholder'    => '',
                            'pro'            => 0,
                            'required'       => 0,
                            'tabs'           => ['general','conditions'],
                        ],
                        5 => [
                            'type'           => 'radio',
                            'title'          => 'Single Choice',
                            'description'    => '',
                            'value'          => '',
                            'name'           => 'wbls_field_5',
                            'options'        => [
                                ['key' => 'Yes',       'val' => 'Yes',       'order' => 1],
                                ['key' => 'No',        'val' => 'No',        'order' => 2],
                                ['key' => 'Don\'t know','val' => 'Don\'t know','order' => 3],
                            ],
                            'default_option' => '',
                            'icon'           => '',
                            'order'          => 3,
                            'public'         => true,
                            'class'          => '',
                            'id'             => '',
                            'label'          => 'Is the alleged conduct still ongoing?',
                            'pro'            => 0,
                            'required'       => 1,
                            'tabs'           => ['general','conditions'],
                            'required_single'=> 0,
                        ],
                        6 => [
                            'type'           => 'textarea',
                            'title'          => 'Paragraph Text',
                            'description'    => '',
                            'value'          => '',
                            'name'           => 'wbls_field_6',
                            'icon'           => '',
                            'order'          => 1,
                            'public'         => true,
                            'class'          => '',
                            'id'             => '',
                            'label'          => 'Please provide links to documents, photographs and any other proofs supporting your claim',
                            'placeholder'    => '',
                            'pro'            => 0,
                            'required'       => 0,
                            'tabs'           => ['general','conditions'],
                        ],
                        7 => [
                            'type'           => 'radio',
                            'title'          => 'Single Choice',
                            'description'    => '',
                            'value'          => '',
                            'name'           => 'wbls_field_7',
                            'options'        => [
                                ['key' => 'I heard/saw it myself',     'val' => 'I heard/saw it myself',     'order' => 1],
                                ['key' => 'I heard people talking about it','val' => 'I heard people talking about it','order' => 2],
                            ],
                            'default_option' => 0,
                            'icon'           => '',
                            'order'          => 3,
                            'public'         => true,
                            'class'          => '',
                            'id'             => '',
                            'label'          => 'What is the nature of your information?',
                            'pro'            => 0,
                            'required'       => 1,
                            'tabs'           => ['general','conditions'],
                            'required_single'=> 0,
                        ],
                        8 => [
                            'type'           => 'textarea',
                            'title'          => 'Paragraph Text',
                            'description'    => '',
                            'value'          => '',
                            'name'           => 'wbls_field_8',
                            'icon'           => '',
                            'order'          => 1,
                            'public'         => true,
                            'class'          => '',
                            'id'             => '',
                            'label'          => 'Please provide names of superiors you have communicated this with beforehand, if any',
                            'placeholder'    => '',
                            'pro'            => 0,
                            'required'       => 0,
                            'tabs'           => ['general','conditions'],
                        ],
                        9 => [
                            'type'           => 'checkbox',
                            'title'          => 'Checkbox',
                            'description'    => '',
                            'value'          => '',
                            'name'           => '',
                            'options'        => [
                                [
                                    'miniLabel' => 'I hereby confirm that I have read and understood the organization’s Whistleblowing Policy.',
                                    'name'      => 'wbls_field_9',
                                    'checked'   => 0,
                                    'order'     => 1,
                                ],
                            ],
                            'icon'           => '',
                            'order'          => 2,
                            'public'         => true,
                            'class'          => '',
                            'id'             => '',
                            'label'          => 'Declaration of Policy Awareness*',
                            'pro'            => 0,
                            'required'       => 1,
                            'required_single'=> 0,
                            'tabs'           => ['general','conditions'],
                        ],
                        10 => [
                            'type'           => 'checkbox',
                            'title'          => 'Checkbox',
                            'description'    => '',
                            'value'          => '',
                            'name'           => '',
                            'options'        => [
                                [
                                    'miniLabel' => 'I hereby declare that, to the best of my knowledge, the information I have provided is true and has been submitted voluntarily.',
                                    'name'      => 'wbls_field_10',
                                    'checked'   => 0,
                                    'order'     => 1,
                                ],
                            ],
                            'icon'           => '',
                            'order'          => 2,
                            'public'         => true,
                            'class'          => '',
                            'id'             => '',
                            'label'          => 'Declaration of Truthfulness',
                            'pro'            => 0,
                            'required'       => 1,
                            'required_single'=> 0,
                            'tabs'           => ['general','conditions'],
                        ],
                        11 => [
                            'type'           => 'checkbox',
                            'title'          => 'Checkbox',
                            'description'    => '',
                            'value'          => '',
                            'name'           => '',
                            'options'        => [
                                [
                                    'miniLabel' => 'I understand and acknowledge that the information provided may be used during the investigation and reporting process, and that disclosure of my identity may be required by law, regulatory authorities, or judicial proceedings.',
                                    'name'      => 'wbls_field_11',
                                    'checked'   => 0,
                                    'order'     => 1,
                                ],
                            ],
                            'icon'           => '',
                            'order'          => 2,
                            'public'         => true,
                            'class'          => '',
                            'id'             => '',
                            'label'          => 'Acknowledgment of Use',
                            'pro'            => 0,
                            'required'       => 1,
                            'required_single'=> 0,
                            'tabs'           => ['general','conditions'],
                        ],
                    ],
                    'wbls_email_options' => [
                        'sendemail'     => 0,
                        'admin_mail'    => '',
                        'wbls_mail_from'=> '',
                    ],
                    'wbls_form_settings' => [
                        'whistleblower_active'        => 1,
                        'new_case'                    => 'Report a new case',
                        'follow_case'                 => 'Follow up on a case',
                        'login_case'                  => 'Login',
                        'reply_button'                => 'Send',
                        'success_message'             => 'Form successfully submitted',
                        'success_message_copy_token'  => 'Please copy and retain this token for future login and for follow-up on the response.',
                        'error_message'               => 'Something went wrong',
                        'wbls_show_form_after_submit' => 1,
                        'active_theme'                => 6,
                        'file_max_size'               => 10,
                        'file_types'                  => [
                            'jpg',
                            'png',
                            'gif',
                        ],
                        'show_form_header'            => 1,
                        'show_token_header'           => 1,
                        'show_login_header'           => 1,
                        'form_header'                 => "Whistleblowing report",
                        'token_header'                => '',
                        'login_header'                => '',
                    ],
                    'wbls_fieldNameLastId' => 12,
                ],
            ]
        ];
    }

    public function createForms() {

        foreach ( $this->forms as $form ) {
            $post_data = [
                'post_title'   => $form['post_title'],
                'post_type'    => 'wbls_form',
                'post_status'  => 'publish',
                'post_content' => '', // Optional default content
            ];
            $post_id = wp_insert_post( $post_data );

            if ( $post_id && ! is_wp_error( $post_id ) ) {
                // Update content with shortcode referencing its own ID
                wp_update_post([
                    'ID'           => $post_id,
                    'post_content' => '[wblsform id="' . $post_id . '"]',
                ]);

                foreach ( $form['post_metas'] as $key => $val ) {
                    add_post_meta($post_id, $key, $val);
                }
            }
        }

        // Set flag so this runs only once
        update_option( 'wbls_default_forms_created', 1 );
    }

}