jQuery(document).ready( function () {
    jQuery(document)
        .off("click", ".wbls-pro-tooltip-action")
        .on("click", ".wbls-pro-tooltip-action", function (e) {
            e.preventDefault();
            let template = jQuery(document).find("#wbls-buy-pro-banner-template").html();
            jQuery("body").append(template);
    });

    jQuery(document)
        .off("click", ".wbls-pro-banner-layout")
        .on("click", ".wbls-pro-banner-layout", function () {
            let template = jQuery(document).find("#wbls-buy-pro-banner-template").html();
            jQuery(document).find(".wbls-pro-banner-layout").remove();
    });

    jQuery(document)
        .off("click", ".wbls-delete-form")
        .on("click", ".wbls-delete-form", function(e) {
            e.preventDefault();
            if (confirm("Are you sure you want to delete the form, including all submissions?") == true) {
                self.wbls_remove_form(this);
            }
    });

    jQuery(document)
        .off("click", ".wbls-delete-theme")
        .on("click", ".wbls-delete-theme", function(e) {
            e.preventDefault();
            if (confirm("Are you sure you want to delete the theme?") == true) {
                self.wbls_remove_theme(this);
            }
    });

    jQuery(document)
        .off("click", ".wbls-save-settings")
        .on("click", ".wbls-save-settings", function(e) {
            e.preventDefault();
            wbls_save_settings(this);
    });

    jQuery(document)
        .off("click", ".wbls-bulk-action-apply")
        .on("click", ".wbls-bulk-action-apply", function(e) {
            e.preventDefault();
            wbls_bulk_action(this);
    });

    const wbls_edit_page = jQuery(".wbls-edit-page");
    if( wbls_edit_page.length && wbls_edit_page.find(".wbls-trial-pro-header").length ) {
        wbls_edit_page.addClass("wbls-edit-page-trial-banner")
    }
    /* Trial functionality */
    trial_events_register();
});

function wbls_bulk_action(that) {
    let action_type = jQuery(that).closest(".wbls-bulk-action-row").find(".wbls-bulk-actions").val();
    jQuery(document).find(".wbls-response-message").empty().addClass('wbls-hidden');
    if( action_type == -1 ) {
        return;
    }

    let ids = [];
    jQuery(".wbls-single-submissions").each(function() {
        if( jQuery(this).is(':checked') ) {
            ids.push(jQuery(this).attr("data-id"));
        }
    });

    if( !ids.length ) {
        return;
    }
    let button_title = jQuery(that).text();
    jQuery(that).empty()
    jQuery(that).addClass("wbls-button-loading");
    let data = {
        nonce : wbls_admin.ajaxnonce,
        task : 'submissions_wbls_bulk_action',
        action : 'wbls_admin_ajax',
        action_type : action_type,
        ids : ids
    };


    jQuery.ajax({
        type: 'POST',
        url: ajaxurl,
        data:  data,
        success: function (response){
            if( !response['success'] ) {
                jQuery(".wbls-response-message").addClass("wbls-error-message").empty().text(response['data']['message']).removeClass('wbls-hidden');
            }
            else if( response['success'] ) {
                jQuery(".wbls-single-submissions").each(function() {
                    if( jQuery(this).is(':checked') ) {
                        ids.push(jQuery(this).attr("data-id"));
                    }
                });

                // Construct a single jQuery selector from the array
                const selector = ids.map(id => `[data-id='${id}']`).join(',');

                if ( action_type == 'delete' ) {
                    // Remove all matching elements in one go
                    jQuery(selector).closest('tr').remove();
                } else {
                    let action_title = 'Active';
                    switch ( action_type ) {
                        case "block":
                            action_title = 'Blocked';
                            break;
                        case "complete":
                            action_title = 'Completed';
                            break;
                    }
                    jQuery(selector).closest('tr').find(".wbls-status-button-title").text(action_title);
                }

                jQuery(".wbls-response-message").addClass("wbls-success-message").empty().text(response['data']['message']).removeClass('wbls-hidden');
            } else {
                jQuery(".wbls-response-message").addClass("wbls-error-message").empty().text(wbls_admin.form_error_delete).removeClass('wbls-hidden');
            }
        },
        complete: function () {
            jQuery(that).removeClass("wbls-button-loading");
            jQuery(that).text(button_title);
        },
        error: function (jqXHR, exception) {
            jQuery(".wbls-response-message").addClass("wbls-error-message").empty().text(wbls_admin.form_error_delete).removeClass('wbls-hidden');
        },

    });

}

function wbls_save_settings(that) {

    let reCAPTCHA_v2_site_key = '';
    let reCAPTCHA_v2_secret_key = '';
    let reCAPTCHA_language = '';
    let reCAPTCHA_v3_site_key = '';
    let reCAPTCHA_v3_secret_key = '';
    let teeny_active = jQuery(document).find(".wbls-teeny_active:checked").val();
    let user_token_visibility_active = jQuery(document).find(".user_token_visibility_active:checked").val();
    let logs_active = jQuery(document).find(".wbls-logs_active:checked").val();
    let logs_lifetime = jQuery(document).find(".wbls-logs_lifetime").val();
    jQuery(that).addClass("wbls-button-loading");
    
    let data = {
        nonce : wbls_admin.ajaxnonce,
        task : 'wbls_save_settings',
        action : 'wbls_admin_ajax',
        reCAPTCHA_v2_site_key : reCAPTCHA_v2_site_key,
        reCAPTCHA_v2_secret_key : reCAPTCHA_v2_secret_key,
        reCAPTCHA_language : reCAPTCHA_language,
        reCAPTCHA_v3_site_key : reCAPTCHA_v3_site_key,
        reCAPTCHA_v3_secret_key : reCAPTCHA_v3_secret_key,
        teeny_active : teeny_active,
        logs_active : logs_active,
        logs_lifetime : logs_lifetime,
        user_token_visibility_active : user_token_visibility_active
    };

    jQuery.ajax({
        type: 'POST',
        url: ajaxurl,
        data:  data,
        success: function (response){
            if( !response['success'] ) {
                if( typeof response['data'] != 'undefined' &&  typeof response['data']['message'] != 'undefined') {
                    jQuery(".wbls-response-message").addClass("wbls-error-message").empty().text(response['data']['message']).removeClass('wbls-hidden');
                } else {
                    jQuery(".wbls-response-message").addClass("wbls-error-message").empty().text(wbls_admin.form_error_delete).removeClass('wbls-hidden');
                }
                jQuery(that).removeClass("wbls-button-loading").addClass("wbls-button-loading-error");
            }
            else if( response['success'] ) {
                jQuery(".wbls-response-message").addClass("wbls-success-message").empty().text(wbls_admin.success_save).removeClass('wbls-hidden');
                jQuery(that).removeClass("wbls-button-loading").addClass("wbls-button-loading-success");
            } else {
                jQuery(".wbls-response-message").addClass("wbls-error-message").empty().text(wbls_admin.form_error_delete).removeClass('wbls-hidden');
                jQuery(that).removeClass("wbls-button-loading").addClass("wbls-button-loading-error");
            }
        },
        error: function (jqXHR, exception) {
            jQuery(".wbls-response-message").addClass("wbls-error-message").empty().text(wbls_admin.form_error_delete).removeClass('wbls-hidden');
        },
        complete: function() {
            setTimeout(function() {
                jQuery(that).removeClass("wbls-button-loading-success").removeClass("wbls-button-loading-error");
            },2000);
        }
    });

}

function wbls_remove_form(that) {

    jQuery(that).closest('.wbls-forms-list-row').addClass("wbls-loading");
    jQuery(".wbls-response-message").removeClass("wbls-error-message").removeClass("wbls-success-message").addClass('wbls-hidden');

    let id = jQuery(that).attr("data-id");
    let data = {};
    data['id'] = id;
    data['nonce'] = wbls_admin.ajaxnonce;
    data['task'] = 'remove_form';
    data['action'] = "wbls_admin_ajax";
    jQuery.ajax({
        type: 'POST',
        url: ajaxurl,
        data:  data,
        success: function (response){
            if( !response['success'] ) {
                jQuery(".wbls-response-message").addClass("wbls-error-message").empty().text(wbls_admin.form_error_delete).removeClass('wbls-hidden');
            }
            else if( response['success'] ) {
                jQuery(".wbls-response-message").addClass("wbls-success-message").empty().text(wbls_admin.form_success_delete).removeClass('wbls-hidden');
                jQuery(that).closest('.wbls-forms-list-row').remove();
            } else {
                jQuery(".wbls-response-message").addClass("wbls-error-message").empty().text(wbls_admin.form_error_delete).removeClass('wbls-hidden');
            }
        },
        complete: function() {
            jQuery(that).closest('.wbls-forms-list-row').removeClass("wbls-loading");
        },
        error: function (jqXHR, exception) {
            jQuery(".wbls-response-message").addClass("wbls-error-message").empty().text(wbls_admin.form_error_delete).removeClass('wbls-hidden');
        },

    });
}

function wbls_remove_theme(that) {

    jQuery(that).closest('.wbls-forms-list-row').addClass("wbls-loading");
    jQuery(".wbls-response-message").removeClass("wbls-error-message").removeClass("wbls-success-message").addClass('wbls-hidden');

    let id = jQuery(that).attr("data-id");
    let data = {};
    data['id'] = id;
    data['nonce'] = wbls_admin.ajaxnonce;
    data['task'] = 'remove_theme';
    data['action'] = "wbls_admin_ajax";
    jQuery.ajax({
        type: 'POST',
        url: ajaxurl,
        data:  data,
        success: function (response){
            if( !response['success'] ) {
                jQuery(".wbls-response-message").addClass("wbls-error-message").empty().text(wbls_admin.form_error_delete).removeClass('wbls-hidden');
            }
            else if( response['success'] ) {
                jQuery(".wbls-response-message").addClass("wbls-success-message").empty().text(wbls_admin.theme_success_delete).removeClass('wbls-hidden');
                jQuery(that).closest('.wbls-forms-list-row').remove();
            } else {
                jQuery(".wbls-response-message").addClass("wbls-error-message").empty().text(wbls_admin.form_error_delete).removeClass('wbls-hidden');
            }
        },
        complete: function() {
            jQuery(that).closest('.wbls-forms-list-row').removeClass("wbls-loading");
        },
        error: function (jqXHR, exception) {
            jQuery(".wbls-response-message").addClass("wbls-error-message").empty().text(wbls_admin.form_error_delete).removeClass('wbls-hidden');
        },

    });
}

/* Trial functions started */
function trial_events_register() {
    if( jQuery(document).find(".wbls-trial-auto-popup").length ) {
        setTimeout(function () {
            wbls_show_trial_popup();
        },2000);
    }

    jQuery(document).on("click", ".wbls-trial-close, .wbls-pro-trial-layout", function(e) {
        e.preventDefault();
        jQuery('.wbls-pro-trial-container').fadeOut(180, function () {
            jQuery('.wbls-pro-trial-container').css({ opacity: 0, transform: 'translate(-50%, -50%) scale(0.98)' });
        });
        jQuery('.wbls-pro-trial-layout').fadeOut(180);
        jQuery('#wbls-trial-error-container,#wbls-progress-container, #wbls-trial-progress-error-content').addClass('wbls-hidden');
    });

    jQuery(document).on("click", ".wbls-trial-cta", function(e) {
        e.preventDefault();
        wbls_show_trial_popup();
    });
}

function wbls_show_trial_popup() {
    const $overlay = jQuery('.wbls-pro-trial-layout');
    const $popup   = jQuery('.wbls-pro-trial-container');

    $overlay.removeClass('wbls-hidden');
    $popup.removeClass('wbls-hidden').css({ opacity: 0, transform: 'translate(-50%, -50%) scale(0.98)' });

    // Show after 5 seconds

    $overlay.fadeIn(250);

    $popup
    .css('display', 'flex')
    .animate({ opacity: 1 }, {
        duration: 280,
        step: function (now, fx) {
            if (fx.prop === 'opacity') {
                var scale = 0.98 + (now * 0.02);
                jQuery(this).css('transform', 'translate(-50%, -50%) scale(' + scale + ')');
            }
        },
        complete: function () {
            jQuery(this).css('transform', 'translate(-50%, -50%) scale(1)');
        }
    });
}