jQuery(function($){
    const $formSelect = $('#wbls_form_id');
    const $caseField  = $('#wbls-submission-field'); // container, not the whole filters row

    function toggleCaseField() {
        if ($formSelect.val() === '') {
            $caseField.hide();
            $caseField.find('input').val('');
        } else {
            $caseField.show();
        }
    }

    toggleCaseField();
    $formSelect.on('change', toggleCaseField);

    // message toggle stays the same
    $(document).on('click', '.toggle-msg', function(e){
        e.preventDefault();
        const $td = $(this).closest('td');
        $td.find('.short, .full').toggleClass('hidden');
        $(this).text($(this).text() === 'View more' ? 'Hide' : 'View more');
    });


    // Select all
    $('#wbls-check-all').on('change', function(){
        const checked = $(this).is(':checked');
        $('.wbls-row-check').prop('checked', checked).trigger('change');
    });

    // Toggle delete button enabled state
    function toggleDeleteBtn() {
        const anyChecked = $('.wbls-row-check:checked').length > 0;
        $('#wbls-delete-selected').prop('disabled', !anyChecked);
    }
    $(document).on('change', '.wbls-row-check', toggleDeleteBtn);
    toggleDeleteBtn();

    // Confirm before delete
    $('#wbls-logs-bulk-form').on('submit', function(e){
        if ($('#wbls-delete-selected').is(':disabled')) {
            e.preventDefault();
            return;
        }
        if (!confirm('Delete selected log rows? This cannot be undone.')) {
            e.preventDefault();
        }
    });


    
});
