jQuery(document).ready(function (){
    function activateTab(tabId) {
        if (!tabId) return;

        // Remove previous active tab
        jQuery(".wbls-tab-item").removeClass("wbls-tab-item-active");
        jQuery(".wbls-tab-content").hide();

        // Activate the new tab
        const $tab = jQuery(`#${tabId}`);
        $tab.addClass("wbls-tab-item-active");

        // Show the matching content by class
        jQuery(`.wbls-tab-content.${tabId}-content`).show();
    }

    // Handle click on tab
    jQuery(".wbls-tab-item").on("click", function() {
        const active_id = jQuery(this).attr("id");
        activateTab(active_id);

        // Optional: update URL hash
        window.location.hash = active_id;
    });

    // Handle hash on load
    const hash = window.location.hash.replace('#', '');
    if (hash && jQuery(`#${hash}`).hasClass('wbls-tab-item')) {
        activateTab(hash);
    }

    // Optional: handle hash change (back/forward navigation)
    jQuery(window).on("hashchange", function() {
        const newHash = window.location.hash.replace('#', '');
        if (newHash && jQuery(`#${newHash}`).hasClass('wbls-tab-item')) {
            activateTab(newHash);
        }
    });
    
});