<?php
namespace WBLS_WhistleBlower\Free;
use WBLS_WhistleBlower\Free\WBLSLibrary;
use WP_Query;

if ( ! defined( 'ABSPATH' ) ) exit;

class WBLS_ControllerSubmissions {
    public function __construct( $task ) {
        $method_name = str_replace('submissions_', '', $task);

        if ( method_exists($this, $method_name) && $method_name !== '__construct' ) {
            $this->$method_name();
        }
    }

    public function wbls_change_status() {
        $nonce = isset($_POST['nonce']) ? sanitize_text_field(wp_unslash($_POST['nonce'])) : '';
        if ( ! wp_verify_nonce( $nonce, 'wbls_ajax_nonce' ) || ! current_user_can('manage_options') ) {
            wp_send_json_error(["nonce" => 'false']);
        }

        $submission_id = isset($_POST['submission_id']) ? intval($_POST['submission_id']) : 0;
        $form_id = isset($_POST['form_id']) ? intval($_POST['form_id']) : 0;
        $status_id = isset($_POST['status_id']) ? intval($_POST['status_id']) : 0;
        $current_status_id = isset($_POST['current_status_id']) ? intval($_POST['current_status_id']) : 0;

        $statuses = ['Active', 'Completed', 'Blocked'];
        update_post_meta( $submission_id, 'wbls_submission_status', $status_id );

        $current_user = wp_get_current_user();
        $created_by = 'admin_na';
        // The standard, most reliable check
        if ( is_user_logged_in() ) {
            $username = $current_user->user_login;
            $created_by = $username;
        }

        \WBLS_WhistleBlower\Free\WBLS_Logger::log( 'status_changed',
            'success',
            'Status changed from ' . $statuses[$current_status_id] . ' to ' . $statuses[$status_id],
            [
                'form_id' => $form_id,
                'submission_id' => $submission_id,
                'created_by' => $created_by,
            ]);

        wp_send_json_success();
    }

    public function wbls_remove_submission() {
        $nonce = isset($_POST['nonce']) ? sanitize_text_field(wp_unslash($_POST['nonce'])) : '';
        if ( ! wp_verify_nonce( $nonce, 'wbls_ajax_nonce' ) || ! current_user_can('manage_options') ) {
            wp_send_json_error(["nonce" => 'false']);
        }

        $submission_id = isset($_POST['submission_id']) ? intval($_POST['submission_id']) : 0;
        $form_id = isset($_POST['form_id']) ? intval($_POST['form_id']) : 0;
        global $wpdb;
        $delete = $wpdb->query("DELETE p, pm FROM " . $wpdb->prefix . "posts p INNER JOIN " . $wpdb->prefix . "postmeta pm ON pm.post_id = p.ID
                                        WHERE p.ID=" . intval($submission_id));

        $current_user = wp_get_current_user();
        $created_by = 'admin_na';
        // The standard, most reliable check
        if ( is_user_logged_in() ) {
            $username = $current_user->user_login;
            $created_by = $username;
        }

        \WBLS_WhistleBlower\Free\WBLS_Logger::log( 'submission_deleted',
            'success',
            'Submission with ID ' . $submission_id . ' has been deleted.',
            [
                'form_id' => $form_id,
                'submission_id' => $submission_id,
                'created_by' => $created_by,
            ]);

        wp_send_json_success(["delete" => $delete]);
    }

    public function wbls_remove_all_submission() {
        $nonce = isset($_POST['nonce']) ? sanitize_text_field(wp_unslash($_POST['nonce'])) : '';
        if ( ! wp_verify_nonce( $nonce, 'wbls_ajax_nonce' ) || ! current_user_can('manage_options') ) {
            wp_send_json_error(["nonce" => 'false']);
        }

        $id = isset($_POST['id']) ? intval($_POST['id']) : 0;
        $args = array(
            'post_type'		=>	'wbls_form_subm',
            'post_status' => 'closed',
            'meta_query'	=>	array(
                array(
                    'key'	=>	'wbls_form_id',
                    'value'	=>	$id,
                )
            ),
            "numberposts" => 1000,
            "posts_per_page" => 1000,
        );
        $query = new WP_Query( $args );
        if ( $query->posts ) {
            foreach ( $query->posts as $post ) {
                wp_delete_post( $post->ID, true ); // true = force delete (bypass trash)
            }
        }

        $current_user = wp_get_current_user();
        $created_by = 'admin_na';
        // The standard, most reliable check
        if ( is_user_logged_in() ) {
            $username = $current_user->user_login;
            $created_by = $username;
        }

        \WBLS_WhistleBlower\Free\WBLS_Logger::log( 'submission_deleted',
            'success',
            'All submissions for form ID ' . $id . ' have been deleted.',
            [
                'form_id' => $id,
                'submission_id' => 0,
                'created_by' => $created_by,
            ]);

        wp_send_json_success();
    }

    public function wbls_bulk_action() {
        /* Pro started */
        $nonce = isset($_POST['nonce']) ? sanitize_text_field(wp_unslash($_POST['nonce'])) : '';
        if ( ! wp_verify_nonce( $nonce, 'wbls_ajax_nonce' ) || ! current_user_can('manage_options') ) {
            wp_send_json_error(["nonce" => 'false']);
        }

        // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
        $ids = isset($_POST['ids']) ? WBLSLibrary::sanitize_array(wp_unslash($_POST['ids']), 'intval') : '';

        $action_type = isset($_POST['action_type']) ? 'bulk_' . sanitize_text_field(wp_unslash($_POST['action_type'])) : '';
        if ( $action_type === 'bulk_activate' || $action_type === 'bulk_block' || $action_type === 'bulk_complete' ) {
            $this->bulk_status_change( $ids, $action_type );
        }
        elseif ( method_exists($this, $action_type) ) {
            $this->$action_type( $ids );
        }
        wp_send_json_success();
        /* Pro end */
    }

    public function bulk_status_change( $ids, $status ) {
        if (!empty($ids)) {
            $st = 0;
            switch ($status) {
                case "bulk_block":
                    $st = 2;
                    break;
                case "bulk_complete":
                    $st = 1;
                    break;
            }

            $current_user = wp_get_current_user();
            $created_by = 'admin_na';
            // The standard, most reliable check
            if ( is_user_logged_in() ) {
                $username = $current_user->user_login;
                $created_by = $username;
            }

            $form_id = get_post_meta($ids[0], 'wbls_form_id', true);
            $statuses = ['Active', 'Completed', 'Blocked'];
            foreach ( $ids as $id ) {
                $current_status = get_post_meta( $id, 'wbls_submission_status', true );
                update_post_meta( $id, 'wbls_submission_status', $st );

                \WBLS_WhistleBlower\Free\WBLS_Logger::log( 'status_changed',
                    'success',
                    'Status changed from ' . $statuses[$current_status] . ' to ' . $statuses[$st],
                    [
                        'form_id' => intval($form_id),
                        'submission_id' => $id,
                        'created_by' => $created_by,
                    ]);


            }

            wp_send_json_success(["message" => 'The statuses were changed successfully.']);
        }
        wp_send_json_error(["message" => 'There is no selected submission to delete']);

    }

    public function bulk_delete( $ids = [] ) {
        global $wpdb;

        // Normalize and sanitize the IDs array.
        $ids = array_map( 'absint', (array) $ids );
        $ids = array_filter( $ids ); // remove invalid or zero IDs

        if ( empty( $ids ) ) {
            wp_send_json_error( [ 'message' => 'There is no selected submission to delete' ] );
        }

        // Build placeholders: %d,%d,%d...
        $placeholders = implode( ',', array_fill( 0, count( $ids ), '%d' ) );
        $sql = "DELETE p, pm FROM {$wpdb->posts} p INNER JOIN {$wpdb->postmeta} pm ON pm.post_id = p.ID WHERE p.ID IN ($placeholders)";

        // Prepare with all IDs as individual parameters
        // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared
        $wpdb->query( $wpdb->prepare( $sql, $ids ) );

        $current_user = wp_get_current_user();
        $created_by = 'admin_na';
        // The standard, most reliable check
        if ( is_user_logged_in() ) {
            $username = $current_user->user_login;
            $created_by = $username;
        }

        $form_id = get_post_meta($ids[0], 'wbls_form_id', true);
        foreach( $ids as $id ) {
            \WBLS_WhistleBlower\Free\WBLS_Logger::log( 'submission_deleted',
                'success',
                'The submission with ID ' . $id . ' has been deleted.',
                [
                    'form_id' => intval($form_id),
                    'submission_id' => $id,
                    'created_by' => $created_by,
                ]);

        }

        wp_send_json_success( [ 'message' => 'Submissions successfully deleted' ] );
    }

    public function get_submissions( $form_id = 0, $ids = '' ) {
        $submissions = [];
        $args = array(
            'post_type' => 'wbls_form_subm',
            'post_status' => 'closed',
            'meta_query' => array(
                array(
                    'key' => 'wbls_form_id',
                    'value' => $form_id,
                    'compare' => '=',
                )
            ),
            "numberposts" => 1000,
            "posts_per_page" => 1000,
        );
        $query = new WP_Query($args);

        if ( $query->posts ) {
            foreach ( $query->posts as $post ) {
                $submissions[] = $post->ID;
            }
        }
        return $submissions;
    }

    /* Pro start */
    public function wbls_export_csv(){}

    public function wbls_decrypt_image_preview() {}

    public function wbls_handle_ajax_download() {}
    /* Pro end */
}