<?php
use WBLS_WhistleBlower\Free\WBLSLibrary;

if ( ! defined('ABSPATH') ) exit; // Exit if accessed directly

add_action("admin_footer", function() {

    $screen = get_current_screen();
    if (!$screen) { return; }

    // Adjust IDs to your pages:
    $allowed_ids = [
            'toplevel_page_whistleblower_forms',
            'admin_page_whistleblower_form_edit',
            'whistleblower_page_whistleblower_submissions',
            'admin_page_whistleblower_submission_edit',
            'whistleblower_page_whistleblower_settings',
            'whistleblower_page_whistleblower_themes',
            'admin_page_whistleblower_theme_edit',
            'whistleblower_page_whistleblower_logs',
    ];
    if ( !in_array($screen->id, $allowed_ids, true) ) {
       return;
    }

    $wbls_trial_popup_shown = get_option("wbls_trial_popup_shown", false);
    $additional_class = ' wbls-trial-auto-popup';
    if ( $wbls_trial_popup_shown ) {
        $additional_class = '';
    } else {
        update_option("wbls_trial_popup_shown", true);
    }
    ob_start();
    ?>
    <div class="wbls-pro-trial-layout"></div>
    <div class="wbls-pro-trial-container<?php echo esc_attr($additional_class); ?>">
        <div class="wbls-pro-trial-col1">
            <div class="wbls-pro-trial-header-row">
                <img src="<?php echo esc_url(WBLS_URL . '/admin/assets/images/whistleblowing_logo.png'); ?>">
                <h2><?php esc_html_e('Whistleblowing System', 'whistleblowing-system'); ?></h2>
            </div>
            <ul class="wbls-pro-trial-items">
                <li class="wbls-pro-trial-item">
                    <i class="dashicons dashicons-lock"></i>
                    <div>
                        <b><?php esc_html_e('Full Data Encryption', 'whistleblowing-system'); ?></b>
                        <span><?php esc_html_e('– No IPs or metadata stored.', 'whistleblowing-system'); ?></span>
                    </div>
                </li>
                <li class="wbls-pro-trial-item">
                    <i class="dashicons dashicons-shield"></i>
                    <div>
                        <b><?php esc_html_e('Anonymous Communication', 'whistleblowing-system'); ?></b>
                        <span><?php esc_html_e('– Secure back-and-forth via tokens.', 'whistleblowing-system'); ?></span>
                    </div>
                </li>
                <li class="wbls-pro-trial-item">
                    <i class="dashicons dashicons-feedback"></i>
                    <div>
                        <b><?php esc_html_e('Multi-Step Forms', 'whistleblowing-system'); ?></b>
                        <span><?php esc_html_e('– Smooth next/previous navigation.', 'whistleblowing-system'); ?></span>
                    </div>
                </li>
                <li class="wbls-pro-trial-item">
                    <i class="dashicons dashicons-admin-appearance"></i>
                    <div>
                        <b><?php esc_html_e('Customizable Themes', 'whistleblowing-system'); ?></b>
                        <span><?php esc_html_e('– Match your site design.', 'whistleblowing-system'); ?></span>
                    </div>
                </li>
                <li class="wbls-pro-trial-item">
                    <i class="dashicons dashicons-database-export"></i>
                    <div>
                        <b><?php esc_html_e('CSV Export', 'whistleblowing-system'); ?></b>
                        <span><?php esc_html_e('– Manage submissions easily.', 'whistleblowing-system'); ?></span>
                    </div>
                </li>
                <li class="wbls-pro-trial-item">
                    <i class="dashicons dashicons-update-alt"></i>
                    <div>
                        <b><?php esc_html_e('Incoming/Outgoing Webhooks', 'whistleblowing-system'); ?></b>
                        <span><?php esc_html_e('– Full data integration.', 'whistleblowing-system'); ?></span>
                    </div>
                </li>
                <li class="wbls-pro-trial-item">
                    <i class="dashicons dashicons-yes-alt"></i>
                    <div>
                        <b><?php esc_html_e('EU Directive 2019/1937 Ready', 'whistleblowing-system'); ?></b>
                    </div>
                </li>
            </ul>
        </div>
        <div class="wbls-pro-trial-col2">
            <span class="wbls-trial-close dashicons dashicons-no-alt" title="Close"></span>
            <h2>🎉 <?php esc_html_e('Your 14-Day Pro Trial Is Ready!', 'whistleblowing-system'); ?></h2>
            <p class="wbls-no-card-text"><?php esc_html_e('Unlock the full power of Whistleblowing System — no credit card required', 'whistleblowing-system'); ?></p>
            <p><?php esc_html_e('Download and activate the Pro plugin below to unlock everything', 'whistleblowing-system'); ?></p>

            <div class="wbls-pro-trial-steps-container">
                <span class="wbls-pro-trial-steps"><?php esc_html_e('Step 1: Click the button below', 'whistleblowing-system'); ?></span>
                <span class="wbls-pro-trial-steps"><?php esc_html_e('Step 2: Download the Pro version from our website', 'whistleblowing-system'); ?></span>
                <span class="wbls-pro-trial-steps"><?php esc_html_e('Step 3: Upload it in Plugins → Add New → Upload Plugin', 'whistleblowing-system'); ?></span>
                <span class="wbls-pro-trial-steps"><?php esc_html_e('Step 4: Activate your license', 'whistleblowing-system'); ?></span>
            </div>

            <div class="wbls-pro-trial-buttons">
                <a href="<?php echo esc_url(WBLS_CORE_URL_MAIN . 'en/trial/'); ?>" target="_blank" class="wbls-btn-primary wbls-manualinstall-pro">
                    <span class="dashicons dashicons-awards"></span>
                    <span class="wbls-btn-title"><?php esc_html_e('Upgrade to Pro', 'whistleblowing-system'); ?></span>
                    <span class="wbls-btn-description"><?php esc_html_e('View Pro features → Download manually → Upload in WordPress', 'whistleblowing-system'); ?></span>
                </a>
            </div>

            <p class="wbls-note"><?php esc_html_e('Enjoy full access for 14 days. Continue free or upgrade anytime.', 'whistleblowing-system'); ?></p>
        </div>
    </div>
    <?php
    $output = ob_get_clean();
    echo wp_kses_post($output);
});