<?php
namespace WBLS_WhistleBlower\Free;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class WhistleblowerFormEdit {
    public $form_fields = array(
            'text' => array(
                'type' => 'text',
                'title' => 'Single Line Text',
                'description' => '',
                'value' => '',
                'name' => '',
                'icon' => '',
                'order' => '0',
                'public' => true,
                'class' => '',
                'id' => '',
                'label' => 'Single Line Text',
                'placeholder' => '',
                'pro' => 0,
                'required' => 0,
                'tabs' => array('general', 'conditions'),
            ),
            'textarea' => array(
                'type' => 'textarea',
                'title' => 'Paragraph Text',
                'description' => '',
                'value' => '',
                'name' => '',
                'icon' => '',
                'order' => '1',
                'public' => true,
                'class' => '',
                'id' => '',
                'label' => 'Paragraph Text',
                'placeholder' => '',
                'pro' => 0,
                'required' => 0,
                'tabs' => array('general', 'conditions'),
            ),
            'checkbox' => array(
                'type' => 'checkbox',
                'title' => 'Checkbox',
                'description' => '',
                'value' => '',
                'name' => '',
                'options' => array(
                    array('miniLabel' =>'New Choice', 'name' => '', 'checked' => '0', 'order' => 1),
                ),
                'icon' => '',
                'order' => '2',
                'public' => true,
                'class' => '',
                'id' => '',
                'label' => 'Checkbox',
                'pro' => 0,
                'required' => 0,
                'required_single' => 0,
                'tabs' => array('general', 'conditions'),
            ),
            'radio' => array(
                'type' => 'radio',
                'title' => 'Single Choice',
                'description' => '',
                'value' => '',
                'name' => '',
                'options' => array(
                    array('key'=>'First Choice', 'val' => 'First Choice', 'order' => 1),
                    array('key'=>'Second Choice', 'val' => 'Second Choice', 'order' => 2),
                    array('key'=>'Third Choice', 'val' => 'Third Choice', 'order' => 3),
                ),
                'default_option' => 0,
                'icon' => '',
                'order' => '3',
                'public' => true,
                'class' => '',
                'id' => '',
                'label' => 'Single Choice',
                'pro' => 0,
                'required' => 0,
                'tabs' => array('general', 'conditions'),
            ),
            'select' => array(
                'type' => 'select',
                'title' => 'Dropdown',
                'description' => '',
                'value' => '',
                'name' => '',
                'options' => array(
                       array('key'=>'Option 1', 'val' => 'Option 1', 'order' => 1),
                       array('key'=>'Option 2', 'val' => 'Option 2', 'order' => 2),
                       array('key'=>'Option 3', 'val' => 'Option 3', 'order' => 3),
                ),
                'default_option' => 0,
                'icon' => '',
                'order' => '4',
                'public' => true,
                'class' => '',
                'id' => '',
                'label' => 'Dropdown',
                'pro' => 1,
                'required' => 0,
                'tabs' => array('general', 'conditions'),
            ),
            'email' => array(
                'type' => 'email',
                'title' => 'Email',
                'description' => '',
                'value' => '',
                'name' => '',
                'icon' => '',
                'order' => '8',
                'public' => true,
                'class' => '',
                'id' => '',
                'label' => 'Email',
                'placeholder' => '',
                'pro' => 0,
                'required' => 0,
                'tabs' => array('general', 'conditions'),
            ),
            'number' => array(
                'type' => 'number',
                'title' => 'Number',
                'description' => '',
                'value' => '',
                'name' => '',
                'icon' => '',
                'order' => '5',
                'public' => true,
                'class' => '',
                'id' => '',
                'label' => 'Number',
                'placeholder' => '',
                'pro' => 0,
                'required' => 0,
                'tabs' => array('general', 'conditions'),
            ),
            'file' => array(
                'type' => 'file',
                'title' => 'Upload',
                'description' => '',
                'value' => '',
                'name' => '',
                'icon' => '',
                'order' => '11',
                'public' => true,
                'class' => '',
                'id' => '',
                'label' => 'Upload',
                'placeholder' => '',
                'pro' => 1,
                'required' => 0,
                'multiple' => 0,
                'tabs' => array('general', 'conditions'),
            ),
            'fullName' => array(
                'type' => 'fullName',
                'title' => 'Full Name',
                'description' => '',
                'value' => '',
                'name' => '',
                'icon' => '',
                'order' => '7',
                'public' => true,
                'class' => '',
                'id' => '',
                'label' => 'Name',
                'placeholder' => '',
                'pro' => 0,
                'required' => 0,
                'fname' => '',
                'mname' => '',
                'lname' => '',
                'firstNamePlaceholder' => '',
                'firstNameMiniLabel' => 'First',
                'lastNamePlaceholder' => '',
                'lastNameMiniLabel' => 'Last',
                'middleNamePlaceholder' => '',
                'middleNameMiniLabel' => 'Middle',
                'hideMiddleName' => 0,
                'tabs' => array('general', 'conditions'),
            ),
            'address' => array(
                'type' => 'address',
                'title' => 'Address',
                'description' => '',
                'value' => '',
                'name' => '',
                'icon' => '',
                'order' => '9',
                'public' => true,
                'class' => '',
                'id' => '',
                'label' => 'Address',
                'placeholder' => '',
                'pro' => 0,
                'required' => 0,
                'streetName' => '',
                'street1Name' => '',
                'cityName' => '',
                'stateName' => '',
                'postalName' => '',
                'countryName' => '',
                'streetPlaceholder' => '',
                'streetMiniLabel' => 'Street Address',
                'street1Placeholder' => '',
                'street1MiniLabel' => 'Street Address Line 2',
                'cityPlaceholder' => '',
                'cityMiniLabel' => 'City',
                'statePlaceholder' => '',
                'stateMiniLabel' => 'State / Province / Region',
                'postalPlaceholder' => '',
                'postalMiniLabel' => 'Postal / Zip Code',
                'countryPlaceholder' => '',
                'countryMiniLabel' => 'Country',
                'hideStreet' => 0,
                'hideStreet1' => 0,
                'hideCity' => 0,
                'hideState' => 0,
                'hidePostal' => 0,
                'hideCountry' => 0,
                'tabs' => array('general', 'conditions'),
            ),
            'submit' => array(
                'type' => 'submit',
                'title' => 'Submit Button',
                'description' => '',
                'value' => '',
                'name' => '',
                'icon' => '',
                'order' => '15',
                'public' => true,
                'class' => '',
                'id' => '',
                'label' => 'Submit',
                'placeholder' => '',
                'pro' => 0,
                'required' => 0,
                'tabs' => array('general', 'conditions'),
            ),
            'recaptcha' => array(
                'type' => 'recaptcha',
                'title' => 'reCAPTCHA',
                'description' => '',
                'value' => '',
                'name' => '',
                'icon' => '',
                'order' => '11',
                'public' => true,
                'class' => '',
                'id' => '',
                'label' => 'Recaptcha',
                'placeholder' => '',
                'version' => 'v2',
                'score' => 0.5,
                'pro' => 1,
                'required' => 0,
                'tabs' => array('general', 'conditions'),
            ),
            'page_break' => array(
                'type' => 'page_break',
                'title' => 'Page break',
                'progress_type' => 'none',
                'pageTitles' => array(),
                'next_button_text' => 'Next',
                'previous_button_text' => 'Previous',
                'show_previous' => 0,
                'default_option' => 0,
                'icon' => '',
                'order' => '14',
                'public' => true,
                'class' => '',
                'id' => '',
                'label' => 'Page break',
                'pro' => 1,
                'required' => 0,
                'tabs' => array('general', 'conditions'),
            ),
            'anonymous' => array(
                'type' => 'anonymous',
                'title' => 'Anonymous',
                'description' => '',
                'value' => '',
                'name' => '',
                'options' => array(
                    array('key'=>'On', 'val' => '1', 'order' => 1),
                    array('key'=>'Off', 'val' => '0', 'order' => 2),
                ),
                'default_option' => 0,
                'icon' => '',
                'order' => '12',
                'public' => true,
                'class' => '',
                'id' => '',
                'label' => 'Anonymous',
                'pro' => 1,
                'required' => 0,
                'tabs' => array('general', 'conditions'),
            ),
            'tel' => array(
                'type' => 'tel',
                'title' => 'Phone',
                'description' => '',
                'value' => '',
                'name' => '',
                'icon' => '',
                'order' => '10',
                'public' => true,
                'class' => '',
                'id' => '',
                'label' => 'Phone',
                'placeholder' => '',
                'pro' => 0,
                'required' => 0,
                'tabs' => array('general', 'conditions'),
            ),
            'DateTime' => array(
                'type' => 'DateTime',
                'title' => 'Date / Time',
                'description' => '',
                'value' => '',
                'name' => '',
                'dateName' => '',
                'dayName' => '',
                'monthName' => '',
                'yearName' => '',
                'timeName' => '',
                'icon' => '',
                'order' => '5',
                'public' => true,
                'class' => '',
                'id' => '',
                'label' => 'Date / Time',
                'placeholder' => '',
                'pro' => 1,
                'required' => 0,
                'tabs' => array('general', 'options', 'conditions'),
                'field_format' => 'date_time',
                'date_options' => array(
                    'type'=>'picker',
                    'format' => 'mdY',
                    'limit_days_active' => '1',
                    'limit_days' => array('mon' => '1','tue' => '1','wed' => '1','thu' => '1','fri' => '1','sat' => '0','sun' => '0'),
                    'disable_past_days' => '1',
                    'placeholder' => '',
                    'mini_label' => 'Date'
                ),
                'time_options' => array(
                    'interval'=>'30m',
                    'format' => '12h',
                    'limit_hours' => '1',
                    'start_time_h' => '09',
                    'start_time_m' => '00',
                    'start_time_f' => 'am',
                    'end_time_h' => '06',
                    'end_time_m' => '00',
                    'end_time_f' => 'pm',
                    'mini_label' => 'Time'
                ),
            ),
            'html' => array(
                'type' => 'html',
                'title' => 'HTML Field',
                'description' => '',
                'value' => '',
                'valueHtml' => '',
                'name' => '',
                'icon' => '',
                'order' => '13',
                'public' => true,
                'class' => '',
                'id' => '',
                'label' => 'HTML Field',
                'placeholder' => '',
                'pro' => 1,
                'tabs' => array('general', 'conditions'),
            ),
            'rating' => array(
                    'type' => 'rating',
                    'title' => 'Rating',
                    'description' => '',
                    'value' => '',
                    'name' => '',
                    'rateScale' => 5,
                    'rateType' => 'numbers',
                    'default_option' => 0,
                    'icon' => '',
                    'order' => '12',
                    'public' => true,
                    'class' => '',
                    'id' => '',
                    'label' => 'Rating',
                    'pro' => 1,
                    'required' => 0,
                    'tabs' => array('general', 'conditions'),
            ),

    );

    public $teeny_active;

    public $whistleblower_active;

    public $fields_options = [];

    public function __construct() {

        $this->teeny_active = get_option('teeny_active', true);
        $task = isset($_GET['task']) ? sanitize_text_field(wp_unslash($_GET['task'])) : '';

        require_once WBLS_DIR.'/admin/includes/fields_templates.php';

        if ( method_exists($this, $task) ) {
            $this->$task();
        } else {
            $this->display();
        }
    }

    public function get_translated_form_fields() {
        $translated_fields = $this->form_fields;

        // Translate titles
        $translated_fields['text']['title'] = __('Single Line Text', 'whistleblowing-system');
        $translated_fields['textarea']['title'] = __('Paragraph Text', 'whistleblowing-system');
        $translated_fields['checkbox']['title'] = __('Checkbox', 'whistleblowing-system');
        $translated_fields['radio']['title'] = __('Single Choice', 'whistleblowing-system');
        $translated_fields['select']['title'] = __('Dropdown', 'whistleblowing-system');
        $translated_fields['email']['title'] = __('Email', 'whistleblowing-system');
        $translated_fields['number']['title'] = __('Number', 'whistleblowing-system');
        $translated_fields['file']['title'] = __('Upload', 'whistleblowing-system');
        $translated_fields['fullName']['title'] = __('Full Name', 'whistleblowing-system');
        $translated_fields['address']['title'] = __('Address', 'whistleblowing-system');
        $translated_fields['submit']['title'] = __('Submit Button', 'whistleblowing-system');
        $translated_fields['recaptcha']['title'] = __('reCAPTCHA', 'whistleblowing-system');
        $translated_fields['page_break']['title'] = __('Page break', 'whistleblowing-system');
        $translated_fields['anonymous']['title'] = __('Anonymous', 'whistleblowing-system');
        $translated_fields['tel']['title'] = __('Phone', 'whistleblowing-system');
        $translated_fields['DateTime']['title'] = __('Date / Time', 'whistleblowing-system');
        $translated_fields['html']['title'] = __('HTML Field', 'whistleblowing-system');

        return $translated_fields;
    }

    public function display() {
        $id = isset($_GET['id']) ? intval($_GET['id']) : 0;
        $form_conditions = [];
        $form_settings = [];
        $this->whistleblower_active = 1;
        $form_title = esc_html__('Untitled Form', 'whistleblowing-system');
        $fieldNameLastId = 0;
        if( $id ) {
            $this->fields_options = (array) get_post_meta( $id, 'wbls_field_options', true );
            $form_settings = (array) get_post_meta( $id, 'wbls_form_settings', true );
            $form_conditions = (array) get_post_meta( $id, 'wbls_form_conditions', true );
            if( empty($form_conditions) ) {
                $form_conditions = [];
            }
            $this->whistleblower_active = $form_settings['whistleblower_active'] ?? 1;
            $form_title = get_the_title($id);
            $fieldNameLastId = get_post_meta($id, 'wbls_fieldNameLastId', true);
        }
        $default_theme = get_option( 'wbls_theme_default' );
        $active_theme = $form_settings['active_theme'] ?? $default_theme;

        $permalink = '';
        if( $id ) {
            $permalink = get_post_permalink($id,true);
        }
        $recaptcha_active = 0;

        wp_enqueue_script( 'jquery-ui-core' );
        wp_enqueue_script( 'jquery-ui-sortable' );
        wp_enqueue_script( WBLS_PREFIX . '-conditions');
        wp_enqueue_script( WBLS_PREFIX . '-edit');
        wp_localize_script(WBLS_PREFIX . '-edit', 'wbls_edit', array(
            "form_fields" => $this->form_fields,
            "form_conditions" => $form_conditions,
            "fields_options" => $this->fields_options,
            "fieldNameLastId" => $fieldNameLastId,
            "ajaxnonce" => wp_create_nonce('wbls_ajax_nonce'),
            "pro" => WBLS_PRO,
            "recaptcha_active" => $recaptcha_active,
            "teeny_active" => $this->teeny_active,
        ));
        wp_enqueue_script( WBLS_PREFIX . '-select2');
        wp_enqueue_style(WBLS_PREFIX . '-select2');

        wp_enqueue_style(WBLS_PREFIX . '-edit');
        wp_enqueue_style(WBLS_PREFIX . '-style');
        $wp_upload_dir = wp_upload_dir();
        $wbls_style_dir = $wp_upload_dir[ 'basedir' ] . '/wbls-system/wbls-theme-style_' . $active_theme . '.css';
        $wbls_style_url = $wp_upload_dir[ 'baseurl' ] . '/wbls-system/wbls-theme-style_' . $active_theme . '.css';
        if( file_exists($wbls_style_dir) ) {
            wp_enqueue_style(WBLS_PREFIX . '-theme-style_' . $active_theme, $wbls_style_url, array(), WBLS_VERSION);
        } else {
            wp_enqueue_style(WBLS_PREFIX . '-theme-style', WBLS_URL . '/frontend/assets/css/default.css', array(), WBLS_VERSION);
        }
        ?>
        <div class="wbls-edit-page<?php echo !WBLS_PRO ? ' wbls-edit-page-trial-banner': ''; ?>">
            <?php WBLSLibrary::wbls_render_topbar_row(); ?>
            <div class="wbls-admin-header">
                <div class="wbls-form-logo-row">
                </div>
                <div class="wbls-form-title-row">
                    <span class="wbls-form-title-label"></span>
                    <input type="text" id="wbls-form-title" class="wbls-form-title" placeholder="<?php esc_attr_e('Form Title','whistleblowing-system'); ?>" value="<?php echo esc_html($form_title) ?>">
                </div>
                <div class="wbls-whistleblower-switcher">
                    <p><?php esc_html_e('WhistleBlower Off','whistleblowing-system'); ?></p>
                    <label class="wbls-switch">
                        <input class="wbls-whistleblower-active" type="checkbox" <?php echo $this->whistleblower_active ? 'checked' : ''?>>
                        <span class="wbls-slider wbls-round"></span>
                    </label>
                    <p><?php esc_html_e('On','whistleblowing-system'); ?></p>
                </div>

                <div class="wbls-top-menu-icon">
                    <span class="dashicons dashicons-menu-alt3"></span>
                    <div class="wbls-top-menu">
                        <div class="wbls-menu-group">
                            <div class="wbls-menu-grouptitle">Whistleblower Pages</div>
                            <a href="admin.php?page=whistleblower_forms" class="wbls-menu-item" target="_blank"><?php esc_html_e('All Forms','whistleblowing-system'); ?></a>
                            <a href="admin.php?page=whistleblower_form_edit" class="wbls-menu-item" target="_blank"><?php esc_html_e('Add New Form','whistleblowing-system'); ?></a>
                            <a href="admin.php?page=whistleblower_submissions" class="wbls-menu-item" target="_blank"><?php esc_html_e('Form Submissions','whistleblowing-system'); ?></a>
                            <a href="admin.php?page=whistleblower_settings" class="wbls-menu-item" target="_blank"><?php esc_html_e('Global Settings','whistleblowing-system'); ?></a>
                            <a href="admin.php?page=whistleblower_themes" class="wbls-menu-item" target="_blank"><?php esc_html_e('Form Themes','whistleblowing-system'); ?></a>
                        </div>
                        <div class="wbls-menu-group">
                                <a href="index.php" class="wbls-menu-item" target="_blank"><?php esc_html_e('Wordpress Dashboard','whistleblowing-system'); ?></a>
                        </div>
                    </div>
                </div>


                <span class="wbls-button wbls-embed-form">
                    <span class="dashicons dashicons-shortcode"></span>
                    <?php esc_html_e('Shortcode', 'whistleblowing-system') ?>
                </span>
                <?php if( $id ) { ?>
                <div class="wbls-preview-container">
                    <span class="wbls-button wbls-preview-button">
                        <span class="dashicons dashicons-visibility"></span>
                        <?php esc_html_e('Preview', 'whistleblowing-system') ?>
                    </span>
                    <div class="wbls-preview-menu-container">
                        <div class="wbls-preview-menu">
                            <?php if ( $this->whistleblower_active ) { ?>
                            <a href="<?php echo esc_url($permalink . '&wbls_preview_type=tab' ); ?>" target="_blank">
                                <?php esc_html_e('Preview Tab view', 'whistleblowing-system') ?>
                            </a>
                            <a href="<?php echo esc_url($permalink ); ?>" target="_blank">
                                <?php esc_html_e('Preview Popup view', 'whistleblowing-system') ?>
                            </a>
                            <?php } ?>
                            <a href="<?php echo esc_url($permalink . '&wbls_preview_type=form' ); ?>" target="_blank">
                                <?php esc_html_e('Preview Form', 'whistleblowing-system') ?>
                            </a>
                        </div>
                    </div>
                </div>
                <?php } ?>
                <span class="wbls-button wbls-add-form"><?php esc_html_e('Save', 'whistleblowing-system') ?></span>
                <div class="wbls-edit-close-row">
                    <a href="?page=whistleblower_forms" class="wbls-edit-close"><span class="dashicons dashicons-no"></span></a>
                </div>
            </div>
            <div class="wbls-form-menu">
                <span data-content="wbls-form-field-menu" class="wbls-form-menu-item wbls-form-menu-item-active wbls-form-field-menu"><?php echo esc_html__("Fields", "whistleblowing-system") ?></span>
                <span data-content="wbls-form-header-menu" class="wbls-form-menu-item wbls-form-header-menu"><?php echo esc_html__("Headers", "whistleblowing-system") ?></span>
                <span data-content="wbls-form-email-options-menu" class="wbls-form-menu-item wbls-form-email-options-menu"><?php echo esc_html__("Email Options", "whistleblowing-system") ?></span>
                <span data-content="wbls-form-displayOption-menu" class="wbls-form-menu-item wbls-form-displayOption-menu"><?php echo esc_html__("Display options", "whistleblowing-system") ?></span>
                <span data-content="wbls-form-settings-menu" class="wbls-form-menu-item wbls-form-settings-menu"><?php echo esc_html__("Settings", "whistleblowing-system") ?></span>
            </div>
            <div class="wbls-body">
                <div class="wbls-sidebar">
                    <?php
                    $this->fields_sidebar();
                    $this->headers_sidebar();
                    $this->email_options_sidebar();
                    $this->display_options_sidebar();
                    $this->settings_sidebar();
                    ?>
                </div>
                <div class="wbls-content">
                    <?php
                    $this->fields();
                    $this->headers( $form_settings );
                    $this->email_options( $id, $this->fields_options );
                    $this->display_options( $form_settings );
                    $this->settings( $id, $form_settings );
                    ?>
                </div>
            </div>
            <?php
            if( $id ) {
                $this->shortcode_popup( $id );
            }
            ?>
        </div>
        <?php
    }

    private function fields_sidebar() {
        ?>
        <div class="wbls-sidebar-menu" id="wbls-form-field-menu-sidebar">
            <div class="wbls-sidebar-tabs">
                <div id="wbls-sidebar-fields-tab" class="wbls-sidebar-tab wbls-sidebar-tab-active"><?php esc_html_e('Add Fields', 'whistleblowing-system') ?></div>
                <div id="wbls-sidebar-field-options-tab" class="wbls-sidebar-tab"><?php esc_html_e('Field Options', 'whistleblowing-system') ?></div>
            </div>
            <div class="wbls-sidebar-fields-content">
                <?php $this->fields_content(); ?>
            </div>
            <div class="wbls-sidebar-field-options-content" style="display: none">
            </div>
        </div>
        <?php
    }

    private function fields() {
    ?>
        <div id="wbls-form-field-menu" class="wbls-form-menu-item-content wbls-form-edit-content">
            <div class="wbls-form-content">
                <?php $this->form_content(); ?>
            </div>
        </div>
        <?php
    }

    private function headers_sidebar() {
        ?>
        <div class="wbls-sidebar-menu" id="wbls-form-header-menu-sidebar" style="display: none">
            <span id="wbls-sidebar-form-header" class="wbls-sidebar-menu-item wbls-sidebar-menu-item-active">
                <?php esc_html_e('Form Header', 'whistleblowing-system'); ?>
            </span>
            <span id="wbls-sidebar-token-header" class="wbls-sidebar-menu-item">
                <?php esc_html_e('Token Header', 'whistleblowing-system'); ?>
            </span>
            <span id="wbls-sidebar-login-header" class="wbls-sidebar-menu-item">
                <?php esc_html_e('Login Header', 'whistleblowing-system'); ?>
            </span>
        </div>
        <?php
    }

    private function headers( $form_settings ) {
        ?>
        <div id="wbls-form-header-menu" class="wbls-form-menu-item-content wbls-header-container" style="display: none">
            <?php
            $show_form_header = !empty($form_settings['show_form_header']) ? $form_settings['show_form_header'] : 0;
            $show_token_header = !empty($form_settings['show_token_header']) ? $form_settings['show_token_header'] : 0;
            $show_login_header = !empty($form_settings['show_login_header']) ? $form_settings['show_login_header'] : 0;
            $form_header = !empty($form_settings['form_header']) ? $form_settings['form_header'] : '';
            $token_header = !empty($form_settings['token_header']) ? $form_settings['token_header'] : '';
            $login_header = !empty($form_settings['login_header']) ? $form_settings['login_header'] : '';
            ?>
            <div class="wbls-form-content">
                <div class="wbls-option-section-column">
                    <div class="wbls-option-section wbls-sidebar-menu-item-content wbls-sidebar-form-header">
                        <div class="wbls-option-section-content">
                            <div class="wbls-option-section-group">
                                <label><?php esc_html_e('Show header', 'whistleblowing-system'); ?></label>
                                <div class="wbls-switch-button-cover">
                                    <div class="button b2 wbls-switch-button" id="wbls-req-switch-button">
                                        <input type="checkbox" class="checkbox wbls-field-option wbls-show-form-header" id="wbls-required-checkbox" name="show_form_header"  value="1" <?php echo $show_form_header ? 'checked' : ''; ?>/>
                                        <div class="wbls-req-knobs wbls-knobs">
                                            <span></span>
                                        </div>
                                        <div class="wbls-req-layer wbls-switch-layer"></div>
                                    </div>
                                </div>
                                <p class="wbls-option-section-group-description">
                                    <?php esc_html_e('Enable the option to show form header in the frontend above the form', 'whistleblowing-system'); ?>
                                </p>
                            </div>
                            <div class="wbls-option-section-group">
                                <label><?php esc_html_e('Header text', 'whistleblowing-system'); ?></label>
                                <?php
                                if ( user_can_richedit() && $this->teeny_active ) {
                                    wp_editor(
                                            wp_kses($form_header, WBLSLibrary::$wp_kses_default),
                                            'wbls_form_header',
                                            array(
                                                'textarea_name' => 'wbls_form_header',
                                                'media_buttons' => false,
                                                'textarea_rows' => 10,
                                                'teeny'         => false,
                                                'quicktags'     => true,
                                            ),
                                    );
                                }
                                else {
                                    ?>
                                    <textarea name="wbls_form_header" id="wbls-form-header" class="wbls-form-header"><?php echo wp_kses($form_header, WBLSLibrary::$wp_kses_default); ?></textarea>
                                    <?php
                                }
                                ?>
                                <p class="wbls-option-section-group-description">
                                    <?php esc_html_e('The header text is visible on the frontend above the form.', 'whistleblowing-system'); ?>
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="wbls-option-section wbls-sidebar-menu-item-content wbls-sidebar-token-header" style="display: none">
                        <div class="wbls-option-section-content">
                            <div class="wbls-option-section-group">
                                <label><?php esc_html_e('Show header', 'whistleblowing-system'); ?></label>
                                <div class="wbls-switch-button-cover">
                                    <div class="button b2 wbls-switch-button" id="wbls-req-switch-button">
                                        <input type="checkbox" class="checkbox wbls-field-option wbls-show-token-header" id="wbls-required-checkbox" name="show_token_header"  value="1" <?php echo $show_token_header ? 'checked' : ''; ?>/>
                                        <div class="wbls-req-knobs wbls-knobs">
                                        <span></span>
                                        </div>
                                        <div class="wbls-req-layer wbls-switch-layer"></div>
                                    </div>
                                </div>
                                <p class="wbls-option-section-group-description">
                                    <?php esc_html_e('Enable the option to show the token header in the frontend above the copy token field in the popup that appears after form submission.', 'whistleblowing-system'); ?>
                                </p>
                            </div>
                            <div class="wbls-option-section-group">
                                <label><?php esc_html_e('Header text', 'whistleblowing-system'); ?></label>
                                <?php
                                if ( user_can_richedit() && $this->teeny_active ) {
                                    wp_editor(
                                        wp_kses($token_header, WBLSLibrary::$wp_kses_default),
                                        'wbls_token_header',
                                        array(
                                            'textarea_name' => 'wbls_token_header',
                                            'media_buttons' => false,                 // Show the "Add Media" button
                                            'textarea_rows' => 10,                   // Set the height of the editor
                                            'teeny'         => false,                // Whether to load the minimal TinyMCE editor
                                            'quicktags'     => true,                 // Enable the Text mode (HTML editor)
                                        ),
                                    );
                                }
                                else {
                                    ?>
                                    <textarea name="wbls_token_header" id="wbls-token-header" class="wbls-token-header"><?php echo wp_kses($token_header, WBLSLibrary::$wp_kses_default); ?></textarea>
                                    <?php
                                }
                                ?>
                                <p class="wbls-option-section-group-description">
                                    <?php esc_html_e('The header text is visible on the token header in the frontend above the copy token field in the popup that appears after form submission.', 'whistleblowing-system'); ?>
                                </p>
                            </div>
                        </div>
                    </div sty>
                    <div class="wbls-option-section wbls-sidebar-menu-item-content wbls-sidebar-login-header" style="display: none">
                        <div class="wbls-option-section-title" style="display: none">
                            <strong><?php esc_html_e('Login header', 'whistleblowing-system'); ?></strong>
                        </div>
                        <div class="wbls-option-section-content">
                            <div class="wbls-option-section-group">
                                <label><?php esc_html_e('Show header', 'whistleblowing-system'); ?></label>
                                <div class="wbls-switch-button-cover">
                                    <div class="button b2 wbls-switch-button" id="wbls-req-switch-button">
                                        <input type="checkbox" class="checkbox wbls-field-option wbls-show-login-header" id="wbls-required-checkbox" name="show_form_header"  value="1" <?php echo $show_form_header ? 'checked' : ''; ?>/>
                                        <div class="wbls-req-knobs wbls-knobs">
                                        <span></span>
                                        </div>
                                        <div class="wbls-req-layer wbls-switch-layer"></div>
                                    </div>
                                </div>
                                <p class="wbls-option-section-group-description">
                                    <?php esc_html_e('Enable the option to show login page/popup header in the frontend above the login input', 'whistleblowing-system'); ?>
                                </p>
                            </div>
                            <div class="wbls-option-section-group">
                                <label><?php esc_html_e('Header text', 'whistleblowing-system'); ?></label>
                                <?php
                                if ( user_can_richedit() && $this->teeny_active ) {
                                    wp_editor(
                                        wp_kses($login_header, WBLSLibrary::$wp_kses_default),
                                        'wbls_login_header',
                                        array(
                                            'textarea_name' => 'wbls_login_header',
                                            'media_buttons' => false,
                                            'textarea_rows' => 10,
                                            'teeny'         => false,
                                            'quicktags'     => true,
                                        ),
                                    );
                                }
                                else {
                                    ?>
                                    <textarea name="wbls_login_header" id="wbls-login-header" class="wbls-login-header"><?php echo wp_kses($login_header, WBLSLibrary::$wp_kses_default); ?></textarea>
                                    <?php
                                }
                                ?>
                                <p class="wbls-option-section-group-description">
                                    <?php esc_html_e('The header text is visible on the frontend above the login form.', 'whistleblowing-system'); ?>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }

    private function email_options_sidebar() {
        ?>
        <div class="wbls-sidebar-menu" id="wbls-form-email-options-menu-sidebar" style="display: none">
            <span id="wbls-sidebar-email-on" class="wbls-sidebar-menu-item wbls-sidebar-menu-item-active">
                <?php esc_html_e('Send Notification Email', 'whistleblowing-system'); ?>
            </span>
            <span id="wbls-sidebar-email-admin" class="wbls-sidebar-menu-item">
                <?php esc_html_e('Email to Administrator', 'whistleblowing-system'); ?>
            </span>
            <span id="wbls-sidebar-email-user" class="wbls-sidebar-menu-item">
                <?php esc_html_e('Email to User', 'whistleblowing-system'); ?>
            </span>
        </div>
        <?php
    }

    private function email_options( $id, $fields_options ) {
        $email_options = (array) get_post_meta($id, 'wbls_email_options', true);
        $email_option = array(
            'sendemail' => isset($email_options['sendemail']) ? intval($email_options['sendemail']) : 0,
            'admin_mail' => isset($email_options['admin_mail']) ? esc_html($email_options['admin_mail']) : '',
            'wbls_mail_from' => isset($email_options['wbls_mail_from']) ? esc_html($email_options['wbls_mail_from']) : '',
            'from_name' => isset($email_options['from_name']) ? esc_html($email_options['from_name']) : '',
            'mail_subject' => isset($email_options['mail_subject']) ? esc_html($email_options['mail_subject']) : '',
            'wbls_mail_body' => isset($email_options['wbls_mail_body']) ? wp_kses($email_options['wbls_mail_body'], WBLSLibrary::$wp_kses_default) : '',
            'wbls_user_send_to' => isset($email_options['wbls_user_send_to']) ? intval($email_options['wbls_user_send_to']) : '0',
            'wbls_user_mail_from' => isset($email_options['wbls_user_mail_from']) ? esc_html($email_options['wbls_user_mail_from']) : '',
            'wbls_user_from_name' => isset($email_options['wbls_user_from_name']) ? esc_html($email_options['wbls_user_from_name']) : '',
            'wbls_user_mail_subject' => isset($email_options['wbls_user_mail_subject']) ? esc_html($email_options['wbls_user_mail_subject']) : '',
            'wbls_user_mail_body' => isset($email_options['wbls_user_mail_body']) ? wp_kses($email_options['wbls_user_mail_body'], WBLSLibrary::$wp_kses_default) : '',
            );
        ?>
        <div id="wbls-form-email-options-menu" class="wbls-emailOptions-container wbls-form-menu-item-content" style="display:none;">
            <div id="form_email_options_tab_content" class="adminform js">
                <div class="wbls-table wbls-sidebar-email-on wbls-sidebar-menu-item-content">
                    <div class="wbls-table-col-100">
                        <div class="wbls-box-section">
                            <div class="wbls-box-content">
                                <div class="wbls-group">
                                <label class="wbls-label"><?php esc_html_e('Send Notification Email','whistleblowing-system'); ?></label>
                                <div class="wbls-switch-button-cover wbls-switch-button">
                                    <div class="button b2 wbls-switch-button" id="wbls-req-switch-button">
                                        <input type="checkbox" class="checkbox wbls-field-option wbls-radio wbls_sendemail" id="wbls-required-checkbox" name="sendemail" <?php echo $email_option['sendemail'] == 1 ? 'checked="checked"' : '' ?>/>
                                        <div class="wbls-req-knobs wbls-knobs">
                                            <span></span>
                                        </div>
                                        <div class="wbls-req-layer wbls-switch-layer"></div>
                                    </div>
                                </div>
                                    <p class="description"><?php esc_html_e('Enable this setting to send submitted information to administrators and/or the submitter.', 'whistleblowing-system'); ?></p>
                                    <p class="description wbls_email_options"><?php esc_html_e('In case you cannot find the submission email in your Inbox, make sure to check the Spam folder as well.', 'whistleblowing-system'); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="wbls-table meta-box-sortables wbls_email_options wbls-sidebar-email-admin wbls-sidebar-menu-item-content" id="emailTab_fieldset" style="display: none">
                    <div class="wbls-table-col-100 wbls-table-col-left">
                        <div class="wbls-box-section">
                            <div class="wbls-box-title">
                                <h3><?php esc_html_e('Email to Administrator', 'whistleblowing-system'); ?></h3>
                            </div>
                            <div class="wbls-box-content">
                                <div class="wbls-group wbls-has-placeholder">
                                    <label class="wbls-label" for="mail"><?php esc_html_e('Email to send submissions to', 'whistleblowing-system'); ?></label>
                                    <input autocomplete="off" class="wbls-validate" data-type="email" data-callback="wbls_validate_email" data-callback-parameter="" data-tab-id="emailTab" data-content-id="emailTab_fieldset" type="text" id="mail" name="mail" value="<?php echo esc_attr($email_option['admin_mail']); ?>" />
                                    <p class="description"><?php esc_html_e('Specify the email address(es), to which submitted form information will be sent. For multiple email addresses separate with commas.', 'whistleblowing-system'); ?></p>
                                </div>
                                <div class="wd-group">
                                    <label class="wbls-label"><?php esc_html_e('Email From', 'whistleblowing-system'); ?></label>
                                    <input class="wbls-validate" data-type="email" data-callback="wbls_validate_email" data-callback-parameter="" data-tab-id="emailTab" data-content-id="emailTab_fieldset" type="text" name="wbls_mail_from" id="wbls_mail_from" value="<?php echo esc_attr($email_option['wbls_mail_from']); ?>" />
                                    <p class="description"><?php esc_html_e('Specify the email address from which the administrator will receive the email.', 'whistleblowing-system'); ?></p>
                                    <p class="description"><?php esc_html_e('We recommend you to use an email address belonging to your website domain.', 'whistleblowing-system'); ?></p>
                                    <div id="wbls-email-from-info" class="wbls-hide">
                                        <p><?php esc_html_e('If sender email address is not hosted on the same domain as your website, some hosting providers may not send the emails.', 'whistleblowing-system'); ?></p>
                                        <p><?php esc_html_e('In addition, relaying mail servers may consider the emails as phishing.', 'whistleblowing-system'); ?></p>
                                    </div>
                                </div>
                                <div class="wbls-group wd-has-placeholder<?php echo WBLS_PRO ? '' : ' wbls-pro-tooltip wbls-pro-tooltip-action'; ?>">
                                    <label class="wbls-label" for="from_name"><?php esc_html_e('From Name', 'whistleblowing-system'); ?></label>
                                    <input autocomplete="off" type="text" name="from_name" value="<?php echo esc_attr($email_option['from_name']); ?>" id="from_name" />
                                    <p class="description"><?php esc_html_e('Set the name or search for a form field which is shown as the sender’s name in submission or confirmation emails.', 'whistleblowing-system'); ?></p>
                                </div>
                                <div class="wbls-group wbls-has-placeholder<?php echo WBLS_PRO ? '' : ' wbls-pro-tooltip wbls-pro-tooltip-action'; ?>">
                                    <label class="wbls-label" for="mail_subject"><?php esc_html_e('Subject', 'whistleblowing-system'); ?></label>
                                    <?php $this->placeholder_buttons($this->fields_options, 'text','wbls-subject-field'); ?>
                                    <input autocomplete="off" type="text" id="mail_subject" name="mail_subject" value="<?php echo esc_attr($email_option['mail_subject']); ?>" />
                                    <p class="description"><?php esc_html_e('Add a custom subject or search for a form field for the submission email. In case it’s left blank, Form Title will be set as the subject of submission emails.', 'whistleblowing-system'); ?></p>
                                </div>
                                <div class="wd-group<?php echo WBLS_PRO ? '' : ' wbls-pro-tooltip wbls-pro-tooltip-action'; ?>">
                                    <label class="wbls-label" for="wbls_mail_body"><?php esc_html_e('Custom Text in Email For Administrator', 'whistleblowing-system'); ?></label>
                                    <?php
                                    $this->placeholder_buttons($this->fields_options,'','', ['admin_token' => 'Admin Token']);
                                    if ( user_can_richedit() && $this->teeny_active ) {
                                        wp_editor($email_option['wbls_mail_body'], 'wbls_mail_body', array(
                                            'textarea_name' => 'wbls_mail_body',
                                            'media_buttons' => false,
                                            'textarea_rows' => 10,
                                            'teeny'         => false,
                                            'quicktags'     => true,
                                        ));
                                    }
                                    else {
                                        ?>
                                        <textarea name="wbls_mail_body" id="wbls_mail_body" cols="20" rows="10" style="width:100%; height:200px;"><?php echo wp_kses($email_option['wbls_mail_body'], WBLSLibrary::$wp_kses_default); ?></textarea>
                                        <?php
                                    }
                                    ?>
                                    <p class="description"><?php esc_html_e('Write custom content to the email message which is sent to administrator. Include All Fields List to forward all submitted information, or click on fields buttons to use individual field values in the content.', 'whistleblowing-system'); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="wbls-table meta-box-sortables wbls_user_email_options wbls_email_options wbls-sidebar-email-user wbls-sidebar-menu-item-content" id="emailTab_fieldset" style="display: none">
                    <div class="wbls-table-col-100 wbls-table-col-left">
                        <div class="wbls-box-section">
                            <div class="wbls-box-title">
                                <h3><?php esc_html_e('Email to User', 'whistleblowing-system'); ?></h3>
                            </div>
                            <div class="wbls-box-content">
                                <div class="wbls-has-placeholder wd-group<?php echo WBLS_PRO ? '' : ' wbls-pro-tooltip wbls-pro-tooltip-action'; ?>">
                                    <?php if( !empty(WBLSLibrary::is_emailField_exists($this->fields_options)) ) { ?>
                                        <label class="wbls-label" for="mail"><?php esc_html_e('Email', 'whistleblowing-system'); ?></label>
                                        <input type="checkbox" name="wbls_user_send_to" id="wbls_user_send_to"  <?php echo $email_option['wbls_user_send_to'] == 1 ? 'checked="checked"' : '' ?> value="1" />
                                        <p class="description"><?php esc_html_e('Use this setting to select the email field of your form, to which the submissions will be sent.', 'whistleblowing-system'); ?></p>
                                    <?php } else { ?>
                                        <p><b><?php esc_html_e('There is no email field', 'whistleblowing-system'); ?></b></p>
                                        <p class="description"><?php esc_html_e('Use this setting to select the email field of your form, to which the submissions will be sent.', 'whistleblowing-system'); ?></p>
                                    <?php } ?>
                                </div>
                                <div class="wd-group<?php echo WBLS_PRO ? '' : ' wbls-pro-tooltip wbls-pro-tooltip-action'; ?>">
                                    <label class="wbls-label"><?php esc_html_e('Email From', 'whistleblowing-system'); ?></label>
                                    <input class="wbls-validate" data-type="email" data-callback="wbls_validate_email" data-callback-parameter="" data-tab-id="emailTab" data-content-id="emailTab_fieldset" type="text" name="wbls_user_mail_from" id="wbls_user_mail_from" value="<?php echo esc_attr($email_option['wbls_user_mail_from']); ?>" />
                                    <p class="description"><?php esc_html_e('Specify the email address from which the user will receive the email.', 'whistleblowing-system'); ?></p>
                                    <p class="description"><?php esc_html_e('We recommend you to use an email address belonging to your website domain.', 'whistleblowing-system'); ?></p>
                                    <div id="wbls-email-from-info" class="wbls-hide">
                                        <p><?php esc_html_e('If sender email address is not hosted on the same domain as your website, some hosting providers may not send the emails.', 'whistleblowing-system'); ?></p>
                                        <p><?php esc_html_e('In addition, relaying mail servers may consider the emails as phishing.', 'whistleblowing-system'); ?></p>
                                    </div>
                                </div>
                                <div class="wbls-group wd-has-placeholder<?php echo WBLS_PRO ? '' : ' wbls-pro-tooltip wbls-pro-tooltip-action'; ?>">
                                    <label class="wbls-label" for="from_name"><?php esc_html_e('From Name', 'whistleblowing-system'); ?></label>
                                    <input autocomplete="off" type="text" name="wbls_user_from_name" value="<?php echo esc_attr($email_option['wbls_user_from_name']); ?>" id="wbls_user_from_name" />
                                    <p class="description"><?php esc_html_e('Set the name or search for a form field which is shown as the sender’s name in submission or confirmation emails.', 'whistleblowing-system'); ?></p>
                                </div>
                                <div class="wbls-group wbls-has-placeholder<?php echo WBLS_PRO ? '' : ' wbls-pro-tooltip wbls-pro-tooltip-action'; ?>">
                                    <label class="wbls-label" for="mail_subject"><?php esc_html_e('Subject', 'whistleblowing-system'); ?></label>
                                    <?php $this->placeholder_buttons($this->fields_options, 'text','wbls-subject-field'); ?>
                                    <input autocomplete="off" type="text" id="wbls_user_mail_subject" name="wbls_user_mail_subject" value="<?php echo esc_attr($email_option['wbls_user_mail_subject']); ?>" />
                                    <p class="description"><?php esc_html_e('Add a custom subject or search for a form field for the submission email. In case it’s left blank, Form Title will be set as the subject of submission emails.', 'whistleblowing-system'); ?></p>
                                </div>
                                <div class="wd-group<?php echo WBLS_PRO ? '' : ' wbls-pro-tooltip wbls-pro-tooltip-action'; ?>">
                                    <label class="wbls-label" for="wbls_mail_body"><?php esc_html_e('Custom Text in Email For User', 'whistleblowing-system'); ?></label>
                                    <?php
                                    $this->placeholder_buttons($this->fields_options,'','', ['user_token' => 'User Token'], false);
                                    if ( user_can_richedit() && $this->teeny_active ) {
                                        wp_editor($email_option['wbls_user_mail_body'], 'wbls_user_mail_body', array(
                                            'textarea_name' => 'wbls_mail_body',
                                            'media_buttons' => false,                 // Show the "Add Media" button
                                            'textarea_rows' => 10,                   // Set the height of the editor
                                            'teeny'         => false,                // Whether to load the minimal TinyMCE editor
                                            'quicktags'     => true,                 // Enable the Text mode (HTML editor)
                                        ));
                                    }
                                    else {
                                        ?>
                                        <textarea name="wbls_user_mail_body" id="wbls_user_mail_body" cols="20" rows="10" style="width:100%; height:200px;"><?php echo wp_kses($email_option['wbls_user_mail_body'], WBLSLibrary::$wp_kses_default); ?></textarea>
                                        <?php
                                    }
                                    ?>
                                    <p class="description"><?php esc_html_e('Write custom content to the email message which is sent to user. Include All Fields List to forward all submitted information, or click on fields buttons to use individual field values in the content.', 'whistleblowing-system'); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }

    private function display_options_sidebar() {
        ?>
        <div class="wbls-sidebar-menu" id="wbls-form-displayOption-menu-sidebar" style="display: none">
            <span id="wbls-sidebar-button-texts" class="wbls-sidebar-menu-item wbls-sidebar-menu-item-active">
                <?php esc_html_e('Whistleblower form button texts', 'whistleblowing-system'); ?>
            </span>
            <span id="wbls-sidebar-active-theme" class="wbls-sidebar-menu-item">
                <?php esc_html_e('Form active theme', 'whistleblowing-system'); ?>
            </span>
            <span id="wbls-sidebar-submit-messages" class="wbls-sidebar-menu-item">
                <?php esc_html_e('Submit messages', 'whistleblowing-system'); ?>
            </span>
            <span id="wbls-sidebar-advanced" class="wbls-sidebar-menu-item">
                <?php esc_html_e('Advanced', 'whistleblowing-system'); ?>
            </span>
        </div>
        <?php
    }

    function wbls_generate_incoming_json_template() {

        if ( empty( $this->fields_options ) || ! is_array( $this->fields_options ) ) {
            return '{}';
        }

        $json = [];
        $counter = 1;

        foreach ( $this->fields_options as $field ) {
            // Skip non-input fields
            if ( empty($field) || in_array( $field['type'], ['submit','html','recaptcha','page_break', 'file', 'anonymous'] ) ) {
                continue;
            }

            $label = !empty($field['label']) ? $field['label'] : ucfirst($field['type']);
            $desc  = $label . " (" . $field['type'];

            // Add options for radios, selects, checkboxes
            $example = '';

            if ( $field['type'] === 'checkbox' ) {
                foreach ( $field['options'] as $opt ) {
                    if ( ! empty( $opt['name'] ) ) {
                        $json[ $opt['name'] ] = $opt['miniLabel'] . " (checkbox) → Example value: 1";
                    }
                }
                continue;
            }

            // Special handling for complex fields
            // Handle fullName separately
            if ( $field['type'] === 'fullName' ) {
                // First name
                if ( ! empty( $field['fname'] ) ) {
                    $json[ $field['fname'] ] = $field['firstNameMiniLabel'] . "name (text) → Example value: John";
                }
                // Middle name (only if not hidden)
                if ( empty( $field['hideMiddleName'] ) && ! empty( $field['mname'] ) ) {
                    $json[ $field['mname'] ] = $field['middleNameMiniLabel'] . "name (text) → Example value: A.";
                }
                // Last name
                if ( ! empty( $field['lname'] ) ) {
                    $json[ $field['lname'] ] = $field['lastNameMiniLabel'] . "name (text) → Example value: Doe";
                }
                continue;
            }

            if ( $field['type'] === 'DateTime' ) {
                $date_format = $field['date_options']['format'] ?? 'Y-m-d';
                $time_format = $field['time_options']['format'] ?? '24h';
                // Example date
                $date_example = '';
                if ($date_format === 'mdY') {
                    $date_example = current_time('m/d/Y'); // e.g. 01/15/2024 (site's timezone)
                } elseif ($date_format === 'dmY') {
                    $date_example = current_time('d/m/Y'); // e.g. 15/01/2024 (site's timezone)
                } else {
                    $date_example = current_time('Y-m-d'); // e.g. 2024-01-15 (site's timezone)
                }

                // Example time
                $time_example = '';
                if ($time_format === '12h') {
                    $time_example = current_time('h:i A'); // e.g. 10:00 AM
                } else {
                    $time_example = current_time('H:i');   // e.g. 14:30
                }

                if( $field['field_format'] === 'date' || $field['field_format'] === 'date_time' ) {
                    if ($field['date_options']['type'] === 'dropdown') {
                        if (!empty($field['dayName'])) {
                            $json[$field['dayName']] = "day (integer) → Example value: 15";
                        }
                        if (!empty($field['monthName'])) {
                            $json[$field['monthName']] = "month (integer) → Example value: 8";
                        }
                        if (!empty($field['yearName'])) {
                            $json[$field['yearName']] = "year (integer) → Example value: 2025";
                        }

                    } else {
                        if (!empty($field['dateName'])) {
                            $json[$field['dateName']] = "Date (" . $date_format . ") → Example: " . $date_example;
                        }
                    }
                }

                if( $field['field_format'] === 'time' || $field['field_format'] === 'date_time' ) {
                    if (!empty($field['timeName'])) {
                        $json[$field['timeName']] = "Time (" . $time_format . ") → Example: " . $time_example;;
                    }

                }
                continue;
            }

            if ( $field['type'] === 'address' ) {
                // Street
                if ( empty($field['hideStreet']) && !empty($field['streetName']) ) {
                    $json[$field['streetName']] = ($field['streetMiniLabel'] ?? 'Street') . " → Example: 123 Main St";
                }
                // Street 2
                if ( empty($field['hideStreet1']) && !empty($field['street1Name']) ) {
                    $json[$field['street1Name']] = ($field['street1MiniLabel'] ?? 'Street 2') . " → Example: Apt 4B";
                }
                // City
                if ( empty($field['hideCity']) && !empty($field['cityName']) ) {
                    $json[$field['cityName']] = ($field['cityMiniLabel'] ?? 'City') . " → Example: London";
                }
                // State
                if ( empty($field['hideState']) && !empty($field['stateName']) ) {
                    $json[$field['stateName']] = ($field['stateMiniLabel'] ?? 'State') . " → Example: Greater London";
                }
                // Postal
                if ( empty($field['hidePostal']) && !empty($field['postalName']) ) {
                    $json[$field['postalName']] = ($field['postalMiniLabel'] ?? 'Postal') . " → Example: W1A 1AA";
                }
                // Country
                if ( empty($field['hideCountry']) && !empty($field['countryName']) ) {
                    $json[$field['countryName']] = ($field['countryMiniLabel'] ?? 'Country') . " → Example: United Kingdom";
                }
                continue;
            }


            if ( $field['type'] === 'email' ) {
                $example = " → Example value: john@example.com";
            }
            if ( $field['type'] === 'tel' ) {
                $example = " → Example value: +48 600 700 800";
            }
            if ( $field['type'] === 'number' ) {
                $example = " → Example value: 42";
            }
            if ( $field['type'] === 'text' || $field['type'] === 'textarea' ) {
                $example = " → Example value: Sample text";
            }

            if ( ! empty( $field['options'] ) && is_array( $field['options'] ) ) {
                $opts = [];
                foreach ( $field['options'] as $opt ) {
                    $val = $opt['val'] ?? $opt['miniLabel'] ?? $opt['key'] ?? '';
                    if ( $val ) $opts[] = $val;
                }
                if ( ! empty( $opts ) ) {
                    $desc   .= ": " . implode(' | ', $opts);
                    $example = " → Example value: " . $opts[0];
                }
            }


            $json[$field['name']] = $desc . ")" . $example;
           // $counter++;
        }

        return wp_json_encode( $json, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE );
    }

    private function display_options( $form_settings ) {
        ?>
        <div id="wbls-form-displayOption-menu" class="wbls-form-menu-item-content wbls-displayOption-container" style="display:none;">
            <?php
            $new_case_button_title = !empty($form_settings['new_case']) ? $form_settings['new_case'] : 'Report a new case';
            $follow_case_button_title = !empty($form_settings['follow_case']) ? $form_settings['follow_case'] : 'Follow up on a case';
            $login_case_button_title = !empty($form_settings['login_case']) ? $form_settings['login_case'] : 'Login';
            $copy_token_button_title = !empty($form_settings['copy_token']) ? $form_settings['copy_token'] : 'Copy token';
            $reply_button_title = !empty($form_settings['reply_button']) ? $form_settings['reply_button'] : 'Send';
            $success_message_text = !empty($form_settings['success_message']) ? $form_settings['success_message'] : 'Form successfully submitted';
            $success_message_copy_token = !empty($form_settings['success_message_copy_token']) ? $form_settings['success_message_copy_token'] : 'Please copy and retain this token for future login and for follow-up on the response.';
            $error_message_text = !empty($form_settings['error_message']) ? $form_settings['error_message'] : 'Something went wrong';
            $wbls_show_form_after_submit = isset($form_settings['wbls_show_form_after_submit']) ? intval($form_settings['wbls_show_form_after_submit']) : 1;
            $themes = get_posts(array(
                'posts_per_page'  => -1,
                'post_type' => 'wbls_theme'
            ));
            $default_theme = get_option( 'wbls_theme_default' );
            $active_theme = !empty($form_settings['active_theme']) ? $form_settings['active_theme'] : $default_theme;
            ?>
            <div class="wbls-option-section-column">
                <div class="wbls-option-section wbls-sidebar-menu-item-content wbls-sidebar-button-texts">
                    <div class="wbls-option-section-title">
                        <strong><?php esc_html_e('Whistleblower form button texts', 'whistleblowing-system'); ?></strong>
                    </div>
                    <div class="wbls-option-section-content">
                        <div class="wbls-option-section-group">
                            <label><?php esc_html_e('New case button text', 'whistleblowing-system'); ?></label>
                            <input type="text" name="new_case" class="wbls-new_case-button" value="<?php echo esc_html($new_case_button_title); ?>">
                            <p class="wbls-option-section-group-description">
                                <?php esc_html_e('The \'New Case\' button text is visible on the frontend for the whistleblower form. When clicked, it opens the form in a popup.', 'whistleblowing-system'); ?>
                            </p>
                        </div>
                        <div class="wbls-option-section-group">
                            <label><?php esc_html_e('Follow up case button text', 'whistleblowing-system'); ?></label>
                            <input type="text" name="follow_case" class="wbls-follow_case-button" value="<?php echo esc_html($follow_case_button_title); ?>">
                            <p class="wbls-option-section-group-description">
                                <?php esc_html_e('The \'Follow up\' button text is visible on the frontend for the whistleblower form. When clicked, it opens the login form in a popup.', 'whistleblowing-system'); ?>
                            </p>
                        </div>
                        <div class="wbls-option-section-group">
                            <label><?php esc_html_e('Login button text', 'whistleblowing-system'); ?></label>
                            <input type="text" name="login_case" class="wbls-login_case-button" value="<?php echo esc_html($login_case_button_title); ?>">
                            <p class="wbls-option-section-group-description">
                                <?php esc_html_e('The \'Login\' button text is visible on the frontend for the whistleblower form. When clicked, it opens the login form in a popup.', 'whistleblowing-system'); ?>
                            </p>
                        </div>
                        <div class="wbls-option-section-group">
                            <label><?php esc_html_e('Reply button text', 'whistleblowing-system'); ?></label>
                            <input type="text" name="reply_button" class="wbls-reply_button" value="<?php echo esc_html($reply_button_title); ?>">
                            <p class="wbls-option-section-group-description">
                                <?php esc_html_e('The \'Reply\' button text is visible on the frontend for the whistleblower form. After logging in using the token, it displays the chat popup, along with the \'Reply\' button.', 'whistleblowing-system'); ?>
                            </p>
                        </div>
                    </div>
                </div>
                <div class="wbls-option-section wbls-sidebar-menu-item-content wbls-sidebar-active-theme">
                    <div class="wbls-option-section-title">
                        <strong><?php esc_html_e('Form active theme', 'whistleblowing-system'); ?></strong>
                    </div>
                    <div class="wbls-option-section-content">
                        <div class="wbls-option-section-group">
                            <label><?php esc_html_e('Theme', 'whistleblowing-system'); ?></label>
                            <select name="wbls_form_theme" class="wbls-active-theme">
                                <?php foreach ($themes as $theme ) { ?>
                                    <option value="<?php echo intval($theme->ID); ?>" <?php echo ($active_theme == $theme->ID) ? 'selected' : ''; ?>>
                                        <?php echo esc_html($theme->post_title); ?>
                                    </option>
                                <?php } ?>
                            </select>
                            <p class="wbls-option-section-group-description">
                                <?php esc_html_e('Select a theme to which the form should be connected.', 'whistleblowing-system'); ?>
                            </p>
                        </div>
                    </div>
                </div>
                <div class="wbls-option-section wbls-sidebar-menu-item-content wbls-sidebar-submit-messages">
                    <div class="wbls-option-section-title">
                        <strong><?php esc_html_e('Submit messages', 'whistleblowing-system'); ?></strong>
                    </div>
                    <div class="wbls-option-section-content">
                        <div class="wbls-option-section-group">
                            <label><?php esc_html_e('Success message text', 'whistleblowing-system'); ?></label>
                            <textarea name="success_message" class="wbls-success-message"><?php echo esc_html($success_message_text); ?></textarea>
                            <p class="wbls-option-section-group-description">
                                <?php esc_html_e('A form success message text typically informs users that their submission was successful.', 'whistleblowing-system'); ?>
                            </p>
                        </div>
                        <div class="wbls-option-section-group">
                            <label><?php esc_html_e('Success message text about token copy for whistleblowing form', 'whistleblowing-system'); ?></label>
                            <textarea name="success_message_copy_token" class="wbls-success-message-copy-token"><?php echo esc_html($success_message_copy_token); ?></textarea>
                            <p class="wbls-option-section-group-description">
                                <?php esc_html_e('A form success message text typically informs users that he/she should keep token for future login.', 'whistleblowing-system'); ?>
                            </p>
                        </div>
                        <div class="wbls-option-section-group">
                            <label><?php esc_html_e('Error message text', 'whistleblowing-system'); ?></label>
                            <textarea name="error_message" class="wbls-error-message"><?php echo esc_html($error_message_text); ?></textarea>
                            <p class="wbls-option-section-group-description">
                                <?php esc_html_e('A form error message text typically informs users that their submission was not successful.', 'whistleblowing-system'); ?>
                            </p>
                        </div>
                    </div>
                </div>
                <div class="wbls-option-section wbls-sidebar-menu-item-content wbls-sidebar-advanced">
                    <div class="wbls-option-section-title">
                        <strong><?php esc_html_e('Advanced', 'whistleblowing-system'); ?></strong>
                    </div>
                    <div class="wbls-option-section-content">
                        <div class="wbls-option-section-group">
                            <label><?php esc_html_e('Show anonymous form after submit', 'whistleblowing-system'); ?></label>
                            <div class="wbls-switch-button-cover wbls-switch-button">
                                <div class="button b2 wbls-switch-button" id="wbls-req-switch-button">
                                    <input type="checkbox" class="checkbox wbls-field-option wbls-radio wbls-show-form-after-submit" id="wbls-required-checkbox" name="wbls_show_form_after_submit" <?php echo $wbls_show_form_after_submit === 1 ? 'checked="checked"' : '' ?>/>
                                    <div class="wbls-req-knobs wbls-knobs">
                                        <span></span>
                                    </div>
                                    <div class="wbls-req-layer wbls-switch-layer"></div>
                                </div>
                            </div>
                            <p class="wbls-option-section-group-description">
                                <?php esc_html_e('Choose whether the form should remain visible after it is successfully submitted. If disabled, the form will be hidden after submission (only the success message will be shown).', 'whistleblowing-system'); ?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }

    private function settings_sidebar() {
        ?>
        <div class="wbls-sidebar-menu" id="wbls-form-settings-menu-sidebar" style="display: none">
            <span id="wbls-sidebar-upload-settings" class="wbls-sidebar-menu-item wbls-sidebar-menu-item-active">
                <?php esc_html_e('Upload file settings', 'whistleblowing-system'); ?>
            </span>
            <span id="wbls-sidebar-incoming-webhook-settings" class="wbls-sidebar-menu-item">
                <?php esc_html_e('Incoming Webhook', 'whistleblowing-system'); ?>
            </span>
            <span id="wbls-sidebar-outgoing-webhook-settings" class="wbls-sidebar-menu-item">
                <?php esc_html_e('Outgoing Webhook', 'whistleblowing-system'); ?>
            </span>
        </div>
        <?php
    }

    private function settings( $form_id, $form_settings ) {
        $file_max_size = isset($form_settings['file_max_size']) ? floatval($form_settings['file_max_size']) : 10;
        $file_types = $form_settings['file_types'] ?? ['jpg', 'png', 'gif'];
        $enable_chat_upload = $form_settings['enable_chat_upload'] ?? 1;
        $enable_upload_encrypt = $form_settings['enable_upload_encrypt'] ?? 1;
        ?>
        <div id="wbls-form-settings-menu" class="wbls-form-menu-item-content wbls-settings-container" style="display:none;">
            <div class="wbls-option-section-column">
                <div class="wbls-option-section wbls-sidebar-menu-item-content wbls-sidebar-upload-settings">
                    <div class="wbls-option-section-content">
                        <div class="wbls-option-section-group">
                            <label class="wbls-label"><?php esc_html_e('Enable upload','whistleblowing-system'); ?></label>
                            <div class="wbls-switch-button-cover wbls-switch-button">
                                <div class="button b2 wbls-switch-button" id="wbls-req-switch-button">
                                    <input type="checkbox" class="checkbox wbls-field-option wbls-radio wbls_enable_chat_upload" id="wbls-required-checkbox" name="enable_chat_upload" <?php echo $enable_chat_upload == 1 ? 'checked="checked"' : '' ?>/>
                                    <div class="wbls-req-knobs wbls-knobs">
                                        <span></span>
                                    </div>
                                    <div class="wbls-req-layer wbls-switch-layer"></div>
                                </div>
                            </div>
                            <p class="wbls-option-section-group-description">
                                <?php esc_html_e('Enable the option to make file upload in chat', 'whistleblowing-system'); ?>
                            </p>
                        </div>

                        <div class="wbls-option-section-group">
                            <label><?php esc_html_e('Allowed file types', 'whistleblowing-system'); ?></label>
                            <select name="file_types" class="wbls-file-types" multiple="multiple">
                                <option value="jpg" <?php echo in_array("jpg", $file_types) ? 'selected="selected"' : ''; ?>>JPG</option>
                                <option value="png" <?php echo in_array("png", $file_types) ? 'selected="selected"' : ''; ?>>PNG</option>
                                <option value="gif" <?php echo in_array("gif", $file_types) ? 'selected="selected"' : ''; ?>>GIF</option>
                                <option value="pdf" <?php echo in_array("pdf", $file_types) ? 'selected="selected"' : ''; ?>>PDF</option>
                                <option value="mp3" <?php echo in_array("mp3", $file_types) ? 'selected="selected"' : ''; ?>>MP3</option>
                                <option value="wav" <?php echo in_array("wav", $file_types) ? 'selected="selected"' : ''; ?>>WAV</option>
                                <option value="webm" <?php echo in_array("webm", $file_types) ? 'selected="selected"' : ''; ?>>WEBM</option>
                                <option value="mp4" <?php echo in_array("mp4", $file_types) ? 'selected="selected"' : ''; ?>>MP4</option>
                                <option value="mov" <?php echo in_array("mov", $file_types) ? 'selected="selected"' : ''; ?>>MOV</option>
                                <option value="avi" <?php echo in_array("avi", $file_types) ? 'selected="selected"' : ''; ?>>AVI</option>
                                <option value="m4v" <?php echo in_array("m4v", $file_types) ? 'selected="selected"' : ''; ?>>M4V</option>
                                <option value="flv" <?php echo in_array("flv", $file_types) ? 'selected="selected"' : ''; ?>>FLV</option>
                                <option value="3gp" <?php echo in_array("3gp", $file_types) ? 'selected="selected"' : ''; ?>>3GP</option>
                                <option value="3g2" <?php echo in_array("3g2", $file_types) ? 'selected="selected"' : ''; ?>>3G2</option>
                                <option value="ogg" <?php echo in_array("ogg", $file_types) ? 'selected="selected"' : ''; ?>>OGG</option>
                                <option value="wmv" <?php echo in_array("wmv", $file_types) ? 'selected="selected"' : ''; ?>>WMV</option>
                                <option value="ogv" <?php echo in_array("ogv", $file_types) ? 'selected="selected"' : ''; ?>>OGV</option>
                            </select>
                            <p class="wbls-option-section-group-description">
                                <?php esc_html_e('Select file types which will be allowed for upload', 'whistleblowing-system'); ?>
                                <br>
                                <?php esc_html_e('Note that this option also affects the chat upload field on the admin page and the chat upload field on the frontend page.', 'whistleblowing-system'); ?>
                            </p>
                        </div>
                        <div class="wbls-option-section-group">
                            <label><?php esc_html_e('File maximum size', 'whistleblowing-system'); ?></label>
                            <input type="number" name="file_max_size" class="wbls-file-max-size" value="<?php echo esc_attr($file_max_size); ?>">
                            <p class="wbls-option-section-group-description">
                                <?php esc_html_e('The maximum file size that a user can upload, in MB.', 'whistleblowing-system'); ?>
                                <br>
                                <?php esc_html_e('Note that this option also affects the chat upload field on the admin page and the chat upload field on the frontend page.', 'whistleblowing-system'); ?>
                            </p>
                        </div>
                        <div class="wbls-option-section-group">
                            <label class="wbls-label"><?php esc_html_e('Encrypt uploaded files','whistleblowing-system'); ?></label>
                            <div class="wbls-switch-button-cover wbls-switch-button">
                                <div class="button b2 wbls-switch-button" id="wbls-req-switch-button">
                                    <input type="checkbox" class="checkbox wbls-field-option wbls-radio wbls_enable_upload_encrypt" id="wbls-required-checkbox" name="enable_upload_encrypt" <?php echo $enable_upload_encrypt == 1 ? 'checked="checked"' : '' ?>/>
                                    <div class="wbls-req-knobs wbls-knobs">
                                        <span></span>
                                    </div>
                                    <div class="wbls-req-layer wbls-switch-layer"></div>
                                </div>
                            </div>
                            <p class="wbls-option-section-group-description">
                                <?php esc_html_e('Enable the option to make uploaded files encrypted and secured', 'whistleblowing-system'); ?>
                            </p>
                        </div>
                    </div>
                </div>

                <?php
                $enabled = 0;
                $auth_type = 'bearer';
                $secret    = wp_generate_password( 64, false );
                $mappings   = []; // array of [json_key, field]
                $mode      = 'create';
                $returnAdminToken = 0;
                $returnUserToken = 0;
                ?>
                <div class="wbls-option-section wbls-sidebar-menu-item-content wbls-sidebar-incoming-webhook-settings" style="display: none">
                    <div class="wbls-option-section-title">
                        <strong><?php esc_html_e('Incoming Webhooks (Receive external data into this form)', 'whistleblowing-system'); ?></strong>
                    </div>
                    <div class="wbls-option-section-content">
                        <div class="wbls-option-section-group">
                            <div class="wbls-webhook-section">
                                <!-- Enable toggle -->
                                <label class="wbls-enable-webhook<?php echo WBLS_PRO ? '' : ' wbls-pro-tooltip wbls-pro-tooltip-action'; ?>">
                                    <input type="checkbox"
                                           name="wbls_webhook[incoming][enabled]"
                                           <?php echo $enabled ? 'checked' : ''; ?>
                                           value="1"
                                    >
                                    <?php esc_html_e('Enable Incoming Webhook', 'whistleblowing-system'); ?>
                                </label>

                                <?php
                                $endpoint = rest_url( "wbls/v1/webhook/{$form_id}" );
                                ?>
                                <!-- Endpoint -->
                                <div class="wbls-option-section-group">
                                    <label><?php esc_html_e('Endpoint URL', 'whistleblowing-system'); ?></label>
                                    <div class="wbls-option-row">
                                        <input class="wbls-webhook-incoming-url" type="text" readonly value="<?php echo esc_url($endpoint); ?>">
                                        <button type="button" class="button wbls-copy-webhook-incoming-url">
                                            <?php esc_html_e('Copy', 'whistleblowing-system'); ?>
                                            <span class="wbls-copy-webhook-tooltip"><?php esc_html_e('Copied', 'whistleblowing-system') ?></span>
                                        </button>
                                    </div>
                                </div>

                                <!-- Authentication -->
                                <div class="wbls-option-section-group">
                                    <label><?php esc_html_e('Authentication Type', 'whistleblowing-system'); ?></label>
                                    <div class="wbls-option-auth-header">
                                        <div>
                                            <div class="wbls-option-row">
                                                <label>
                                                    <input type="radio"
                                                           name="wbls_webhook[incoming][auth_type]"
                                                           value="none"
                                                            <?php echo $auth_type === 'none' ? 'checked' : ''; ?>>
                                                    <?php esc_html_e('None', 'whistleblowing-system'); ?>
                                                </label>
                                                <span class="wbls-option-description">⚠️ Not secure, testing only</span>
                                            </div>
                                            <div class="wbls-option-row">
                                                <label>
                                                    <input type="radio"
                                                           name="wbls_webhook[incoming][auth_type]"
                                                           value="bearer"
                                                           <?php echo $auth_type === 'bearer' ? 'checked' : ''; ?>>
                                                    <?php esc_html_e('Bearer Token (Recommended)', 'whistleblowing-system'); ?>
                                                </label>
                                                <span class="wbls-option-description"><?php esc_html_e('Send header: Authorization: Bearer &lt;token&gt;', 'whistleblowing-system'); ?></span>
                                            </div>
                                        </div>
                                        <div>
                                            <div class="wbls-option-row">
                                                <label>
                                                    <input type="radio"
                                                           name="wbls_webhook[incoming][auth_type]"
                                                           value="header"
                                                           <?php echo $auth_type === 'header' ? 'checked' : ''; ?>>
                                                    <?php esc_html_e('API Key in Header', 'whistleblowing-system'); ?>
                                                </label>
                                                <span class="wbls-option-description"><?php esc_html_e('Send header: X-API-Key: &lt;key&gt;', 'whistleblowing-system'); ?></span>
                                            </div>
                                            <div class="wbls-option-row">
                                                <label>
                                                    <input type="radio"
                                                           name="wbls_webhook[incoming][auth_type]"
                                                           value="query"
                                                           <?php echo $auth_type === 'query' ? 'checked' : ''; ?>>
                                                    <?php esc_html_e('API Key in Query (Least Secure)', 'whistleblowing-system'); ?>
                                                </label>
                                                <span class="wbls-option-description"><?php esc_html_e('Send: ?api_key=&lt;key&gt;', 'whistleblowing-system'); ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Secret Key -->
                                <div class="wbls-option-section-group">
                                    <label><?php esc_html_e('Secret Key / Token', 'whistleblowing-system'); ?></label>
                                    <div class="wbls-option-row">
                                        <input type="text"
                                               name="wbls_webhook[incoming][secret]"
                                               value="<?php echo esc_attr( $secret ); ?>"
                                               class="wbls-webhook-secret-token"
                                               placeholder="Auto-generate if empty">
                                        <button type="button" class="button wbls-webhook-generate-token">Generate</button>
                                    </div>
                                </div>

                                <!-- Mode -->
                                <div class="wbls-option-section-group">
                                    <label><strong>Webhook Mode</strong></label><br>
                                    <label>
                                        <input type="radio"
                                               name="wbls_webhook[incoming][mode]"
                                               value="create"
                                               <?php echo $mode === 'create' ? 'checked' : ''; ?>>
                                        <?php esc_html_e('Create new case', 'whistleblowing-system'); ?>
                                    </label>
                                    <?php if ( $this->whistleblower_active ) { ?>
                                    <label>
                                        <input type="radio"
                                               name="wbls_webhook[incoming][mode]"
                                               value="update"
                                               <?php echo $mode === 'update' ? 'checked' : ''; ?>>
                                        <?php esc_html_e('Update existing case', 'whistleblowing-system'); ?>
                                    </label>
                                    <label>
                                        <input type="radio"
                                               name="wbls_webhook[incoming][mode]"
                                               value="auto"
                                               <?php echo $mode === 'auto' ? 'checked' : ''; ?>>
                                        <?php esc_html_e('Auto-detect (if case_id present → update, otherwise → create new)', 'whistleblowing-system'); ?>
                                    </label>
                                    <?php } ?>
                                </div>
                                <!-- JSON Template Preview -->
                                <div class="wbls-option-section-group">
                                    <label>Expected New Case JSON (example)</label>
                                    <textarea readonly rows="10" class="large-text code"><?php echo esc_textarea( $this->wbls_generate_incoming_json_template() ); ?></textarea>
                                    <p class="description">
                                        <?php esc_html_e('Replace the values (labels) with real field values when sending data.', 'whistleblowing-system'); ?>
                                    </p>
                                </div>

                                <?php if($this->whistleblower_active) { ?>
                                <!-- JSON Template Preview -->
                                <div class="wbls-option-section-group">
                                    <label><?php esc_html_e('Expected Case reply JSON (example)', 'whistleblowing-system'); ?></label>
                                    <textarea readonly rows="5" class="large-text code">
{
    "case_id": "Single Line Text (text) → Example value: Sample text",
    "case_reply_message": "Paragraph Text (textarea) → Example value: Sample text"
}
                                    </textarea>
                                    <p class="description">
                                        <?php esc_html_e('Replace the values (labels) with real field values when sending data.', 'whistleblowing-system'); ?>
                                    </p>
                                </div>
                                <?php } ?>

                                <!-- Advanced Mapping (optional) -->
                                <div class="wbls-option-section-group wbls-advanced-mapping">
                                    <label><?php esc_html_e('Advanced Field Mapping', 'whistleblowing-system'); ?></label>
                                    <div class="wbls-mapping-repeater" data-repeater="incoming_mapping">
                                        <?php if( empty($mappings) ) { ?>
                                            <div class="wbls-mapping-repeater-row">
                                            <input type="text"
                                                   name="wbls_webhook[incoming][mapping][0][json_key]"
                                                   value=""
                                                   placeholder="Incoming JSON Key">
                                            <select name="wbls_webhook[incoming][mapping][0][field]">
                                                <option value="">-- <?php esc_html_e('Map to Form Field', 'whistleblowing-system'); ?> --</option>
                                                <option value="case_id"><?php esc_html_e('Case Id', 'whistleblowing-system'); ?></option>
                                                <option value="case_reply_message"><?php esc_html_e('Case reply message', 'whistleblowing-system'); ?></option>
                                                <?php
                                                foreach ($this->fields_options as $val ) {

                                                    if( empty($val) || $val['type'] === 'submit' ||
                                                            $val['type'] === 'file' ||
                                                            $val['type'] === 'recaptcha' ||
                                                            $val['type'] === 'page_break' ||
                                                            $val['type'] === 'anonymous' ||
                                                            $val['type'] === 'html' ||
                                                            $val['type'] === 'address' ||
                                                            $val['type'] === 'DateTime' ||
                                                            $val['type'] === 'fullName' ||
                                                            $val['type'] === 'checkbox'
                                                    ) {
                                                        continue;
                                                    }
                                                    ?>
                                                    <option value="<?php echo esc_attr($val['name']); ?>">
                                                        <?php echo esc_html($val['label']); ?>
                                                    </option>
                                                <?php } ?>
                                            </select>
                                            <span class="wbls-mapping-remove dashicons dashicons-remove"></span>
                                        </div>
                                        <?php } ?>
                                        <?php
                                        //[json_key, field]
                                        foreach ( $mappings as $mapping ) { ?>
                                        <div class="wbls-mapping-repeater-row">
                                            <input type="text"
                                                   name="wbls_webhook[incoming][mapping][0][json_key]"
                                                   value="<?php echo esc_attr($mapping['json_key']); ?>"
                                                   placeholder="Incoming JSON Key">
                                            <select name="wbls_webhook[incoming][mapping][0][field]">
                                                <option value="">-- <?php esc_html_e('Map to Form Field', 'whistleblowing-system'); ?> --</option>
                                                <option value="case_id" <?php echo $mapping['field'] === 'case_id' ? 'selected' : ''; ?>><?php esc_html_e('Case Id', 'whistleblowing-system'); ?></option>
                                                <option value="case_reply_message" <?php echo $mapping['field'] === 'case_reply_message' ? 'selected' : ''; ?>><?php esc_html_e('Case reply message', 'whistleblowing-system'); ?></option>
                                                <?php
                                                foreach ($this->fields_options as $val ) {
                                                    if( empty($val) || $val['type'] === 'submit' ||
                                                        $val['type'] === 'file' ||
                                                        $val['type'] === 'recaptcha' ||
                                                        $val['type'] === 'page_break' ||
                                                        $val['type'] === 'anonymous' ||
                                                        $val['type'] === 'html' ||
                                                        $val['type'] === 'address' ||
                                                        $val['type'] === 'DateTime' ||
                                                        $val['type'] === 'fullName' ||
                                                        $val['type'] === 'checkbox'
                                                    ) {
                                                        continue;
                                                    }
                                                    ?>
                                                    <option value="<?php echo esc_attr($val['name']); ?>" <?php echo $mapping['field'] === $val['name'] ? 'selected' : ''; ?>>
                                                        <?php echo esc_html($val['label']); ?>
                                                    </option>
                                                <?php } ?>
                                            </select>
                                            <button type="button" class="button wbls-mapping-remove">×</button>

                                        </div>
                                        <?php } ?>
                                        <button type="button" class="button wbls-mapping-add">+ <?php esc_html_e('Add Mapping', 'whistleblowing-system'); ?></button>

                                    </div>
                                    <p class="description"><?php esc_html_e('Use only if the external system uses different JSON keys than shown above.', 'whistleblowing-system'); ?></p>
                                </div>

                                <?php if ( $this->whistleblower_active ) { ?>
                                <!-- Extra Actions -->
                                <div class="wbls-option-section-group">
                                    <label><strong><?php esc_html_e('Additional Actions', 'whistleblowing-system'); ?></strong></label><br>
                                    <label>
                                        <input type="checkbox"
                                                  name="wbls_webhook[incoming][returnAdminToken]"
                                                  value="1"
                                                  <?php echo $returnAdminToken ? 'checked' : ''; ?>>
                                        <?php esc_html_e('Return admin login token', 'whistleblowing-system'); ?>
                                    </label>
                                    <label>
                                        <input type="checkbox"
                                                  name="wbls_webhook[incoming][returnUserToken]"
                                                  value="1"
                                                  <?php echo $returnUserToken ? 'checked' : ''; ?>>
                                        <?php esc_html_e('Return user login token', 'whistleblowing-system'); ?>
                                    </label>
                                </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>

                <?php

                $outgoing_data = [];

                $enabled        = !empty($outgoing_data['enabled']);
                $outgoing_url   = esc_url($outgoing_data['outgoing_url'] ?? '');
                $http_method    = $outgoing_data['http_method'] ?? 'POST';
                $content_type   = $outgoing_data['content_type'] ?? 'json';
                $auth_type      = $outgoing_data['auth_type'] ?? 'bearer';
                $auth_token     = $outgoing_data['auth_token'] ?? '';
                $custom_header  = $outgoing_data['custom_header'] ?? '';
                $encrypt_payload = !empty($outgoing_data['encrypt_payload']);
                $encryption_key  = $outgoing_data['encryption_key'] ?? '';

                $triggers = $outgoing_data['triggers'] ?? ['new_case' => 0, 'user_reply' => 0, 'admin_reply' => 0];
                $headers  = $outgoing_data['headers'] ?? [];

                // Each body section
                $sections = ['global', 'new_case', 'user_reply', 'admin_reply'];
                foreach ($sections as $sec) {
                    ${"static_$sec"} = $outgoing_data['body'][$sec] ?? [];
                }

                $shortcode_placeholders = [
                        'site_url' => 'Site URL',
                        'form_name' => 'Form name',
                        'form_id' => 'Form ID',
                        'case_id' => 'Case ID',
                        'event_type' => 'Event type',
                        'reply_message' => 'Reply message',
                        'user_token' => 'User token',
                        'admin_token' => 'Admin token',
                ];

                ?>
                <div class="wbls-placeholder-layout wbls-hidden"></div>
                <div class="wbls-placeholder-popup wbls-hidden">
                    <div class="wbls-placeholder-popup-row">
                        <div class="wbls-placeholder-popup-header">
                            <?php esc_html_e('Form fields', 'whistleblowing-system'); ?>
                            <span class="dashicons dashicons-arrow-down-alt2"></span>
                        </div>
                        <div class="wbls-placeholder-popup-row-body">
                            <?php
                            if (!empty($this->fields_options)) :
                                foreach ($this->fields_options as $field) :
                                    if (empty($field['name']) ||
                                            $field['type'] === 'file' ||
                                            $field['type'] === 'submit' ||
                                            $field['type'] === 'html') continue;
                                    $label = !empty($field['label']) ? $field['label'] : ucfirst($field['type']);
                                    $label = wp_strip_all_tags($label);
                                    $title = $label;
                                    $label = (strlen($label) > 10) ? substr($label, 0, 10) . '...' : $label;
                                    ?>
                                    <button class="button wbls-shortcode-button"
                                            title="<?php echo esc_attr($title); ?>"
                                            data-shortcode="{{<?php echo esc_attr($field['name']); ?>}}">
                                        <?php echo esc_html($label); ?>
                                    </button>
                                <?php
                                endforeach;
                            endif; ?>
                        </div>
                    </div>
                    <div class="wbls-placeholder-popup-row">
                        <div class="wbls-placeholder-popup-header">
                            <?php esc_html_e('Others', 'whistleblowing-system'); ?>
                            <span class="dashicons dashicons-arrow-up-alt2"></span>
                        </div>
                        <div class="wbls-placeholder-popup-row-body wbls-row-body-active">
                        <?php
                            foreach ($shortcode_placeholders as $key => $val) :
                                ?>
                                <button class="button wbls-shortcode-button" data-shortcode="{{<?php echo esc_attr($key); ?>}}">
                                    <?php echo esc_html($val); ?>
                                </button>
                            <?php
                            endforeach;
                         ?>
                        </div>
                    </div>
                </div>

                <div class="wbls-option-section wbls-sidebar-menu-item-content wbls-sidebar-outgoing-webhook-settings" style="display: none">
                    <div class="wbls-option-section-title">
                        <strong><?php esc_html_e('Outgoing Webhooks (Send form data to external services)', 'whistleblowing-system'); ?></strong>
                    </div>
                    <div class="wbls-option-section-content">
                        <div class="wbls-option-section-group">
                            <div class="wbls-webhook-section">
                                <label class="wbls-enable-webhook<?php echo WBLS_PRO ? '' : ' wbls-pro-tooltip wbls-pro-tooltip-action'; ?>">
                                    <input type="checkbox"
                                       class="checkbox wbls-field-option wbls-radio wbls_sendemail"
                                       id="wbls-required-checkbox"
                                       name="wbls_webhook[outgoing][enabled]"
                                       value="1" <?php echo $enabled ? 'checked' : ''; ?>>
                                    <?php esc_html_e('Enable Outgoing Webhook', 'whistleblowing-system'); ?>
                                </label>
                                <hr>

                                <h3 class="wbls-group-title"><?php esc_html_e('Webhook Actions and URL', 'whistleblowing-system'); ?></h3>
                                <!-- Section: Trigger Events -->
                                <div class="wbls-option-section-group wbls-webhook-outgoing-triggers">
                                    <label><?php esc_html_e('Trigger Events', 'whistleblowing-system'); ?></label>
                                    <div class="wbls-option-row">
                                        <label><input type="checkbox"
                                                      name=wbls_webhook[outgoing][triggers][new_case]"
                                                      value="1" <?php echo $triggers['new_case'] ? 'checked' : ''; ?>>
                                            <?php esc_html_e('New Case Created', 'whistleblowing-system'); ?></label>
                                        <label><input type="checkbox"
                                                      name="wbls_webhook[outgoing][triggers][user_reply]"
                                                      value="1" <?php echo $triggers['user_reply'] ? 'checked' : ''; ?>>
                                            <?php esc_html_e('New Reply from User', 'whistleblowing-system'); ?></label>
                                        <label><input type="checkbox"
                                                      name="wbls_webhook[outgoing][triggers][admin_reply]"
                                                      value="1" <?php echo $triggers['admin_reply'] ? 'checked' : ''; ?>>
                                            <?php esc_html_e('New Reply from Admin', 'whistleblowing-system'); ?></label>
                                    </div>
                                </div>

                                <!-- Endpoint -->
                                <div class="wbls-option-section-group">
                                    <label><?php esc_html_e('Webhook URL', 'whistleblowing-system'); ?></label>
                                    <div class="wbls-option-row">
                                        <input class="wbls-webhook-outgoing-url"
                                               name="wbls_webhook[outgoing][outgoing_url]"
                                               type="text"
                                               placeholder="<?php esc_attr_e('https://api.yourwebsite.com', 'whistleblowing-system'); ?>"
                                               value="<?php echo esc_url($outgoing_url); ?>">
                                    </div>
                                </div>

                                <h3 class="wbls-group-title"><?php esc_html_e('Webhook Header', 'whistleblowing-system'); ?></h3>

                                <div class="wbls-option-section-group">
                                    <label><?php esc_html_e('HTTP Method', 'whistleblowing-system'); ?></label>
                                    <div class="wbls-option-row">
                                        <select name="wbls_webhook[outgoing][http_method]" id="wbls_outgoing_method">
                                            <option value="POST" <?php echo ($http_method === 'POST') ? 'selected' : ''; ?>><?php esc_html_e('POST', 'whistleblowing-system'); ?></option>
                                            <option value="PUT" <?php echo ($http_method === 'PUT') ? 'selected' : ''; ?>><?php esc_html_e('PUT', 'whistleblowing-system'); ?></option>
                                            <option value="PATCH" <?php echo ($http_method === 'PATCH') ? 'selected' : ''; ?>><?php esc_html_e('PATCH', 'whistleblowing-system'); ?></option>
                                        </select>
                                    </div>
                                </div>


                                <!-- Authentication -->
                                <div class="wbls-option-section-group">
                                    <label><?php esc_html_e('Authentication Type', 'whistleblowing-system'); ?></label>
                                    <div class="wbls-option-auth-header">
                                        <div>
                                            <div class="wbls-option-row">
                                                <label>
                                                    <input type="radio"
                                                           name="wbls_webhook[outgoing][auth_type]"
                                                           value="none"
                                                            <?php echo $auth_type === 'none' ? 'checked' : ''; ?>>
                                                    <?php esc_html_e('None', 'whistleblowing-system'); ?>
                                                </label>
                                                <span class="wbls-option-description">⚠️ Not secure, testing only</span>
                                            </div>
                                            <div class="wbls-option-row">
                                                <label>
                                                    <input type="radio"
                                                           name="wbls_webhook[outgoing][auth_type]"
                                                           value="bearer"
                                                            <?php echo $auth_type === 'bearer' ? 'checked' : ''; ?>>
                                                    <?php esc_html_e('Bearer Token (Recommended)', 'whistleblowing-system'); ?>
                                                </label>
                                                <span class="wbls-option-description"><?php esc_html_e('Send header: Authorization: Bearer &lt;token&gt;', 'whistleblowing-system'); ?></span>
                                            </div>
                                        </div>
                                        <div>
                                            <div class="wbls-option-row">
                                                <label>
                                                    <input type="radio"
                                                           name="wbls_webhook[outgoing][auth_type]"
                                                           value="query"
                                                            <?php echo $auth_type === 'query' ? 'checked' : ''; ?>>
                                                    <?php esc_html_e('API Key in Query (Least Secure)', 'whistleblowing-system'); ?>
                                                </label>
                                                <span class="wbls-option-description"><?php esc_html_e('Send: ?api_key=&lt;key&gt;', 'whistleblowing-system'); ?></span>
                                            </div>

                                            <div class="wbls-option-row">
                                                <label>
                                                    <input type="radio"
                                                           name="wbls_webhook[outgoing][auth_type]"
                                                           value="header"
                                                            <?php echo $auth_type === 'header' ? 'checked' : ''; ?>>
                                                    <?php esc_html_e('API Key in Header', 'whistleblowing-system'); ?>
                                                </label>
                                                <span class="wbls-option-description"><?php esc_html_e('Send header: X-API-Key: &lt;key&gt;', 'whistleblowing-system'); ?></span>

                                                <label class="wbls_outgoing_custom_header <?php echo ($auth_type !== 'header') ? 'wbls-hidden' : ''; ?>" for="wbls_outgoing_custom_header">
                                                    <?php esc_html_e('Custom Header Name', 'whistleblowing-system'); ?>
                                                    <?php esc_html_e('(optional)', 'whistleblowing-system'); ?>
                                                    <input type="text"
                                                           name="wbls_webhook[outgoing][custom_header]"
                                                           id="wbls_outgoing_custom_header"
                                                           class="regular-text"
                                                           value="<?php echo esc_attr($custom_header); ?>"
                                                           placeholder="<?php esc_attr_e('X-Secret-Token', 'whistleblowing-system'); ?>">
                                                    <span class="wbls-field-description">Enter a custom HTTP header name to use when sending the API key.</span>
                                                    <span class="wbls-field-description">Leave empty to use the default header X-Api-Key.</span>

                                                </label>

                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="wbls-option-section-group">
                                    <label><?php esc_html_e('Token / Key Value', 'whistleblowing-system'); ?></label>
                                    <input type="text"
                                           name="wbls_webhook[outgoing][auth_token]"
                                           id="wbls_outgoing_auth_token"
                                           class="regular-text"
                                           value="<?php echo esc_attr($auth_token); ?>"
                                           placeholder="<?php esc_attr_e('Your api key or token', 'whistleblowing-system'); ?>">
                                </div>

                                <!-- Section: Custom Headers -->
                                <div class="wbls-option-section-group">
                                    <label><?php esc_html_e('Custom Headers', 'whistleblowing-system'); ?></label>
                                    <div class="wbls-mapping-repeater" id="wbls_webhook_headers">
                                        <?php if (!empty($headers)): ?>
                                            <?php foreach ($headers as $i => $header): ?>
                                                <div class="wbls-mapping-repeater-row">
                                                    <input type="text" name="wbls_webhook[outgoing][headers][<?php echo intval($i); ?>][key]"
                                                           value="<?php echo esc_attr($header['key']); ?>" placeholder="Header Name">
                                                    <input type="text" name="wbls_webhook[outgoing][headers][<?php echo intval($i); ?>][value]"
                                                           value="<?php echo esc_attr($header['value']); ?>" placeholder="Header Value">
                                                    <span class="dashicons dashicons-trash"></span>
                                                </div>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                        <button type="button" class="button wbls-add-header">+ <?php esc_html_e('Add Header', 'whistleblowing-system'); ?></button>
                                    </div>
                                </div>

                                <hr>

                                <div class="wbls-webhook-body-section">
                                    <h3 class="wbls-group-title"><?php esc_html_e('Webhook Body', 'whistleblowing-system'); ?></h3>

                                    <!-- Content Type -->
                                    <div class="wbls-option-section-group">
                                        <label for="wbls_outgoing_content_type">
                                            <?php esc_html_e('Content Type', 'whistleblowing-system'); ?>
                                        </label>
                                        <div class="wbls-option-row">
                                            <select name="wbls_webhook[outgoing][content_type]" id="wbls_outgoing_content_type" class="regular-text">
                                                <option value="json" <?php echo ($content_type === 'json') ? 'selected' : ''; ?>><?php esc_html_e('JSON (application/json)', 'whistleblowing-system'); ?></option>
                                                <option value="form" <?php echo ($content_type === 'form') ? 'selected' : ''; ?>><?php esc_html_e('Form Data (application/x-www-form-urlencoded)', 'whistleblowing-system'); ?></option>
                                            </select>
                                        </div>
                                    </div>

                                    <!-- Auto Mapping Section -->
                                    <div class="wbls-body-mode-mapping">
                                        <label><?php esc_html_e('Body', 'whistleblowing-system'); ?></label>
                                        <div class="wbls-body-mode-nav-tab-wrapper">
                                            <span data-href="#wbls-body-mode-tab-global" class="wbls-body-mode-nav-tab wbls-body-mode-nav-tab-active">Global</span>
                                            <span data-href="#wbls-body-mode-tab-newcase" class="wbls-body-mode-nav-tab">New Case</span>
                                            <span data-href="#wbls-body-mode-tab-userreply" class="wbls-body-mode-nav-tab">User Reply</span>
                                            <span data-href="#wbls-body-mode-tab-adminreply" class="wbls-body-mode-nav-tab">Admin Reply</span>
                                        </div>
                                        <div id="wbls-body-mode-tab-global" class="wbls-body-mode-tab-content wbls-body-mode-active">
                                            <div class="wbls-option-section-group">
                                                <p class="wbls-description">
                                                    <?php esc_html_e(
                                                            'Data configured in this section will be included in every outgoing webhook request — regardless of the event type (New Case, User Reply, or Admin Reply). Use this section for data that should always be sent, such as form name, site URL, or authentication details.',
                                                            'whistleblowing-system'
                                                    ); ?>
                                                </p>

                                                <div class="wbls-outgoing-map-header">
                                                    <div class="wbls-outgoing-map-row">
                                                        <div><?php esc_html_e('API Key (JSON Key)', 'whistleblowing-system'); ?></div>
                                                        <div><?php esc_html_e('Value', 'whistleblowing-system'); ?></div>
                                                        <div></div>
                                                    </div>
                                                </div>
                                                <div class="wbls-mapping-repeater wbls-outgoing-map-body wbls-static-field-body">
                                                    <?php if (!empty($static_global)): ?>
                                                        <?php foreach ($static_global as $i => $sf): ?>
                                                            <div class="wbls-mapping-repeater-row">
                                                                <input type="text" name="wbls_webhook[outgoing][body][global][<?php echo intval($i); ?>][key]"
                                                                       value="<?php echo esc_attr($sf['key']); ?>" placeholder="custom_key">
                                                                <input type="text" name="wbls_webhook[outgoing][body][global][<?php echo intval($i); ?>][value]"
                                                                       value="<?php echo esc_attr($sf['value']); ?>" placeholder="custom_value">
                                                                <span class="wbls-menu-placeholder dashicons dashicons-menu"></span>
                                                                <span class="dashicons dashicons-trash"></span>
                                                            </div>
                                                        <?php endforeach; ?>
                                                    <?php else: ?>
                                                        <div class="wbls-mapping-repeater-row">
                                                            <input type="text"
                                                                   name="wbls_webhook[outgoing][body][global][0][key]"
                                                                   value="site_url" placeholder="key">

                                                            <input type="text"
                                                                   name="wbls_webhook[outgoing][body][global][0][value]"
                                                                   placeholder="value"
                                                                   class="regular-text"
                                                                   value="{{site_url}}">
                                                            <span class="wbls-menu-placeholder dashicons dashicons-menu"></span>
                                                            <span class="dashicons dashicons-trash"></span>
                                                        </div>
                                                        <div class="wbls-mapping-repeater-row">
                                                            <input type="text"
                                                                   name="wbls_webhook[outgoing][body][global][1][key]"
                                                                   value="form_name" placeholder="key">

                                                            <input type="text"
                                                                   name="wbls_webhook[outgoing][body][global][1][value]"
                                                                   placeholder="value"
                                                                   class="regular-text"
                                                                   value="{{form_name}}">
                                                            <span class="wbls-menu-placeholder dashicons dashicons-menu"></span>
                                                            <span class="dashicons dashicons-trash"></span>
                                                        </div>
                                                        <div class="wbls-mapping-repeater-row">
                                                            <input type="text"
                                                                   name="wbls_webhook[outgoing][body][global][2][key]"
                                                                   value="case_id" placeholder="key">

                                                            <input type="text"
                                                                   name="wbls_webhook[outgoing][body][global][2][value]"
                                                                   placeholder="value"
                                                                   class="regular-text"
                                                                   value="{{case_id}}">
                                                            <span class="wbls-menu-placeholder dashicons dashicons-menu"></span>
                                                            <span class="dashicons dashicons-trash"></span>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                                <button type="button" class="button wbls-add-new-field" data-key="global">
                                                    <?php esc_html_e('Add new row', 'whistleblowing-system'); ?>
                                                </button>
                                            </div>
                                        </div>

                                        <div id="wbls-body-mode-tab-newcase" class="wbls-body-mode-tab-content">
                                            <div class="wbls-option-section-group">
                                                <p class="wbls-description">
                                                    <?php esc_html_e(
                                                            'These data will be sent when a new case is created, if the "New Case Created" option is enabled in the Trigger Events section.',
                                                            'whistleblowing-system'
                                                    ); ?>
                                                </p>
                                                <div class="wbls-outgoing-map-header">
                                                    <div class="wbls-outgoing-map-row">
                                                        <div><?php esc_html_e('API Key (JSON Key)', 'whistleblowing-system'); ?></div>
                                                        <div><?php esc_html_e('Value', 'whistleblowing-system'); ?></div>
                                                        <div></div>
                                                    </div>
                                                </div>

                                                <div class="wbls-mapping-repeater wbls-outgoing-map-body">
                                                    <?php
                                                    if ( !empty($static_new_case) ):
                                                        foreach ($static_new_case as $i => $sf): ?>
                                                            <div class="wbls-mapping-repeater-row">
                                                                <input type="text" name="wbls_webhook[outgoing][body][new_case][<?php echo intval($i); ?>][key]"
                                                                       value="<?php echo esc_attr($sf['key']); ?>" placeholder="custom_key">
                                                                <input type="text" name="wbls_webhook[outgoing][body][new_case][<?php echo intval($i); ?>][value]"
                                                                       value="<?php echo esc_attr($sf['value']); ?>" placeholder="custom_value">
                                                                <span class="wbls-menu-placeholder dashicons dashicons-menu"></span>
                                                                <span class="dashicons dashicons-trash"></span>
                                                            </div>
                                                        <?php endforeach; ?>
                                                    <?php
                                                    else:
                                                        if (!empty($this->fields_options)) : ?>
                                                        <?php
                                                            $i = 0;
                                                            foreach ($this->fields_options as $field) :
                                                                if (empty($field['name']) || $field['type'] === 'file') continue;
                                                                $label = !empty($field['label']) ? $field['label'] : ucfirst($field['type']);
                                                                ?>
                                                                <div class="wbls-mapping-repeater-row">
                                                                    <input type="text"
                                                                           name="wbls_webhook[outgoing][body][new_case][<?php echo intval($i); ?>][key]"
                                                                           value="<?php echo esc_attr($field['name']); ?>"
                                                                           title="<?php echo esc_attr($label); ?>"
                                                                           placeholder="key">
                                                                    <input type="text"
                                                                           name="wbls_webhook[outgoing][body][new_case][<?php echo intval($i); ?>][value]"
                                                                           value="{{<?php echo esc_attr($field['name']); ?>}}" placeholder="value">
                                                                    <span class="wbls-menu-placeholder dashicons dashicons-menu"></span>
                                                                    <span class="dashicons dashicons-trash"></span>
                                                                </div>
                                                            <?php
                                                            $i++;
                                                            endforeach; ?>
                                                        <?php
                                                        else : ?>
                                                            <div class="wbls-outgoing-map-row">
                                                                <?php esc_html_e('No form fields found.', 'whistleblowing-system'); ?>
                                                            </div>
                                                        <?php
                                                        endif; ?>
                                                    <?php
                                                    endif; ?>
                                                </div>
                                                <button type="button" class="button wbls-add-new-field" data-key="new_case">
                                                    <?php esc_html_e('Add new row', 'whistleblowing-system'); ?>
                                                </button>
                                            </div>
                                        </div>

                                        <div id="wbls-body-mode-tab-userreply" class="wbls-body-mode-tab-content">
                                            <div class="wbls-option-section-group">
                                                <p class="wbls-description">
                                                    <?php esc_html_e(
                                                            'These data will be sent when a user reply is created, if the "New Reply from User" option is enabled in the Trigger Events section.',
                                                            'whistleblowing-system'
                                                    ); ?>
                                                </p>
                                                <div class="wbls-outgoing-map-header">
                                                    <div class="wbls-outgoing-map-row">
                                                        <div><?php esc_html_e('API Key (JSON Key)', 'whistleblowing-system'); ?></div>
                                                        <div><?php esc_html_e('Value', 'whistleblowing-system'); ?></div>
                                                        <div></div>
                                                    </div>
                                                </div>

                                                <div class="wbls-mapping-repeater wbls-outgoing-map-body wbls-static-field-body">
                                                    <?php if (!empty($static_user_reply)): ?>
                                                        <?php foreach ($static_user_reply as $i => $sf): ?>
                                                            <div class="wbls-mapping-repeater-row">
                                                                <input type="text" name="wbls_webhook[outgoing][body][user_reply][<?php echo intval($i); ?>][key]"
                                                                       value="<?php echo esc_attr($sf['key']); ?>" placeholder="custom_key">
                                                                <input type="text" name="wbls_webhook[outgoing][body][user_reply][<?php echo intval($i); ?>][value]"
                                                                       value="<?php echo esc_attr($sf['value']); ?>" placeholder="custom_value">
                                                                <span class="wbls-menu-placeholder dashicons dashicons-menu"></span>
                                                                <span class="dashicons dashicons-trash"></span>
                                                            </div>
                                                        <?php endforeach; ?>
                                                    <?php else: ?>
                                                        <div class="wbls-mapping-repeater-row">
                                                            <input type="text"
                                                                   name="wbls_webhook[outgoing][body][user_reply][0][key]"
                                                                   value="reply_message"
                                                                   placeholder="key">

                                                            <input type="text"
                                                                   name="wbls_webhook[outgoing][body][user_reply][0][value]"
                                                                   placeholder="value"
                                                                   class="regular-text"
                                                                   value="{{reply_message}}">
                                                            <span class="wbls-menu-placeholder dashicons dashicons-menu"></span>
                                                            <span class="dashicons dashicons-trash"></span>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                                <button type="button" class="button wbls-add-new-field" data-key="user_reply">
                                                    <?php esc_html_e('Add new row', 'whistleblowing-system'); ?>
                                                </button>
                                            </div>
                                        </div>

                                        <div id="wbls-body-mode-tab-adminreply" class="wbls-body-mode-tab-content">

                                            <div class="wbls-option-section-group">
                                                <p class="wbls-description">
                                                    <?php esc_html_e(
                                                            'These data and settings will be sent when a admin reply is created, if the "New Reply from Admin" option is enabled in the Trigger Events section.',
                                                            'whistleblowing-system'
                                                    ); ?>
                                                </p>
                                                <div class="wbls-outgoing-map-header">
                                                    <div class="wbls-outgoing-map-row">
                                                        <div><?php esc_html_e('API Key (JSON Key)', 'whistleblowing-system'); ?></div>
                                                        <div><?php esc_html_e('Value', 'whistleblowing-system'); ?></div>
                                                        <div></div>
                                                    </div>
                                                </div>

                                                <div class="wbls-mapping-repeater wbls-outgoing-map-body wbls-static-field-body">
                                                    <?php if (!empty($static_admin_reply)): ?>
                                                        <?php foreach ($static_admin_reply as $i => $sf): ?>
                                                            <div class="wbls-mapping-repeater-row">
                                                                <input type="text" name="wbls_webhook[outgoing][body][admin_reply][<?php echo intval($i); ?>][key]"
                                                                       value="<?php echo esc_attr($sf['key']); ?>" placeholder="custom_key">
                                                                <input type="text" name="wbls_webhook[outgoing][body][admin_reply][<?php echo intval($i); ?>][value]"
                                                                       value="<?php echo esc_attr($sf['value']); ?>" placeholder="custom_value">
                                                                <span class="wbls-menu-placeholder dashicons dashicons-menu"></span>
                                                                <span class="dashicons dashicons-trash"></span>
                                                            </div>
                                                        <?php endforeach; ?>
                                                    <?php else: ?>
                                                        <div class="wbls-mapping-repeater-row">
                                                            <input type="text"
                                                                   name="wbls_webhook[outgoing][body][admin_reply][0][key]"
                                                                   value="reply_message"
                                                                   placeholder="key">

                                                            <input type="text"
                                                                   name="wbls_webhook[outgoing][body][admin_reply][0][value]"
                                                                   placeholder="value"
                                                                   class="regular-text"
                                                                   value="{{reply_message}}">
                                                            <span class="wbls-menu-placeholder dashicons dashicons-menu"></span>
                                                            <span class="dashicons dashicons-trash"></span>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                                <button type="button" class="button wbls-add-new-field" data-key="admin_reply">
                                                    <?php esc_html_e('Add new row', 'whistleblowing-system'); ?>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Section: Encryption -->
                                <div class="wbls-option-section-group">
                                    <label><?php esc_html_e('Encryption (Optional)', 'whistleblowing-system'); ?></label>
                                    <div class="wbls-option-row">
                                            <input type="checkbox" name="wbls_webhook[outgoing][encrypt_payload]" value="1" <?php echo $encrypt_payload ? 'checked' : ''; ?>>
                                            <?php esc_html_e('Enable AES-256 Encryption', 'whistleblowing-system'); ?>
                                    </div>
                                    <label><?php esc_html_e('Secret Key', 'whistleblowing-system'); ?></label>
                                    <div class="wbls-option-row">
                                        <input type="text"
                                               id="wbls_outgoing_encryption_key"
                                               name="wbls_webhook[outgoing][encryption_key]"
                                               class="regular-text"
                                               value="<?php echo esc_attr($encryption_key); ?>"
                                               placeholder="<?php esc_attr_e('shared_secret_key', 'whistleblowing-system'); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php
    }

    private function shortcode_popup( $id ) {
        ?>
        <div class="wbls-shortcode-layer" style="display:none"></div>
        <div class="wbls-shortcode-popup" style="display:none">
            <?php if ( $this->whistleblower_active ) { ?>
                <div class="wbls-shortcode-popup-title">
                    <?php esc_html_e('Shortcode will show tabs view as start.', 'whistleblowing-system'); ?>
                    <span class="dashicons dashicons-info"><img src="<?php echo esc_url(WBLS_URL . '/admin/assets/images/tabs_view.jpg'); ?>"></span>
                </div>
            <?php } ?>
            <div class="wbls-shortcode-popup-row">
                <input type="text" id="wbls-shortcode" class="wbls-form-shortcode" disabled="" value='[wblsform id="<?php echo intval($id); ?>" type="tab"]'>
                <span id="wbls-shortcode-copy" title="<?php esc_attr_e('Copy embed code to clipboard', 'whistleblowing-system'); ?>">
                        <span class="wbls-form-shortcode-copy-tooltip"><?php esc_html_e('Copied', 'whistleblowing-system') ?></span>
                    </span>
            </div>
            <?php if ( $this->whistleblower_active ) { ?>
                <div class="wbls-shortcode-popup-title">
                    <?php esc_html_e('Shortcode will show buttons view as start.', 'whistleblowing-system'); ?>
                    <span class="dashicons dashicons-info"><img src="<?php echo esc_url(WBLS_URL . '/admin/assets/images/buttons_view.jpg'); ?>"></span>
                </div>
            <?php } ?>
            <div class="wbls-shortcode-popup-row">
                <input type="text" id="wbls-shortcode" class="wbls-form-shortcode" disabled="" value='[wblsform id="<?php echo intval($id); ?>"]'>
                <span id="wbls-shortcode-copy" title="<?php esc_attr_e('Copy embed code to clipboard', 'whistleblowing-system'); ?>">
                        <span class="wbls-form-shortcode-copy-tooltip"><?php esc_html_e('Copied', 'whistleblowing-system') ?></span>
                    </span>
            </div>
            <?php if ( $this->whistleblower_active ) { ?>
                <div class="wbls-shortcode-popup-title">
                    <?php esc_html_e('Shortcode will show form.', 'whistleblowing-system'); ?>
                    <span class="dashicons dashicons-info"><img src="<?php echo esc_url(WBLS_URL . '/admin/assets/images/form.jpg'); ?>"></span>
                </div>
                <div class="wbls-shortcode-popup-row">
                    <input type="text" id="wbls-form-shortcode" class="wbls-form-shortcode" disabled="" value='[wblsform id="<?php echo intval($id); ?>" type="form"]'>
                    <span id="wbls-form-shortcode-copy" title="<?php esc_attr_e('Copy embed code to clipboard', 'whistleblowing-system'); ?>">
                        <span class="wbls-form-shortcode-copy-tooltip"><?php esc_html_e('Copied', 'whistleblowing-system') ?></span>
                    </span>
                </div>
                <div class="wbls-shortcode-popup-title">
                    <?php esc_html_e('Shortcode will show login/chat view', 'whistleblowing-system'); ?>
                    <span class="dashicons dashicons-info"><img src="<?php echo esc_url( WBLS_URL . '/admin/assets/images/login_view.jpg'); ?>"></span>
                </div>
                <div class="wbls-shortcode-popup-row">
                    <input type="text" id="wbls-reply-shortcode" class="wbls-form-shortcode" disabled="" value='[wblsform id="<?php echo intval($id); ?>" type="login"]'>
                    <span id="wbls-reply-shortcode-copy" title="<?php esc_attr_e('Copy embed code to clipboard', 'whistleblowing-system'); ?>">
                        <span class="wbls-form-shortcode-copy-tooltip"><?php esc_html_e('Copied', 'whistleblowing-system') ?></span>
                    </span>
                </div>
            <?php } ?>
        </div>

        <?php
    }

    public function placeholder_buttons( $fields_options, $field_type = '', $class_name = '', $custom_fields = [], $adminTab = true ) {
        ?>
        <div class="wbls-email-placeholder-row <?php echo esc_attr($class_name)?>">
            <?php if ( $field_type === '' ) { ?>
                <span class="wbls-field-placeholder" data-field-id="all">All</span>
                <?php if( $adminTab ) { ?>
                    <span class="wbls-field-placeholder" data-field-id="form_title">Form title</span>
                    <span class="wbls-field-placeholder" data-field-id="form_id">Form ID</span>
                    <span class="wbls-field-placeholder" data-field-id="submission_id">Submission ID</span>
                <?php } ?>
            <?php } ?>
        <?php
        foreach ( $fields_options as $key => $field ) {
            if( empty($field) ||
                    $field['type'] == 'recaptcha' ||
                    $field['type'] == 'submit' ||
                    $field['type'] == 'file' ||
                    $field['type'] == 'html' ||
                    ($field_type != '' && $field_type !== $field['type'])
            ) {
                continue;
            }
            $label = $field['label'] ? $field['label'] : $field['title'];
            ?>
            <span class="wbls-field-placeholder" data-field-id="<?php echo esc_attr($key); ?>"><?php echo esc_html($label); ?></span>
            <?php
        }
        foreach ( $custom_fields as $key => $field ) {
            ?>
            <span class="wbls-field-placeholder" data-field-id="<?php echo esc_attr($key); ?>"><?php echo esc_html($field); ?></span>
            <?php
        }

        ?>
        </div>
        <?php
    }

    public function fields_content() {
        $form_fields = $this->get_translated_form_fields();
        usort($form_fields, function($a, $b) {
            return $a['order'] <=> $b['order'];
        });

        foreach ( $form_fields as $form_field ) {
            $pro_class = "";
            if ( $form_field['pro'] && !WBLS_PRO ) {
                $pro_class = " wbls-pro-tooltip wbls-pro-tooltip-action";
            }
            ?>
            <span class="wbls-field-item<?php echo esc_attr($pro_class); ?>" data-type="<?php echo esc_attr($form_field['type']); ?>">
                <?php echo esc_html($form_field['title']); ?>
            </span>
            <?php
        }
    }

    public function form_content() {
        $id = isset($_GET['id']) ? intval($_GET['id']) : 0;
        if( $id ) {
            $content =  get_post_meta( $id, 'wbls_form_content', true );
            if( empty($content) ) {
                wp_redirect('?page=whistleblower_form_edit');
                exit;
            }
            ?>
            <div class="wbls-form-container wbls-form-container-admin">
                <div class="wbls-form wbls-form-admin">
                    <div id="wbls-take" data-id="<?php echo intval($id); ?>">
                        <?php echo wp_kses(trim($content), WBLSLibrary::$wp_kses_form); ?>
                    </div>
                    <div class="wbls-add-new-page wbls-field-item wbls-pro-tooltip wbls-pro-tooltip-action" data-type="page_break">
                        <?php esc_html_e('Add New Page', 'whistleblowing-system'); ?>
                    </div>
                </div>
            </div>
            <?php
        } else {
            ?>
            <div class="wbls-form-container wbls-form-container-admin">
                <div class="wbls-form wbls-form-admin">
                    <div id="wbls-take" data-id="0">
                        <div class="wblsform-page-and-images wbls-form-builder">
                            <div class="wblsform_section"></div>
                        </div>
                    </div>
                    <div class="wbls-add-new-page wbls-field-item wbls-pro-tooltip wbls-pro-tooltip-action" data-type="page_break">
                        <?php esc_html_e('Add New Page', 'whistleblowing-system'); ?>
                    </div>

                </div>
            </div>
            <?php
        }
    }
}
