<?php
namespace WBLS_WhistleBlower\Free;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class WhistleblowerForms {
    public function __construct() {
        $task = isset($_GET['task']) ? sanitize_text_field(wp_unslash($_GET['task'])) : '';
        if ( method_exists($this, $task) ) {
            $this->$task();
        } else {
            $this->display();
        }
    }

    public function duplicate_form_link( $post_id ) {
        $url = wp_nonce_url(
                add_query_arg(
                        [
                                'page' => 'whistleblower_forms',
                                'task'  => 'wbls_duplicate_post',
                                'post_id' => $post_id,
                        ],
                        admin_url('admin.php')
                ),
                'wbls_duplicate_' . $post_id
        );
        return $url;
    }

    public function display() {
        $forms = get_posts( ['post_type' => 'wbls_form', 'numberposts' => -1] );
        wp_enqueue_style(WBLS_PREFIX . '-style');

        WBLSLibrary::wbls_render_topbar_row(); ?>
        <div class="wbls-admin-header">
            <img class="wbls-admin-header-logo" src="<?php echo esc_url(WBLS_URL . '/admin/assets/images/whistleblowing_logo.png'); ?>">
            <h2 class="wbls-page-title"><?php esc_html_e('All Forms', 'whistleblowing-system') ?></h2>
            <a href="?page=whistleblower_form_edit" class="wbls-button wbls-button-add-form"><?php esc_html_e('Add New', 'whistleblowing-system') ?></a>
        </div>
        <p class="wbls-response-message"></p>
        <div class="wrap wbls-content">
            <div class="wbls-forms-list">
                <div class="wbls-forms-list-row wbls-forms-list-title">
                    <div class="wbls-form-name"><?php esc_html_e('Name', 'whistleblowing-system') ?></div>
                    <div class="wbls-form-author"><?php esc_html_e('Submissions', 'whistleblowing-system') ?></div>
                    <div class="wbls-form-shortcode"><?php esc_html_e('Shortcode', 'whistleblowing-system') ?></div>
                    <div class="wbls-form-date"><?php esc_html_e('Date', 'whistleblowing-system') ?></div>
                    <div class="wbls-form-type"><?php esc_html_e('Type', 'whistleblowing-system') ?></div>
                </div>
                <?php
                foreach ($forms as $form ) {
                    $whistleblower_active = WBLSLibrary::is_whistleblower_active( $form->ID );
                    $url = $this->duplicate_form_link( $form->ID );
                    ?>
                    <div class="wbls-forms-list-row">
                        <div class="wbls-form-name">
                            <a href="?page=whistleblower_form_edit&id=<?php echo intval($form->ID); ?>"><?php echo esc_html($form->post_title) ?></a>
                            <div class="wbls-row-actions row-actions">
                                <span class="edit"><a href="?page=whistleblower_form_edit&id=<?php echo intval($form->ID); ?>" aria-label="Edit “Hello world!”"><?php esc_html_e('Edit', 'whistleblowing-system') ?></a> | </span>
                                <span class="wbls-duplicate-form" data-id="<?php echo intval($form->ID); ?>">
                                    <a href="<?php echo esc_url( $url ); ?>">
                                        <?php esc_html_e('Duplicate', 'whistleblowing-system'); ?>
                                    </a> |
                                </span>
                                <span class="wbls-delete-form" data-id="<?php echo intval($form->ID); ?>">
                                    <?php esc_html_e('Delete', 'whistleblowing-system') ?>
                                </span> |
                                <span class="wbls-preview-form" data-id="<?php echo intval($form->ID); ?>">
                                    <a href="<?php echo esc_url( add_query_arg( 'wbls_preview_type', 'tab', get_post_permalink( $form->ID, true ) ) ); ?>" target="_blank">
                                        <?php esc_html_e('Preview', 'whistleblowing-system'); ?>
                                    </a>
                                </span>
                            </div>
                        </div>
                        <div class="wbls-form-author">
                            <?php $subm_count = WBLSLibrary::get_submissions_count($form->ID);
                            if($subm_count) {
                            ?>
                            <a href="?page=whistleblower_submission_edit&id=<?php echo intval($form->ID); ?>" title="<?php esc_attr_e('Go to submissions', 'whistleblowing-system') ?>"><?php echo esc_html($subm_count) ?></a>
                            <?php
                            }
                            else {
                                echo esc_html($subm_count);
                            } ?>
                        </div>
                        <div class="wbls-form-shortcode">[wblsform id="<?php echo intval($form->ID); ?>" type="tab"]</div>
                        <div class="wbls-form-date"><?php echo esc_html($form->post_date); ?></div>
                        <div class="wbls-form-type">
                            <?php
                                if( !$whistleblower_active ) {
                                    esc_html_e('Standart', 'whistleblowing-system');
                                } else {
                                    esc_html_e('Whistleblowing', 'whistleblowing-system');
                                }
                            ?>
                        </div>
                    </div>
                    <?php
                }
                ?>
            </div>
        </div>
        <?php
    }

    public function wbls_duplicate_post() {
        $post_id = isset($_GET['post_id']) ? absint($_GET['post_id']) : 0;
        if (!$post_id || get_post_type($post_id) !== 'wbls_form') {
            wp_die(esc_html__('Invalid form ID.', 'whistleblowing-system'));
        }
        check_admin_referer('wbls_duplicate_' . $post_id);

        $orig = get_post($post_id);
        if (!$orig) wp_die(esc_html__('Original form not found.', 'whistleblowing-system'));

        // Create the new draft form
        $new_id = wp_insert_post([
                'post_author'   => get_current_user_id(),
                'post_title'    => sprintf(__('Copy of %s', 'whistleblowing-system'), $orig->post_title),
                'post_status'   => 'publish',
                'post_type'     => 'wbls_form',
                'menu_order'    => $orig->menu_order,
                'comment_status'=> $orig->comment_status,
                'ping_status'   => $orig->ping_status,
        ], true);
        if (is_wp_error($new_id)) {
            wp_die(esc_html($new_id->get_error_message()));
        }

        // Copy the known meta keys (preserve arrays as-is)
        $meta_keys = [
                'wbls_field_options',
                'wbls_email_options',
                'wbls_form_settings',
                'wbls_fieldNameLastId',
                'wbls_form_content',
                'wbls_form_conditions', // optional
        ];

        foreach ($meta_keys as $key) {
            $val = get_post_meta($post_id, $key, true);
            if ($val !== '' && $val !== null) {
                // Make sure integers remain integers
                if ($key === 'wbls_fieldNameLastId') $val = intval($val);
                update_post_meta($new_id, $key, $val);
            }
        }

        // Set the shortcode for the NEW form id
        wp_update_post([
                'ID'           => $new_id,
                'post_content' => '[wblsform id="' . intval($new_id) . '"]',
        ]);

        // If you need to (re)build conditions artifacts for the duplicated form, do it here
        $form_conditions = get_post_meta($new_id, 'wbls_form_conditions', true);
        $field_options   = get_post_meta($new_id, 'wbls_field_options', true);
        if (!empty($form_conditions) && class_exists('\WBLS_WhistleBlower\Free\WBLS_Conditions')) {
            $args = [
                    'form_id'          => $new_id,
                    'field_options'    => is_array($field_options) ? $field_options : [],
                    'form_conditions'  => is_array($form_conditions) ? $form_conditions : [],
            ];
            new \WBLS_WhistleBlower\Free\WBLS_Conditions($args);
        }

        // Go to the edit screen of the duplicate
        wp_safe_redirect(
                add_query_arg(['page' => 'whistleblower_forms'], admin_url('admin.php'))
        );
        exit;
    }
}
