<?php
namespace WBLS_WhistleBlower\Free;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class WhistleblowerSettings {
    public function __construct() {
        $this->display();
    }

    public function display() {
        wp_enqueue_style(WBLS_PREFIX . '-settings');
        wp_enqueue_script(WBLS_PREFIX . '-settings');
        wp_enqueue_style(WBLS_PREFIX . '-style');
        wp_enqueue_style(WBLS_PREFIX . '-edit');
        wp_enqueue_style(WBLS_PREFIX . '-admin');

        $wbls_global_settings = json_decode( get_option( 'wbls_global_settings' ), 1 );
        $teeny_active = get_option('teeny_active', true);
        $user_token_visibility_active = isset($wbls_global_settings['user_token_visibility_active']) ? esc_html($wbls_global_settings['user_token_visibility_active']) : false;
        $token_length = 32;

        $logs_active = isset($wbls_global_settings['logs_active']) ? esc_html($wbls_global_settings['logs_active']) : false;
        $logs_lifetime = isset($wbls_global_settings['logs_lifetime']) ? esc_html($wbls_global_settings['logs_lifetime']) : 30;

        $reCAPTCHA_v2_site_key = isset($wbls_global_settings['reCAPTCHA_v2_site_key']) ? esc_html($wbls_global_settings['reCAPTCHA_v2_site_key']) : '';
        $reCAPTCHA_v2_secret_key = isset($wbls_global_settings['reCAPTCHA_v2_secret_key']) ? esc_html($wbls_global_settings['reCAPTCHA_v2_secret_key']) : '';
        $reCAPTCHA_language = isset($wbls_global_settings['reCAPTCHA_language']) ? esc_html($wbls_global_settings['reCAPTCHA_language']) : '';
        $reCAPTCHA_v3_site_key = isset($wbls_global_settings['reCAPTCHA_v3_site_key']) ? esc_html($wbls_global_settings['reCAPTCHA_v3_site_key']) : '';
        $reCAPTCHA_v3_secret_key = isset($wbls_global_settings['reCAPTCHA_v3_secret_key']) ? esc_html($wbls_global_settings['reCAPTCHA_v3_secret_key']) : '';

        if( WBLS_PRO ) {
            $wbls_license = isset($wbls_global_settings['wbls_license']) ? $wbls_global_settings['wbls_license'] : '';
            $license_status = get_option('wbls_license_status');
        }
        WBLSLibrary::wbls_render_topbar_row(); ?>
        <div class="wbls-admin-header">
            <img class="wbls-admin-header-logo" src="<?php echo esc_url(WBLS_URL . '/admin/assets/images/whistleblowing_logo.png'); ?>">
            <h2 class="wbls-page-title"><?php esc_html_e('Global Settings', 'whistleblowing-system') ?></h2>
            <span class="wbls-button wbls-save-settings"><?php esc_html_e('Save', 'whistleblowing-system'); ?></span>
        </div>
        <p class="wbls-response-message"></p>

        <div class="wbls-settings-menu-tabs">
            <div id="wbls-tab-recaptcha" class="wbls-tab-item wbls-tab-item-active"><?php esc_html_e('reCAPTCHA', 'whistleblowing-system') ?></div>
            <?php if( WBLS_PRO ) { ?>
            <div id="wbls-tab-license" class="wbls-tab-item"><?php esc_html_e('License', 'whistleblowing-system') ?></div>
            <?php } ?>
            <div id="wbls-tab-logs" class="wbls-tab-item"><?php esc_html_e('Logs', 'whistleblowing-system') ?></div>
            <div id="wbls-tab-advanced" class="wbls-tab-item"><?php esc_html_e('Advanced', 'whistleblowing-system') ?></div>
        </div>
        <div id="wbls-form-settings-menu" class="wbls-form-menu-item-content wbls-settings-container">
            <div class="wbls-option-section-column wbls-tab-content wbls-tab-recaptcha-content">
                <div class="wbls-option-section<?php echo WBLS_PRO ? '' : ' wbls-pro-tooltip wbls-pro-tooltip-action'; ?>">
                    <div class="wbls-option-section-title">
                        <strong><?php esc_html_e('reCAPTCHA', 'whistleblowing-system'); ?></strong>
                    </div>
                    <div class="wbls-option-section-content">
                        <div class="wbls-option-section-group">
                            <label><?php esc_html_e('reCAPTCHA v2 Site Key', 'whistleblowing-system'); ?></label>
                            <input type="text" name="reCAPTCHA_v2_site_key" class="reCAPTCHA_v2_site_key" value="<?php echo esc_html($reCAPTCHA_v2_site_key); ?>">
                            <p class="wbls-option-section-group-description">
                                <?php esc_html_e('Get a site key for your domain by registering. ', 'whistleblowing-system'); ?>
                                <a href="https://www.google.com/recaptcha/intro/index.html" target="_blank"><?php esc_html_e('here', 'whistleblowing-system'); ?></a>
                            </p>
                        </div>
                        <div class="wbls-option-section-group">
                            <label><?php esc_html_e('reCAPTCHA v2 Secret Key', 'whistleblowing-system'); ?></label>
                            <input type="text" name="reCAPTCHA_v2_secret_key" class="reCAPTCHA_v2_secret_key" value="<?php echo esc_html($reCAPTCHA_v2_secret_key); ?>">
                            <p class="wbls-option-section-group-description">
                            </p>
                        </div>
                        <div class="wbls-option-section-group">
                            <label><?php esc_html_e('reCAPTCHA Language', 'whistleblowing-system'); ?></label>
                            <input type="text" name="reCAPTCHA_language" class="reCAPTCHA_language" value="<?php echo esc_html($reCAPTCHA_language); ?>">
                            <p class="wbls-option-section-group-description">
                                <?php esc_html_e('e.g. en, de - Language used by reCAPTCHA. To get the code for your language click ', 'whistleblowing-system'); ?>
                                <a href="https://www.google.com/recaptcha/intro/index.html" target="_blank"><?php esc_html_e('here', 'whistleblowing-system'); ?></a>
                            </p>
                        </div>
                        <div class="wbls-option-section-group">
                            <label><?php esc_html_e('reCAPTCHA v3 Site Key', 'whistleblowing-system'); ?></label>
                            <input type="text" name="reCAPTCHA_v3_site_key" class="reCAPTCHA_v3_site_key" value="<?php echo esc_html($reCAPTCHA_v3_site_key); ?>">
                            <p class="wbls-option-section-group-description">
                                <?php esc_html_e('Get a site key for your domain by registering. ', 'whistleblowing-system'); ?>
                                <a href="https://www.google.com/recaptcha/intro/index.html" target="_blank"><?php esc_html_e('here', 'whistleblowing-system'); ?></a>
                            </p>
                        </div>
                        <div class="wbls-option-section-group">
                            <label><?php esc_html_e('reCAPTCHA v3 Secret Key', 'whistleblowing-system'); ?></label>
                            <input type="text" name="reCAPTCHA_v3_secret_key" class="reCAPTCHA_v3_secret_key" value="<?php echo esc_html($reCAPTCHA_v3_secret_key); ?>">
                            <p class="wbls-option-section-group-description">
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <?php if( WBLS_PRO ) { ?>
            <div class="wbls-option-section-column wbls-tab-content wbls-tab-license-content"  style="display:none">
                <div class="wbls-option-section">
                    <div class="wbls-option-section-title">
                        <strong><?php esc_html_e('License', 'whistleblowing-system'); ?></strong>
                    </div>
                    <div class="wbls-option-section-content">
                        <div class="wbls-option-section-group">
                            <label><?php esc_html_e('License Code', 'whistleblowing-system'); ?></label>
                            <div class="wbls-license-cont">
                                <div>
                                    <input <?php echo $license_status === 'active' ? 'readonly' : ''; ?> type="text" name="wbls-license" class="wbls-license" value="<?php echo esc_attr($wbls_license); ?>">
                                    <p class="wbls-option-section-group-description"><?php esc_html_e('License Code', 'whistleblowing-system'); ?></p>
                                </div>
                                <span <?php if($license_status !== 'active') { ?> style="display:none" <?php } ?> class="wbls-deactivate-license-button license-button" data-text="<?php esc_attr_e('Activate License', 'whistleblowing-system'); ?>"><?php esc_html_e('Deactivate License', 'whistleblowing-system'); ?></span>
                                <span <?php if($license_status === 'active') { ?> style="display:none" <?php } ?> class="wbls-activate-license-button license-button" data-text="<?php esc_attr_e('Deactivate License', 'whistleblowing-system'); ?>"><?php esc_html_e('Activate License', 'whistleblowing-system'); ?></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php } ?>
            <div class="wbls-option-section-column wbls-tab-content wbls-tab-logs-content"  style="display:none">
                <div class="wbls-option-section">
                    <div class="wbls-option-section-title">
                        <strong><?php esc_html_e('Logs', 'whistleblowing-system'); ?></strong>
                    </div>
                    <div class="wbls-option-section-content">
                        <div class="wbls-option-section-group">
                            <label><?php esc_html_e('Logs Active', 'whistleblowing-system'); ?></label>
                            <input type="radio" name="logs_active" class="wbls-logs_active" value="1" <?php if($logs_active) { echo 'checked'; } ?>> Yes
                            <input type="radio" name="logs_active" class="wbls-logs_active" value="0" <?php if(!$logs_active) { echo 'checked'; } ?>> No
                            <p class="wbls-option-section-group-description"></p>
                        </div>
                        <div class="wbls-option-section-group">
                            <label><?php esc_html_e('Auto-delete logs after', 'whistleblowing-system'); ?></label>
                            <input type="number" name="logs_lifetime" class="wbls-logs_lifetime" value="<?php echo intval($logs_lifetime); ?>">
                            <?php esc_html_e(' days', 'whistleblowing-system'); ?>
                            <p class="wbls-option-section-group-description"><?php esc_html_e('Choose how many days to retain log entries. A daily task purges entries older than this value. Set 0 to keep logs indefinitely.', 'whistleblowing-system'); ?></p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="wbls-option-section-column wbls-tab-content wbls-tab-advanced-content" style="display:none">
                <div class="wbls-option-section">
                    <div class="wbls-option-section-title">
                        <strong><?php esc_html_e('Advanced', 'whistleblowing-system'); ?></strong>
                    </div>
                    <div class="wbls-option-section-content">
                        <div class="wbls-option-section-group">
                            <label><?php esc_html_e('TinyMce Active', 'whistleblowing-system'); ?></label>
                            <input type="radio" name="teeny_active" class="wbls-teeny_active" value="1" <?php if($teeny_active) { echo 'checked'; } ?>> Yes
                            <input type="radio" name="teeny_active" class="wbls-teeny_active" value="0" <?php if(!$teeny_active) { echo 'checked'; } ?>> No
                            <p class="wbls-option-section-group-description"></p>
                        </div>
                        <div class="wbls-option-section-group">
                            <label><?php esc_html_e('User token visible', 'whistleblowing-system'); ?></label>
                            <input type="radio" name="user_token_visibility_active" class="user_token_visibility_active" value="1" <?php if($user_token_visibility_active) { echo 'checked'; } ?>> Yes
                            <input type="radio" name="user_token_visibility_active" class="user_token_visibility_active" value="0" <?php if(!$user_token_visibility_active) { echo 'checked'; } ?>> No
                            <p class="wbls-option-section-group-description">
                                <?php esc_html_e('Enable this option to display the user login token in the "Access" block on the Submissions page.', 'whistleblowing-system'); ?>
                            </p>
                        </div>
                        <div class="wbls-option-section-group wbls-pro-tooltip-action wbls-pro-tooltip wbls-pro-tooltip-action">
                            <label><?php esc_html_e('Token Length', 'whistleblowing-system'); ?></label>
                            <input type="number" name="token_length" class="wbls-token-length" min="6" max="64" required value="<?php echo esc_attr($token_length); ?>">
                            <p class="wbls-option-section-group-description">
                                <?php esc_html_e('Choose how many characters the generated token should contain. Shorter tokens are easier to read, while longer tokens provide stronger uniqueness and security. The token length can be set between 6 and 64 characters.', 'whistleblowing-system'); ?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}
