<?php
namespace WBLS_WhistleBlower\Free;
use WP_Query;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class WhistleblowerSubmissionItemEdit {

    public $fields = [];
    public $form_id;
    public $submission_id;

    public function __construct() {
        $task = isset($_GET['task']) ? sanitize_text_field(wp_unslash($_GET['task'])) : '';
        $this->form_id = isset($_GET['form_id']) ? intval($_GET['form_id']) : 0;
        $this->submission_id = isset($_GET['submission_id']) ? intval($_GET['submission_id']) : 0;

        $this->get_form_fields();


        if ( method_exists($this, $task) ) {
            $this->$task();
        } else {
            $this->display();
        }
    }

    public function get_form_fields() {
        $fields = get_post_meta($this->form_id, 'wbls_field_options', true);
        $this->fields = $fields;
    }

    public function display() {
        wp_enqueue_style(WBLS_PREFIX . '-submissions');
        wp_enqueue_style(WBLS_PREFIX . '-style');
        WBLSLibrary::wbls_render_topbar_row(); ?>
        <div class="wbls-admin-header">
            <img class="wbls-admin-header-logo" src="<?php echo esc_url(WBLS_URL . '/admin/assets/images/whistleblowing_logo.png'); ?>">
            <h2 class="wbls-page-title">
                <?php esc_html_e('Submissions of', 'whistleblowing-system'); ?>
                <?php echo esc_html(get_the_title($this->form_id)); ?>
                <?php esc_html_e('form', 'whistleblowing-system'); ?>
            </h2>
        </div>
        <?php if( !empty($_GET['success']) && sanitize_text_field(wp_unslash($_GET['success'])) ) { ?>
            <p class="wbls-response-message wbls-success-message" style="display: block">Submission changes successfully saved</p>
        <?php } elseif( !empty($_GET['success']) && !sanitize_text_field(wp_unslash($_GET['success'])) ) { ?>
            <p class="wbls-response-message wbls-error-message" style="display: block">Something went wrong, please try again.</p>
        <?php } ?>

        <div class="wrap wbls-content wbls-submission-edit-content">
            <h2>Submission ID: <?php echo intval($this->submission_id); ?></h2>
            <form method="post" action="?page=whistleblower_submission_item_edit&form_id=<?php echo intval($this->form_id); ?>&submission_id=<?php echo intval($this->submission_id); ?>&task=save_submission_item">

                <?php
                wp_nonce_field('wbls_edit_submission', 'wbls_edit_submission_nonce');
                foreach ( $this->fields as $field ) {
                    if( empty($field) ||
                            empty($field['name']) ||
                            $field['type'] == 'submit' ||
                            $field['type'] == 'file' ||
                            $field['type'] == 'recaptcha' ||
                            $field['type'] == 'page_break' ||
                            $field['type'] == 'anonymous') {
                        continue;
                    } elseif ( $field['type'] == 'checkbox' ) {
                        foreach ( $field['options'] as $option ) {
                            $shortText = strip_tags($option['miniLabel']);
                            ?>
                            <p title="<?php echo esc_attr($option['miniLabel']); ?>"><?php echo esc_html($shortText); ?></p>
                            <?php
                        }
                    }
                    $shortText = $field['label'];
                    ?>
                    <div class="wbls-submission-edit-row">
                    <label title="<?php echo esc_attr($field['label']); ?>"><?php echo esc_html(wp_strip_all_tags($shortText)); ?></label>
                    <?php
                    $field_value = WBLS_Encryption::decrypt(get_post_meta($this->submission_id, $field['name'], true));
                    if ( is_array($field_value) ) {
                        foreach ( $field_value as $key => $fl ) {
                            if( empty($fl) ) continue;
                            echo "<div>";
                            echo "<span class='wbls-mini-label'>".esc_html($key).":</span>";
                            echo esc_html($fl);
                            echo "</div>";
                        }
                    } else {
                        echo esc_html($field_value);
                    }
                    ?>
                    </div>
                    <?php
                }
                ?>
                <div class="wbls-submission-edit-row">
                    <label title="Submission date">Submission date</label>

                    <input type="text" value="<?php
                    $created_at = get_post_meta($this->submission_id, 'wbls_created_at', true);
                    if ($created_at) {
                        // Convert to UTC for consistent storage
                        echo esc_attr(gmdate('Y-m-d H:i:s', strtotime($created_at)));
                    } else {
                        echo esc_attr(current_time('Y-m-d H:i:s', true)); // true for GMT
                    }
                    ?>" name="wbls_created_at">
                    <p class="wbls-submission-edit-row-description">Please enter the date in format YYYY-MM-DD HH:MM:SS</p>

                </div>
                <input type="submit" value="Save">
            </form>
        </div>
        <?php
    }

    public function save_submission_item() {

        if( !isset($_POST['wbls_edit_submission_nonce']) ||
            !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['wbls_edit_submission_nonce'])), 'wbls_edit_submission', ) ||
            ! current_user_can('manage_options') ) {
            exit;
        }

        $newDate = isset($_POST['wbls_created_at']) ? strtotime(sanitize_text_field(wp_unslash($_POST['wbls_created_at']))) : false;
        $chats = get_post_meta($this->submission_id, 'wbls_chat', 1);
        if ( isset($chats[0]['modified_date']) ) {
            $chats[0]['modified_date'] = $newDate;
        }

        update_post_meta( $this->submission_id, 'wbls_chat', $chats);
        update_post_meta( $this->submission_id, 'wbls_created_at', $newDate);

        $reload_url = add_query_arg(array(
                'page' => 'whistleblower_submission_item_edit',
                'form_id' => intval($this->form_id),
                'submission_id' => intval($this->submission_id),
        ), admin_url('admin.php'));
       wp_safe_redirect($reload_url);
       exit;
    }

}
