class WBLS_FRONTEND {
    init() {
        this.token = '';
        this.conditions = wbls_front.conditions;
        this.hiddenConditions = [];
        this.recaptchaWidgetId;
        this.registerEvents();
        this.showFirstPage();
        this.initDatePicker();
    }

    initDatePicker() {}

    showFirstPage() {
        jQuery(document).find(".wblsform-page-and-images").eq(0).addClass("wblsform-active-page");
    }

    registerEvents() {
        let self = this;
        jQuery(document).on("click", ".wbls-new-case-button", function() {
            jQuery("body").addClass("wbls-hide-overflow");
            jQuery(".wbls-front-form-content").removeClass("wbls-hidden");
            jQuery(".wbls-front-layout").removeClass("wbls-hidden");
            jQuery(".wbls-form-container").removeClass("wbls-hidden");
        });

        jQuery(document).on("click", ".wbls-front-content-close", function() {
            jQuery("body").removeClass("wbls-hide-overflow");
            jQuery(".wbls-front-layout, .wbls-form-container, .wbls-front-form-content, .wbls-token-container").addClass("wbls-hidden");
            jQuery(".wbls-token-container .wbls-token-value").text('');
            jQuery(".wbls-form-container .wblsform-page-and-images").removeClass('wblsform-active-page');
            jQuery(".wbls-form-container .wblsform-page-and-images").eq(0).addClass('wblsform-active-page').removeClass("wbls-hidden");
        });

        jQuery(document).on("click", ".wbls-submit-form", function(e) {
            e.preventDefault();
            if( wbls_front.recaptcha_version === "v2i" ) {
                grecaptcha.execute(self.recaptchaWidgetId);
            }
            else {
                self.wbls_submit_form(this);
            }

        });

        jQuery(document).on("click", ".wbls-form-tab", function(e) {
            e.preventDefault();
            let contentClass = jQuery(this).attr("data-content");
            jQuery(this).closest(".wbls-form-tabs").find(".wbls-form-tab-active").removeClass("wbls-form-tab-active");
            jQuery(this).addClass("wbls-form-tab-active");

            jQuery(this).closest(".wbls-form-tab-container").find(".wbls-form-tabs-content .wbls-form-tab-content-active").removeClass("wbls-form-tab-content-active");
            jQuery(this).closest(".wbls-form-tab-container").find("." + contentClass).addClass("wbls-form-tab-content-active");
        });

        jQuery(document).on("click", ".wbls-copy-button", function(e) {
            e.preventDefault();
            self.wbls_copyToken();
        });

        jQuery(document).on("click", ".wbls-followup-button", function(e) {
            e.preventDefault();
            if( jQuery(document).find(".wbls-chat-container").length ) return;
            let template = jQuery(document).find("#wbls-chat-login-template").html();
            jQuery("body").append(template);
        });

        jQuery(document).on("click", ".wbls-chat-header-close", function(e) {
            e.preventDefault();
            jQuery(document).find(".wbls-chat-container").remove();
            jQuery(document).find(".wbls-embed-chat-container .wbls-chats-section, " +
                ".wbls-embed-chat-container .wbls-chat-message-footer").remove();
            jQuery(document).find(".wbls-embed-chat-container .wbls-embed-chat-header").addClass("wbls-hidden");
            jQuery(document).find(".wbls-embed-chat-container .wbls-token-row").show();
            jQuery(document).find(".wbls-login-container.wbls-embed-login .wbls-front-header").show();
        });

        jQuery(document).on("click", ".wbls-chat-header-maximize", function(e) {
            e.preventDefault();

            jQuery(document).find(".wbls-chats-section,.wbls-chat-message-footer, #wbls-new-reply").removeAttr("style");
            if( jQuery(document).find(".wbls-chat-container").hasClass("wbls-chat-container-full") ) {
                jQuery(document).find(".wbls-chat-container").removeClass("wbls-chat-container-full");
            } else {
                jQuery(document).find(".wbls-chat-container").addClass("wbls-chat-container-full");
                jQuery(document).find(".wbls-chat-container .wbls-chat-header-maximize").attr("title");
            }

            jQuery(document).find("#wbls-new-reply").trigger("input");
        });

        jQuery(document).on("click", ".wbls-login-button", function(e) {
            e.preventDefault();
            self.wbls_login(jQuery(this));
        });

        jQuery(document).on("click", "#wbls-reply-button", function(e) {
            e.preventDefault();
            self.wbls_reply(this);
        });

        jQuery(document).on("change", ".wbls-field[type='email']", function() {
            self.wbls_validate_email_fields(jQuery(this));
        });

        jQuery(document).find("#wbls-new-reply").keydown(function(event) {
            if( event.key === "Enter" ) {
                if (event.shiftKey) {
                    event.preventDefault();

                    let textarea = this;
                    let start = textarea.selectionStart;
                    let end = textarea.selectionEnd;

                    // Insert the new line character (\n)
                    let value = jQuery(textarea).val();
                    jQuery(textarea).val(value.substring(0, start) + "\n" + value.substring(end));

                    // Move the cursor to the next line
                    textarea.selectionStart = textarea.selectionEnd = start + 1;
                    jQuery('#wbls-new-reply').trigger("input");
                } else {
                    event.preventDefault();
                    jQuery(document).find("#wbls-reply-button").trigger("click");
                }
            }
        });

        // On input (typing, deleting, pasting)
        jQuery(document).on("input", "#wbls-new-reply", function() {
            self.wbls_autoResize();
        });

        // When images are added/removed from preview
        jQuery(document).on('wblsImagesChanged', function() {
            self.wbls_autoResize();
        });

        // On window resize (optional, for responsiveness)
        jQuery(window).on('resize', function() {
            self.wbls_autoResize();
        });

        jQuery(document).on("change", "#wbls-chat-file-input", function() {
            self.wbls_addPreviewAttachment(this);
        });

        jQuery(document).on("click", ".wbls_remove_image", function() {
            jQuery(document).find("#wbls-chat-upload_image_button").removeClass('wbls-chat-upload_image_button_inactive');
            jQuery(document).find("#wbls-chat-file-input").prop("disabled",false);
            const previewImage = jQuery(this).closest('.wbls_chat_preview_image');
            const indexToRemove = previewImage.data("index");
            const previewContainer = jQuery(this).closest('#wbls_images_preview_container');

            if (self.wblsSelectedFiles.length > 0) {
                if(self.wblsSelectedFiles.length === 1){
                    previewContainer.removeClass('wbls_active');
                    jQuery('.wbls-chat-message-footer').removeClass('wbls_chat_images_preview_active');
                }
                self.wblsSelectedFiles.forEach((file, index) => {
                    if(file.name === indexToRemove){
                        self.wblsSelectedFiles.splice(index, 1);
                    }
                });
            }
            jQuery("#wbls-chat-file-input").val("");
            previewImage.remove(); // Remove preview image
            jQuery("#wbls-new-reply").trigger('input');
        });
    }


    /**
     * The function is resizing user chat area according to the inputted text height
     */
    wbls_autoResize() {
        const messageEl = jQuery(document).find("#wbls-new-reply");
        if( !messageEl.length ) {
            return;
        }
        if( messageEl.val() !== '' || jQuery("#wbls_images_preview_container .wbls_chat_preview_image").length ) {
            jQuery("#wbls-reply-button").removeClass("wbls-send-button-disabled");
        } else {
            jQuery("#wbls-reply-button").addClass("wbls-send-button-disabled");
        }

        let wbls_new_reply = jQuery("#wbls-new-reply");
        wbls_new_reply.removeAttr('style');
        let scrollHeight = parseInt(messageEl.scrollHeight);
        wbls_new_reply.css('height', scrollHeight + 'px');
        let chatContainer = jQuery(".wbls-chat-message-footer");
        let chatContainer_default_height = 80;
        let max_scroll_height = 180;
        if( chatContainer.hasClass('wbls_chat_images_preview_active') ) {
            chatContainer_default_height = 133;
            max_scroll_height = 100;
            jQuery("#wbls-chat-file-input").css({
                'max-height':'100px'
            })
        } else{
            jQuery("#wbls-chat-file-input").css({
                'max-height':'180px'
            })
        }
        if( chatContainer.find(".wbls-field-error-msg").length ) {
            chatContainer_default_height += parseInt(chatContainer.find(".wbls-field-error-msg").height());
        }
        if( scrollHeight <= max_scroll_height) {
            chatContainer.css('height', 'auto');
            if( scrollHeight < 21 ){
                scrollHeight = 0;
            } else {
                scrollHeight = scrollHeight - 20;
            }
            chatContainer.css('height', scrollHeight + chatContainer_default_height + 'px');

            let messageContainer = jQuery(".wbls-chats-section");
            messageContainer.css('height', 'auto');
            messageContainer.css('height', 390 - (scrollHeight + chatContainer_default_height + 38) + 'px');
        }
        /* scroll to bottom */
        const container = jQuery(".wbls-chats-section");
        container.scrollTop(container[0].scrollHeight);
    }

    wbls_login(that) {
        let self = this;
        this.token = jQuery(that).closest(".wbls-chat-login-content, .wbls-embed-login").find(".wbls-token-input").val();
        if( this.token === '' ) {
            jQuery(".wbls-error-msg").text("Token field can't be empty").removeClass("wbls-hidden");
            return;
        }
        let security = jQuery(that).closest(".wbls-chat-login-content, .wbls-embed-login").find(".wbls-security").val();
        if( security !== "" ) {
            return;
        }


        const buttonText = jQuery(that).text();
        jQuery(that).addClass("wbls-login-button-loading");
        jQuery(that).text('');

        jQuery.ajax({
            type: 'POST',
            url: wbls_front.ajax_url,
            data: {
                'wbls_token': this.token,
                'wbls_security': security,
                'action': 'wbls_front_ajax',
                'task': 'wbls_login',
                'nonce': wbls_front.ajaxnonce
            },
            success: function (response) {
                if( !response['success'] ) {
                    jQuery(".wbls-error-msg").text(response['data']['message']).removeClass("wbls-hidden");
                }
                else if( response['success'] && response['data']['chats'] !== '' ) {
                    let data = response['data']['chats'];
                    self.admin_token_active = response['data']['chats']['admin_token_active'];

                    let template = jQuery(document).find("#wbls-chat-message-template").html();
                    jQuery(document).find('.wbls-chat-container, .wbls-embed-login .wbls-embed-chat-container').append(template);

                    let tokenContainer = jQuery(document).find('.wbls-embed-chat-container .wbls-token-row');
                    tokenContainer.hide();
                    tokenContainer.find(".wbls-token-input").val('');
                    jQuery(document).find(".wbls-login-container.wbls-embed-login .wbls-front-header").hide();

                    jQuery(document).find('.wbls-chat-login-content').remove();

                    jQuery(document).find("#wbls-reply-form input[name='wbls_form_id']").val(data['form_id']);

                    jQuery(document).find(".wbls-chat-header .wbls-chat-status").addClass(response['data']['chats']['chat_status']).attr("title", response['data']['chats']['chat_status_text']);
                    jQuery(document).find(".wbls-chat-header").removeClass("wbls-hidden");
                    self.wbls_add_chats( data );
                }
            },
            complete: function() {
                jQuery(that).removeClass("wbls-login-button-loading");
                jQuery(that).text(buttonText);
            },
            error: function (jqXHR) {
                console.log(jqXHR);
            },

        });

    }

    wbls_check_required(that) {
        let form = jQuery(that).closest(".wbls-form");
        form.find(".wbls-required-error").removeClass("wbls-required-error");
        let required_error = false;
        
        if( wbls_front.recaptcha_version === "v2" && jQuery(that).hasClass('wbls-submit-form') ) {
            let recaptchaResponse = grecaptcha.getResponse();
            if (recaptchaResponse.length === 0) {
                jQuery("#wbls-grecaptcha").closest(".wblsform-row").addClass("wbls-required-error");
                required_error = true;
            }

        }

        let $checkboxGroups = [];
        form.find(".wbls-field").each(function() {
            if( jQuery(this).attr('type') === 'radio' && typeof jQuery(this).attr('required') !== 'undefined' ) {
                let name = jQuery(this).attr('name');
                let is_checked = false;
                jQuery(document).find("input[name='"+name+"']").each(function() {
                    if( jQuery(this).is(':checked') ) {
                        is_checked = true;
                    }
                });
                if ( ! is_checked ) {
                    jQuery(this).closest(".wblsform-row").addClass("wbls-required-error");
                    required_error = true;
                }
            }
            else if( typeof jQuery(this).attr('required') !== 'undefined' &&
                    jQuery(this).attr('type') === 'checkbox' && jQuery(this).is(":visible"))
            {
                if( !jQuery(this).is(":checked") ) {
                    let $el = jQuery(this).closest(".wblsform-row");
                    if ($el.attr("data-required") === 'single') {

                        let group_ids = $el.attr("data-required-group-ids"); // example attribute
                        if (!group_ids || required_error) return false;

                        if ($checkboxGroups.length && $checkboxGroups.includes(group_ids)) {
                            return;
                        }
                        $checkboxGroups.push(group_ids);

                        let required_temp_error = true;

                        group_ids.split(",").forEach(function (group_id) {
                            group_id = group_id.trim();

                            let $checkboxes = $el.find('input[name="wbls_field_' + group_id + '"]');
                            if ($checkboxes.length && $checkboxes.is(":checked")) {
                                required_temp_error = false;
                            }
                        });
                        required_error = required_temp_error;
                        if (required_error) {
                            $el.addClass("wbls-required-error");
                        }
                    } else if (!jQuery(this).is(":checked")) {
                        $el.addClass("wbls-required-error");
                        required_error = true;
                    }
                }
            } else if( typeof jQuery(this).attr('required') !== 'undefined' &&
                        !jQuery(this).val() &&
                        jQuery(this).is(":visible") )
            {
                required_error = true;
                jQuery(this).closest(".wblsform-row").addClass("wbls-required-error");
            }
        });

        if( required_error && wbls_front.recaptcha_version === "v2i" ) {
            grecaptcha.reset(self.recaptchaWidgetId);
        }

        return required_error;
    }

    wbls_validate_email_fields(that) {
        let form = jQuery(that).closest(".wbls-form");
        form.find(".wbls-field[type='email']").removeClass("wbls-validation-error");
        let validation_error = false;
        form.find(".wbls-field[type='email']").each(function() {
            let email_val = jQuery(this).val();
            const regex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            if( email_val !== '' && !regex.test(email_val) && jQuery(this).is(":visible") ) {
                jQuery(this).closest(".wblsform-row").addClass("wbls-validation-error");
                validation_error = true;
            } else {
                jQuery(this).closest(".wblsform-row").removeClass("wbls-validation-error");
            }
        });
        return validation_error;
    }

    get_hidden_condition_fields() {
        let self = this;
        let ind = 0;
        jQuery(document).find(".wbls-field").each(function() {
            if( !jQuery(this).is(":visible") ) {
                self.hiddenConditions[ind] = jQuery(this).attr('name');
                ind++;
            }
        })
    }

    wbls_submit_form(that) {
        if( this.wbls_check_required(that) || this.wbls_validate_email_fields(that) ) {
            return;
        }

        let self = this;
        let form = jQuery(that).closest(".wbls-form");
        /* This is css id which is equal to wbls-form-{id} */
        let form_id = form.attr("id");
        /* This is id of form in DB integer value */
        let id = form.find("input[name='wbls_form_id']").val();
        let buttonLabel = jQuery(that).text();
        let security = form.find(".wbls-security").val();
        if( security !== "" ) {
            form.find(".wbls-submit-form").removeClass("wbls-button-loading").text(buttonLabel);
            return;
        }
        jQuery(that).empty().addClass("wbls-button-loading");

        var checkbox = form.find("input[type=checkbox]");
        jQuery.each(checkbox, function() {
            if( jQuery(this).is(':checked') ) {
                jQuery(this).val(1);
            }
        });

        var formData = new FormData(document.getElementById(form_id));
        formData.append('nonce', wbls_front.ajaxnonce);
        formData.append('wbls_security', security);
        this.get_hidden_condition_fields();
        formData.append('wbls_hidden_conditions', this.hiddenConditions);

        jQuery.ajax({
            type: 'POST',
            processData: false,
            contentType: false,
            dataType: "json",
            url: wbls_front.ajax_url,
            data:  formData,
            success: function (response) {
                if( response['success'] && response['data']['token'] !== '' ) {
                    jQuery(document).find(".wbls-success-msg").remove();
                    if( response['data']['whistleblower_active'] && response['data']['token'] !== '') {
                        let formContainer = jQuery(that).closest(".wbls-front-form-content");
                        let form = formContainer.find(".wbls-form");
                        let tokenContainer = form.find(".wbls-token-container");
                        if( formContainer.length ) {                            
                            formContainer.find(".wbls-token-value").text(response['data']['token']);
                            tokenContainer.removeClass("wbls-hidden");
                            let scrollPosition = tokenContainer.position().top + form.scrollTop();
                            form.animate({
                                scrollTop: scrollPosition - 50
                            }, 500);
                        } else {
                            let msg = "<p class='wbls-success-msg'>" + wbls_front.success_msg +"<br>" + wbls_front.token_msg;
                            msg += "<br><b>Token: <span class='wbls-msg-token'>"+response['data']['token']+"</span></b>";
                            msg += "</p>"
                            jQuery(that).closest(".wbls-form").prepend(msg);
                        }
                    } else if( !response['data']['whistleblower_active'] && response['data']['anonymous'] ) {
                        let msg = "<p class='wbls-success-msg'>" + wbls_front.success_msg +"<br>" + wbls_front.token_msg;
                        msg += "<br><b>Token: <span class='wbls-msg-token'>"+response['data']['token']+"</span></b>";
                        msg += "</p>"
                        jQuery(that).closest(".wbls-form").prepend(msg);
                    } else if( !response['data']['whistleblower_active'] ) {
                        jQuery(that).closest(".wbls-form").prepend("<p class='wbls-success-msg'>" + wbls_front.success_msg + "</p>");
                        setTimeout(()=> {
                            jQuery(document).find("#" + form_id + " .wbls-success-msg").remove();
                        }, 5000);

                    }


                    document.getElementById(form_id).reset();

                    const $formPages = jQuery(that).closest(".wbls-form").find(".wblsform-page-and-images");
                    $formPages.removeClass('wblsform-active-page');
                    if (response.data.whistleblower_active || response.data.anonymous) {
                        if (wbls_front.show_form_after_submit !== '0') {
                            // Show first page if form is set to stay visible
                            $formPages.eq(0).addClass('wblsform-active-page');
                        }
                    } else {
                        $formPages.eq(0).addClass('wblsform-active-page');
                    }

                    let functionName = 'wbls_condition_'+id;
                    if (typeof window[functionName] === "function") {
                        window[functionName]();
                    }
                } else if( !response['success'] ) {
                    jQuery(that).closest(".wbls-form").prepend("<p class='wbls-error-msg'>" + wbls_front.error_msg + "</p>");
                    setTimeout(()=> {
                        jQuery(document).find("#" + form_id + " .wbls-error-msg").remove();
                    }, 5000);

                }
            },
            complete: function() {
                form.find(".wbls-submit-form").removeClass("wbls-button-loading").text(buttonLabel);
                jQuery('html, body').scrollTop(form.offset().top-50);
                
                if( wbls_front.recaptcha_active === "1" ) {
                    if( wbls_front.recaptcha_version === "v3" ) {
                        grecaptcha.execute(wbls_front.recaptcha_key, {action: 'submit'}).then(function(token) {
                            // Add the token to the form
                            document.getElementById('recaptchaToken').value = token;
                        });
                    } else {
                        grecaptcha.reset(self.recaptchaWidgetId);
                    }
                }

            },
            error: function (jqXHR) {
                console.log(jqXHR);
            },

        });
    }

    wbls_reply(that) {
        let self = this;
        const form = document.getElementById("wbls-reply-form");
        let security = jQuery(form).find(".wbls-security").val();
        if( security !== "" ) {
            return;
        }

        var formData = new FormData(form);
        formData.append('wbls_security', security);
        formData.append('nonce', wbls_front.ajaxnonce);
        formData.append('token', self.token);

        let buttonLabel = jQuery(document).find("#wbls-reply-button").text();
        jQuery(document).find("#wbls-reply-button").empty().addClass("wbls-button-loading");

        jQuery.ajax({
            type: 'POST',
            processData: false,
            contentType: false,
            dataType: "json",
            url: wbls_front.ajax_url,
            data:  formData,
            success: function (response){
                if( !response['success'] ) {
                    jQuery(".wbls-error-msg").text(response['data']['message']).removeClass("wbls-hidden");
                }
                else {
                    //let data = response['data']['chats'];
                    //self.wbls_add_chats( data );
                    self.wbls_add_new_message(response.data);

                    jQuery("#wbls-new-reply").val('');
                    jQuery("#wbls-file-input").val('');
                    jQuery("#wbls_images_preview_container").empty();
                    jQuery(".wbls-chat-message-footer, #wbls-new-reply, .wbls-chats-section")
                        .removeAttr('style')
                        .removeClass('wbls_chat_images_preview_active');
                    jQuery("#wbls-chat-upload_image_button").removeClass('wbls-chat-upload_image_button_inactive');
                    jQuery(document).find("#wbls-chat-file-input").prop("disabled",false);
                    jQuery("#wbls-chat-user_input").trigger('input');
                    self.wblsSelectedFiles = [];
                }
            },
            complete: function() {
                jQuery(document).find("#wbls-reply-button").removeClass("wbls-button-loading").text(buttonLabel);
            },
            error: function (jqXHR) {
                console.log(jqXHR);
            },

        });
    }

    wbls_addPreviewAttachment(that){
        let self = this;
        const fileInput = jQuery(that);
        // const files = fileInput.prop('files'); // Get all selected files
        // self.twbbSelectedFiles.push(...files);

        const rawFiles = Array.from(fileInput.prop('files'));
        const files = self.wbls_filter_valid_files(rawFiles);
        if (files.length === 0) {
            fileInput.val('');
            return;
        }

        self.wblsSelectedFiles = self.wblsSelectedFiles || [];
        const newFiles = files.filter(file => {
            const existingIndex = self.wblsSelectedFiles.findIndex(f => f.name === file.name && f.size === file.size);
            if (existingIndex !== -1) {
                self.wblsSelectedFiles.splice(existingIndex, 1); // Remove existing file
            }
            return true;
        });
        self.wblsSelectedFiles.push(...newFiles);
        let images_limit = 5;
        jQuery("#wbls-chat-file-input").val("");
        const previewContainer = fileInput.closest('.wbls-chat-message-footer').find('#wbls_images_preview_container');
        //self.validateImages(self.twbbSelectedFiles);
        if (self.wblsSelectedFiles.length > images_limit) {
            jQuery(document).find("#wbls-chat-upload_image_button").addClass('wbls-chat-upload_image_button_inactive');
            jQuery(document).find("#wbls-chat-file-input").prop("disabled",true);
            self.wblsSelectedFiles = self.wblsSelectedFiles.slice(0,images_limit);
        } else if(self.wblsSelectedFiles.length === images_limit){
            jQuery(document).find("#wbls-chat-upload_image_button").addClass('wbls-chat-upload_image_button_inactive');
            jQuery(document).find("#wbls-chat-file-input").prop("disabled",true);
        } else {
            jQuery(document).find("#wbls-chat-upload_image_button").removeClass('twbb-copilot-upload_image_button_inactive');
            jQuery(document).find("#wbls-chat-file-input").prop("disabled",false);
        }
        if (self.wblsSelectedFiles.length > 0 && self.wblsSelectedFiles.length <= images_limit) {
            previewContainer.addClass('wbls_active');
            jQuery('.wbls-chat-message-footer').addClass('wbls_chat_images_preview_active');
            previewContainer.html('');
            self.wblsSelectedFiles.forEach((file) => {
                const fileType = file.type.split('/')[0]; // Get file type (e.g., "image", "video", "audio")
                const fileExtension = file.name.split('.').pop().toLowerCase(); // Get file extension
                let imageUrl;

                // Define default icons for file types
                const fileIcons = [
                    'pdf',
                    'mp3',
                    'wav',
                    'ogg',
                    'mp4',
                    'mov',
                    'avi',
                    'wmv',
                    'm4v',
                    'flv',
                    '3gp',
                    '3g2',
                    'webm',
                    'ogv',
                    'jpg',
                    'jpeg',
                    'png',
                    'gif',
                ];

                // Check if the file is an image
                if (fileType === "image") {
                    imageUrl = URL.createObjectURL(file);
                } else if (fileIcons.includes(fileExtension)) {
                    imageUrl = wbls_front.assets_url + '/images/' + fileExtension + '.png';
                } else {
                    imageUrl = wbls_front.assets_url + '/images/file.png'; // fallback icon
                }
                // Create and append preview element
                const img = jQuery(`
                        <span class="wbls_chat_preview_image" data-index="${file.name}" style="background-image: url('${imageUrl}')">
                            <span class="wbls_remove_image"></span>
                            <span class="wbls_image_upload_loading"></span>
                        </span>
                    `);

                previewContainer.append(img);
            });
        } else{
            if( self.wblsSelectedFiles.length > images_limit ){
                // self.addValidationError('File uploads are limited to 5 at a time.', true , 'twbb_file_limit_error');
            }
            previewContainer.removeClass('wbls_active');
            jQuery('.wbls-chat-message-footer').removeClass('wbls_chat_images_preview_active');
        }
        jQuery("#wbls-chat-user_input").trigger('input');
        jQuery('#wbls-new-reply').trigger("input");

    }

    wbls_filter_valid_files(files) {
        let validFiles = [];
        let errMessages = [];
        let validExtensions = wbls_front.file_types;
        let validSize = parseFloat(wbls_front.file_max_size) * 1000000;

        files.forEach(file => {
            const fileExtension = file.name.split('.').pop().toLowerCase();

            if (file.size > validSize) {
                errMessages.push(`${file.name}: ${wbls_front.file_size_msg}${parseFloat(wbls_front.file_max_size)}MB`);
            } else if (!validExtensions.includes(fileExtension)) {
                errMessages.push(`${file.name}: ${wbls_front.file_type_msg}: ${validExtensions.join(", ")}`);
            } else {
                validFiles.push(file);
            }
        });

        jQuery(".wbls-chat-message-footer .wbls-field-error-msg").remove();

        if (errMessages.length > 0) {
            const errorHTML = "<p class='wbls-field-error-msg'>" + errMessages.join("<br>") + "</p>";
            jQuery("#wbls_images_preview_container").after(errorHTML);
            jQuery(document).find("#wbls-new-reply").trigger("input");
        }

        return validFiles;
    }

    wbls_add_chats(data) {
        let rowDiv = "";

        jQuery('.wbls-chats-section').empty();

        let chatSection = document.getElementsByClassName('wbls-chats-section');
        jQuery(document).find(".wbls-chat-header-title .wbls-chat-header-title-text").empty().append("Messages");
        jQuery(document).find(".wbls-chat-login-content").empty();

        jQuery.each(data['message'], function(index, value) {
            rowDiv = document.createElement("div");
            rowDiv.classList.add('wbls_' + value['role'] + '_row');

            const msgColDiv = document.createElement("div");
            msgColDiv.classList.add('wbls_message_col');

            const roleSpan = document.createElement("span");
            roleSpan.classList.add('wbls_message_role');
            roleSpan.textContent = value['role'] + '/' + value['date'];
            msgColDiv.appendChild(roleSpan);

            const msgSpan = document.createElement("span");
            if (value['text'] && value['text'] !== '') {
                msgSpan.classList.add('wbls_message');
                msgSpan.textContent = value['text'];
                msgColDiv.appendChild(msgSpan);
            }


            rowDiv.appendChild(msgColDiv);
            chatSection[0].appendChild(rowDiv);
        }.bind(this)); // Bind 'this' to access formatFileSize method

        const container = jQuery(".wbls-chats-section");
        container.scrollTop(container[0].scrollHeight);
    }

    // This function appends a new message to the chat
    wbls_add_new_message(responseData) {
        const self = this;
        const newMessage = responseData.new_message;
        const submissionId = responseData.submission_id;

        if (!newMessage) return;

        const chatSection = document.getElementsByClassName('wbls-chats-section')[0];
        if (!chatSection) return;

        // Create message row
        const rowDiv = document.createElement("div");
        rowDiv.classList.add('wbls_' + newMessage['role'] + '_row');

        const msgColDiv = document.createElement("div");
        msgColDiv.classList.add('wbls_message_col');

        // Role and date
        const roleSpan = document.createElement("span");
        roleSpan.classList.add('wbls_message_role');
        roleSpan.textContent = newMessage['role'] + '/' + newMessage['date'];
        msgColDiv.appendChild(roleSpan);

        // Message text
        const msgSpan = document.createElement("span");
        if (newMessage['text'] && newMessage['text'] !== '') {
            msgSpan.classList.add('wbls_message');
            msgSpan.textContent = newMessage['text'];
            msgColDiv.appendChild(msgSpan);
        }

        rowDiv.appendChild(msgColDiv);
        chatSection.appendChild(rowDiv);

        // Scroll to bottom
        const container = jQuery(".wbls-chats-section");
        container.scrollTop(container[0].scrollHeight);
    }

    wbls_copyToken() {
        // Get the text field
        var copyText = jQuery(document).find(".wbls-token-value").text();

        // Copy the text inside the text field
        navigator.clipboard.writeText(copyText);
        jQuery(document).find(".wbls-copy-button .wbls-form-token-copy-tooltip").removeClass("wbls-hidden");
        setTimeout(() => {
            jQuery(document).find(".wbls-copy-button .wbls-form-token-copy-tooltip").addClass("wbls-hidden");
        }, 500);
    }
}

let wbls_frontend;
jQuery(document).ready(function() {
    wbls_frontend = new WBLS_FRONTEND();
    wbls_frontend.init();
});

