<?php if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly ?>
<!--Empty popup container template-->
<script type="text/template" id="wbls-chat-login-template">
    <div class="wbls-chat-container">
        <div class="wbls-chat-header">
            <div class="wbls-chat-header-title">
                <div class="wbls-chat-header-title-text"><?php esc_html_e('Log in', 'whistleblowing-system'); ?></div>
                <span class="wbls-chat-status"></span>
            </div>
            <div class="wbls-chat-header-maximize" title="<?php esc_attr_e('Maximize', 'whistleblowing-system'); ?>"></div>
            <div class="wbls-chat-header-close" title="<?php esc_attr_e('Log Out', 'whistleblowing-system'); ?>"></div>
        </div>
        <div class="wbls-chat-login-content wbls-login-container">
            <?php
            if(isset($template_vars['settings']['show_login_header']) && $template_vars['settings']['show_login_header']) { ?>
            <div class="wbls-chat-content-description">
                    <div class="wbls-front-header">
                        <div>
                        <?php
                        echo wp_kses($template_vars['settings']['login_header'], WBLS_WhistleBlower\Free\WBLSLibrary::$wp_kses_default); ?>
                        </div>
                    </div>
            </div>
            <?php } ?>
            <input type="text" value="" name="wbls_token" class="wbls-token-input" autocomplete="off" placeholder="<?php esc_attr_e('Write a Token', 'whistleblowing-system'); ?>">
            <input type="text" value="" name="wbls_security" class="wbls-security" required>
            <button class="wbls-login-button"><?php echo esc_html($template_vars['settings']['login_case']); ?></button>
            <span class="wbls-error-msg wbls-hidden"></span>
        </div>
    </div>
</script>

<script type="text/template" id="wbls-chat-message-template">
        <div class="wbls-chats-section">
        </div>
        <div class="wbls-chat-message-footer">
            <div id="wbls_images_preview_container"></div>
            <form id="wbls-reply-form">
                <input type="hidden" name="action" value="wbls_front_ajax">
                <input type="hidden" name="task" value="wbls_reply">
                <input type="hidden" value="" name="wbls_form_id">
                <input type="text" value="" name="wbls_security" class="wbls-security" required="">
                <textarea name="reply" id="wbls-new-reply" class="wbls-new-reply" placeholder="Type here..."></textarea>
                <div class="wbls-chat-action-container">
                    <div id="wbls-chat-upload_image_button" class="wbls-chat-upload_image_button">
                    </div>

                    <span class="wbls-empty-col"></span>
                    <span id="wbls-reply-button" class="wbls-send-button wbls-send-button-disabled"><?php echo esc_html($template_vars['settings']['reply_button']); ?></span>
                </div>
            </form>
        </div>
</script>
