<?php
namespace WBLS_WhistleBlower\Free;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
// TODO should be work for front

class WBLSLibrary
{
    public static $wp_kses_default = array(
        'h1' => array(
            'class' => array(),
            'id' => array(),
            'alt' => array(),
            'title' => array(),
            'style' => array(),
        ),
        'h2' => array(
            'class' => array(),
            'id' => array(),
            'alt' => array(),
            'title' => array(),
            'style' => array(),
        ),
        'h3' => array(
            'class' => array(),
            'id' => array(),
            'alt' => array(),
            'title' => array(),
            'style' => array(),
        ),
        'h4' => array(
            'class' => array(),
            'id' => array(),
            'alt' => array(),
            'title' => array(),
            'style' => array(),
        ),
        'h5' => array(
            'class' => array(),
            'id' => array(),
            'alt' => array(),
            'title' => array(),
            'style' => array(),
        ),
        'span' => array(
            'class' => array(),
            'id' => array(),
            'alt' => array(),
            'title' => array(),
            'style' => array(),
            'data-placeholder' => array(),
        ),
        'p' => array(
            'class' => array(),
            'id' => array(),
            'alt' => array(),
            'title' => array(),
            'style' => array(),
        ),
        'div' => array(
            'class' => array(),
            'id' => array(),
            'alt' => array(),
            'title' => array(),
            'style' => array(),
        ),
        'img' => array(
            'src' => array(),
            'class' => array(),
            'alt' => array(),
            'title' => array(),
            'style' => array(),
        ),
        'a' => array(
            'href' => array(),
            'class' => array(),
            'id' => array(),
            'alt' => array(),
            'title' => array(),
            'target' => array(),
            'style' => array(),
        ),
        'ul' => array(
            'class' => array(),
            'id' => array(),
            'title' => array(),
            'style' => array(),
        ),
        'li' => array(
            'class' => array(),
            'id' => array(),
            'title' => array(),
            'style' => array(),
        ),
        'ol' => array(
            'class' => array(),
            'id' => array(),
            'title' => array(),
            'style' => array(),
        ),
        'em' => array(
            'class' => array(),
            'id' => array(),
            'title' => array(),
            'style' => array(),
        ),
        'strong' => array(
            'class' => array(),
            'id' => array(),
            'title' => array(),
            'style' => array(),
        ),
        'b' => array(
            'class' => array(),
            'id' => array(),
            'title' => array(),
            'style' => array(),
        ),
        'i' => array(
            'class' => array(),
            'id' => array(),
            'title' => array(),
            'style' => array(),
        ),
        'br' => array(),
        'hr' => array(
                'class' => array(),
                'id' => array(),
                'style' => array(),
        ),
    );

    public static $wp_kses_form = array(
            'div' => array(
                    'class' => array(),
                    'id' => array(),
                    'data-field-id' => array(),
                    'data-required' => array(),
                    'data-required-group-ids' => array(),
                    'style' => array(),
            ),
            'span' => array(
                    'class' => array(),
                    'id' => array(),
                    'title' => array(),
                    'data-placeholder' => array(),
                    'style' => array(),
            ),
            'p' => array(
                    'class' => array(),
                    'id' => array(),
                    'title' => array(),
                    'style' => array(),
            ),
            'label' => array(
                    'class' => array(),
                    'id' => array(),
                    'style' => array(),
                    'for' => array(),
                    'data-label' => array(),
            ),
            'input' => array(
                    'type' => array(),
                    'name' => array(),
                    'value' => array(),
                    'placeholder' => array(),
                    'class' => array(),
                    'id' => array(),
                    'required' => array(),
                    'accept' => array(),
                    'checked' => array(),
                    'multiple' => array(),
                    'data-format' => array(),
                    'data-limit_days' => array(),
                    'data-past_days' => array(),
                    'style' => array(),
                    'disabled' => array(),
            ),
            'textarea' => array(
                    'type' => array(),
                    'name' => array(),
                    'value' => array(),
                    'placeholder' => array(),
                    'class' => array(),
                    'id' => array(),
                    'required' => array(),
                    'style' => array(),
                    'rows' => array(),
                    'cols' => array(),
            ),
            'select' => array(
                    'name' => array(),
                    'class' => array(),
                    'id' => array(),
                    'required' => array(),
                    'style' => array(),
                    'multiple' => array(),
                    'size' => array(),
            ),
            'option' => array(
                    'value' => array(),
                    'class' => array(),
                    'id' => array(),
                    'style' => array(),
                    'selected' => array(),
                    'disabled' => array(),
            ),
            'button' => array(
                    'type' => array(),
                    'name' => array(),
                    'value' => array(),
                    'placeholder' => array(),
                    'class' => array(),
                    'id' => array(),
                    'style' => array(),
                    'disabled' => array(),
                    'onclick' => array(),

            ),
            'a' => array(
                    'href' => array(),
                    'class' => array(),
                    'id' => array(),
                    'alt' => array(),
                    'title' => array(),
                    'target' => array(),
                    'style' => array(),
                    'data-*' => array(),
            ),
            'h1' => array(
                    'class' => array(),
                    'id' => array(),
                    'alt' => array(),
                    'title' => array(),
                    'style' => array(),
            ),
            'h2' => array(
                    'class' => array(),
                    'id' => array(),
                    'alt' => array(),
                    'title' => array(),
                    'style' => array(),
            ),
            'h3' => array(
                    'class' => array(),
                    'id' => array(),
                    'alt' => array(),
                    'title' => array(),
                    'style' => array(),
            ),
            'h4' => array(
                    'class' => array(),
                    'id' => array(),
                    'alt' => array(),
                    'title' => array(),
                    'style' => array(),
            ),
            'h5' => array(
                    'class' => array(),
                    'id' => array(),
                    'alt' => array(),
                    'title' => array(),
                    'style' => array(),
            ),
            'h6' => array(
                    'class' => array(),
                    'id' => array(),
                    'alt' => array(),
                    'title' => array(),
                    'style' => array(),
            ),
            'ul' => array(
                    'class' => array(),
                    'id' => array(),
                    'alt' => array(),
                    'title' => array(),
                    'style' => array(),
            ),
            'li' => array(
                    'class' => array(),
                    'id' => array(),
                    'alt' => array(),
                    'title' => array(),
                    'style' => array(),
            ),
            'table' => array(
                    'class' => array(),
                    'id' => array(),
                    'style' => array(),
                    'width' => array(),
                    'border' => array(),
                    'cellspacing' => array(),
                    'cellpadding' => array(),
            ),
            'thead' => array(
                    'class' => array(),
                    'id' => array(),
                    'style' => array(),
            ),
            'tbody' => array(
                    'class' => array(),
                    'id' => array(),
                    'style' => array(),
            ),
            'tfoot' => array(
                    'class' => array(),
                    'id' => array(),
                    'style' => array(),
            ),
            'tr' => array(
                    'class' => array(),
                    'id' => array(),
                    'style' => array(),
            ),
            'th' => array(
                    'class' => array(),
                    'id' => array(),
                    'style' => array(),
                    'scope' => array(),
                    'colspan' => array(),
                    'rowspan' => array(),
                    'width' => array(),
            ),
            'td' => array(
                    'class' => array(),
                    'id' => array(),
                    'style' => array(),
                    'colspan' => array(),
                    'rowspan' => array(),
                    'width' => array(),
            ),
            'col' => array(
                    'class' => array(),
                    'id' => array(),
                    'style' => array(),
                    'width' => array(),
            ),
            'colgroup' => array(
                    'class' => array(),
                    'id' => array(),
                    'style' => array(),
            ),
            'form' => array(
                    'method' => array(),
                    'action' => array(),
                    'class' => array(),
                    'id' => array(),
                    'style' => array(),
                    'enctype' => array(),
                    'target' => array(),
                    'novalidate' => array(),
            ),
            'img' => array(
                    'src' => array(),
                    'class' => array(),
                    'id' => array(),
                    'alt' => array(),
                    'title' => array(),
                    'style' => array(),
                    'width' => array(),
                    'height' => array(),
            ),
            'br' => array(),
            'hr' => array(
                    'class' => array(),
                    'id' => array(),
                    'style' => array(),
            ),
            'strong' => array(
                    'class' => array(),
                    'id' => array(),
                    'style' => array(),
            ),
            'em' => array(
                    'class' => array(),
                    'id' => array(),
                    'style' => array(),
            ),
            'b' => array(
                    'class' => array(),
                    'id' => array(),
                    'style' => array(),
            ),
            'i' => array(
                    'class' => array(),
                    'id' => array(),
                    'style' => array(),
            ),
            'u' => array(
                    'class' => array(),
                    'id' => array(),
                    'style' => array(),
            ),
            'code' => array(
                    'class' => array(),
                    'id' => array(),
                    'style' => array(),
            ),
            'pre' => array(
                    'class' => array(),
                    'id' => array(),
                    'style' => array(),
            ),
            'blockquote' => array(
                    'class' => array(),
                    'id' => array(),
                    'style' => array(),
                    'cite' => array(),
            ),
            'ol' => array(
                    'class' => array(),
                    'id' => array(),
                    'style' => array(),
                    'start' => array(),
                    'type' => array(),
            ),
            'nav' => array(
                    'class' => array(),
                    'id' => array(),
                    'style' => array(),
            ),
            'header' => array(
                    'class' => array(),
                    'id' => array(),
                    'style' => array(),
            ),
            'footer' => array(
                    'class' => array(),
                    'id' => array(),
                    'style' => array(),
            ),
            'section' => array(
                    'class' => array(),
                    'id' => array(),
                    'style' => array(),
            ),
            'article' => array(
                    'class' => array(),
                    'id' => array(),
                    'style' => array(),
            ),
            'aside' => array(
                    'class' => array(),
                    'id' => array(),
                    'style' => array(),
            ),
            'main' => array(
                    'class' => array(),
                    'id' => array(),
                    'style' => array(),
            ),
    );

    public static $country_list = array(
                                    "Afghanistan",
                                    "Albania",
                                    "Algeria",
                                    "Andorra",
                                    "Angola",
                                    "Antigua and Barbuda",
                                    "Argentina",
                                    "Armenia",
                                    "Australia",
                                    "Austria",
                                    "Azerbaijan",
                                    "Bahamas",
                                    "Bahrain",
                                    "Bangladesh",
                                    "Barbados",
                                    "Belarus",
                                    "Belgium",
                                    "Belize",
                                    "Benin",
                                    "Bhutan",
                                    "Bolivia",
                                    "Bosnia and Herzegovina",
                                    "Botswana",
                                    "Brazil",
                                    "Brunei",
                                    "Bulgaria",
                                    "Burkina Faso",
                                    "Burundi",
                                    "Cambodia",
                                    "Cameroon",
                                    "Canada",
                                    "Cape Verde",
                                    "Central African Republic",
                                    "Chad",
                                    "Chile",
                                    "China",
                                    "Colombi",
                                    "Comoros",
                                    "Congo (Brazzaville)",
                                    "Congo",
                                    "Costa Rica",
                                    "Cote d'Ivoire",
                                    "Croatia",
                                    "Cuba",
                                    "Cyprus",
                                    "Czech Republic",
                                    "Denmark",
                                    "Djibouti",
                                    "Dominica",
                                    "Dominican Republic",
                                    "East Timor (Timor Timur)",
                                    "Ecuador",
                                    "Egypt",
                                    "El Salvador",
                                    "Equatorial Guinea",
                                    "Eritrea",
                                    "Estonia",
                                    "Ethiopia",
                                    "Fiji",
                                    "Finland",
                                    "France",
                                    "Gabon",
                                    "Gambia, The",
                                    "Georgia",
                                    "Germany",
                                    "Ghana",
                                    "Greece",
                                    "Grenada",
                                    "Guatemala",
                                    "Guinea",
                                    "Guinea-Bissau",
                                    "Guyana",
                                    "Haiti",
                                    "Honduras",
                                    "Hungary",
                                    "Iceland",
                                    "India",
                                    "Indonesia",
                                    "Iran",
                                    "Iraq",
                                    "Ireland",
                                    "Israel",
                                    "Italy",
                                    "Jamaica",
                                    "Japan",
                                    "Jordan",
                                    "Kazakhstan",
                                    "Kenya",
                                    "Kiribati",
                                    "Korea, North",
                                    "Korea, South",
                                    "Kuwait",
                                    "Kyrgyzstan",
                                    "Laos",
                                    "Latvia",
                                    "Lebanon",
                                    "Lesotho",
                                    "Liberia",
                                    "Libya",
                                    "Liechtenstein",
                                    "Lithuania",
                                    "Luxembourg",
                                    "Macedonia",
                                    "Madagascar",
                                    "Malawi",
                                    "Malaysia",
                                    "Maldives",
                                    "Mali",
                                    "Malta",
                                    "Marshall Islands",
                                    "Mauritania",
                                    "Mauritius",
                                    "Mexico",
                                    "Micronesia",
                                    "Moldova",
                                    "Monaco",
                                    "Mongolia",
                                    "Morocco",
                                    "Mozambique",
                                    "Myanmar",
                                    "Namibia",
                                    "Nauru",
                                    "Nepal",
                                    "Netherlands",
                                    "New Zealand",
                                    "Nicaragua",
                                    "Niger",
                                    "Nigeria",
                                    "Norway",
                                    "Oman",
                                    "Pakistan",
                                    "Palau",
                                    "Panama",
                                    "Papua New Guinea",
                                    "Paraguay",
                                    "Peru",
                                    "Philippines",
                                    "Poland",
                                    "Portugal",
                                    "Qatar",
                                    "Romania",
                                    "Russia",
                                    "Rwanda",
                                    "Saint Kitts and Nevis",
                                    "Saint Lucia",
                                    "Saint Vincent",
                                    "Samoa",
                                    "San Marino",
                                    "Sao Tome and Principe",
                                    "Saudi Arabia",
                                    "Senegal",
                                    "Serbia and Montenegro",
                                    "Seychelles",
                                    "Sierra Leone",
                                    "Singapore",
                                    "Slovakia",
                                    "Slovenia",
                                    "Solomon Islands",
                                    "Somalia",
                                    "South Africa",
                                    "Spain",
                                    "Sri Lanka",
                                    "Sudan",
                                    "Suriname",
                                    "Swaziland",
                                    "Sweden",
                                    "Switzerland",
                                    "Syria",
                                    "Taiwan",
                                    "Tajikistan",
                                    "Tanzania",
                                    "Thailand",
                                    "Togo",
                                    "Tonga",
                                    "Trinidad and Tobago",
                                    "Tunisia",
                                    "Turkey",
                                    "Turkmenistan",
                                    "Tuvalu",
                                    "Uganda",
                                    "Ukraine",
                                    "United Arab Emirates",
                                    "United Kingdom",
                                    "United States",
                                    "Uruguay",
                                    "Uzbekistan",
                                    "Vanuatu",
                                    "Vatican City",
                                    "Venezuela",
                                    "Vietnam",
                                    "Yemen",
                                    "Zambia",
                                    "Zimbabwe"
    );

    /**
     * Forbidden template.
     *
     * @return string
     */
    public static function forbidden_template() {
        return '<!DOCTYPE html>
				<html>
				<head>
					<title>403 Forbidden</title>
				</head>
				<body>
					<p>Directory access is forbidden.</p>
				</body>
				</html>';
    }

    /* Check if form whistleblower setting active */
    public static function is_whistleblower_active( $form_id ) {
        $settings = get_post_meta($form_id, 'wbls_form_settings', 1);
        if (isset($settings['whistleblower_active']) && $settings['whistleblower_active']) {
            return TRUE;
        }
        return FALSE;
    }

    public static function wbls_set_upload_file($params = []) {
                return '';
    }

    public static function wbls_migrate_form_structure() {
        if ( !class_exists('\DOMDocument') ) {
            return;
        }


        update_option('wbls-plugin-version', WBLS_VERSION);
        // Get all forms
        $forms = get_posts([
            'post_type'      => 'wbls_form',
            'posts_per_page' => -1,
            'post_status'    => 'any',
            'fields'         => 'ids',
        ]);

        foreach ($forms as $form_id) {
            $html = get_post_meta($form_id, 'wbls_form_content', true);
            update_post_meta($form_id, 'wbls_form_content_backup', $html);
            if (empty($html)) {
                continue;
            }

            $dom = new \DOMDocument();
            libxml_use_internal_errors(true);
            $dom->loadHTML('<?xml encoding="utf-8" ?>' . $html, LIBXML_HTML_NODEFDTD | LIBXML_HTML_NOIMPLIED);
            libxml_clear_errors();

            $xpath = new \DOMXPath($dom);

            // Find all columns
            $columns = $xpath->query('//div[contains(@class, "wblsform_column")]');

            /** @var DOMElement $column */
            foreach ($columns as $column) {
                // Collect all rows inside this column
                $rows = [];
                foreach ($column->childNodes as $child) {
                    if ($child instanceof \DOMElement && strpos($child->getAttribute('class'), 'wblsform-row') !== false) {
                        $rows[] = $child;
                    }
                }

                if (count($rows) > 1) {
                    // Insert new columns for each row
                    foreach ($rows as $row) {
                        $newColumn = $dom->createElement('div');
                        $newColumn->setAttribute('class', 'wblsform_column');

                        $newRow = $row->cloneNode(true);
                        $newColumn->appendChild($newRow);

                        $column->parentNode->insertBefore($newColumn, $column);
                    }

                    // Remove the old multi-row column
                    $column->parentNode->removeChild($column);
                }
            }

            // Save new HTML
            $newHtml = $dom->saveHTML();
            $newHtml = preg_replace('/<!--\?xml[^>]*\?-->/', '', $newHtml);
            if ( ! empty($newHtml) ) {
                update_post_meta($form_id, 'wbls_form_content', $newHtml);
            }
        }
    }

    public static function is_emailField_exists( $fields_options ) {
        $searchKey = 'type';
        $searchValue = 'email';
        if ( empty($fields_options) ) {
            return [];
        }
        $result = array_filter($fields_options, function ($subarray) use ($searchKey, $searchValue) {
            return isset($subarray[$searchKey]) && $subarray[$searchKey] === $searchValue;
        });
        if (!empty($result)) {
            return $result;
        }

        return [];
    }

    public static function is_recaptcha_active($form_id) {
        return [];
    }

    public static function sanitize_array($data, $sanitize_type) {
        // Check if the input is an array
        if (is_array($data)) {
            // Iterate through each element and sanitize recursively
            foreach ($data as $key => $value) {
                // Recursively call sanitize_array for nested arrays
                $data[$key] = self::sanitize_array($value, $sanitize_type);
            }
        } else {
            // Sanitize non-array values
            $data = $sanitize_type($data);
        }
        return $data;
    }

    public static function get_submissions_count($form_id) {
        $args = array(
            'post_type' => 'wbls_form_subm',
            'post_status' => 'closed',
            'meta_query' => array(
                array(
                    'key' => 'wbls_form_id',
                    'value' => $form_id,
                    'compare' => '=',
                )
            ),
            "numberposts" => 1000,
            "posts_per_page" => 1000,
        );
        $query = new \WP_Query($args);
        $submissions = [];
        if ( $query->posts ) {
            foreach ( $query->posts as $post ) {
                $submissions[] = $post->ID;
            }
        }
        return count($submissions);
    }

    /**
     * Days from today (site timezone) to an expire date (Y-m-d).
     * Returns positive for future dates, 0 for today, negative for past dates.
     * Returns null if the input date is invalid.
     */
    public static function wbls_days_until_expiry(string $expire_ymd): ?int {
        $expire_ymd = date('Y-m-d', strtotime($expire_ymd));
        $tz = wp_timezone();
        $d  = \DateTime::createFromFormat('Y-m-d', $expire_ymd, $tz);
        $errors = \DateTime::getLastErrors();
        $has_errors = is_array($errors) && (
                (!empty($errors['warning_count']) && $errors['warning_count'] > 0) ||
                (!empty($errors['error_count'])   && $errors['error_count'] > 0)
            );
        if (!$d || $has_errors) return null;

        $d->setTime(0,0,0);
        $today = new \DateTime('today', $tz);
        $diff  = $today->diff($d);
        $days  = (int)$diff->days;
        return $diff->invert ? -$days : $days;
    }

    public static function wbls_render_topbar_row() {
        ob_start();
        if ( ! WBLS_PRO ) { ?>
            <div class="wbls-trial-pro-header">
                <h2>🎉 <?php esc_html_e('Start your 14-day free trial of Whistleblowing Pro plugin!', 'whistleblowing-system') ?></h2>
                <span class="wbls-trial-cta"><?php esc_html_e('Unlock Pro Features', 'whistleblowing-system') ?></span>
            </div>
        <?php
         }
        $content = ob_get_clean();
        echo wp_kses($content, self::$wp_kses_form);
    }
}