<?php
/**
 * Plugin Name: Whistleblowing System
 * Plugin URI:  https://whistleblowing-form.de
 * Description: Whistleblowing system form is the ultimate solution for effortlessly creating and managing contact and whistleblowing forms.
 * Version:     1.4.8
 * Author:      Whistleblowing System Team
 * Author URI:  https://whistleblowing-form.de
 * Text Domain: whistleblowing-system
 * License:     GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 *
 * @package whistleblowing-system
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

require_once __DIR__ . '/config.php';
require_once __DIR__ . '/includes/class-wbls-whistleblower.php';

// Optional: keep your global helper function.
function WBLS_WhistleBlower() { // phpcs:ignore WordPress.NamingConventions.ValidFunctionName.FunctionNameInvalid
    return \WBLS_WhistleBlower\Free\WBLS_WhistleBlower::instance();
}

// Register activation/deactivation using the main plugin file path.
register_activation_hook(
    __FILE__,
    array( '\WBLS_WhistleBlower\Free\WBLS_WhistleBlower', 'activate' )
);

register_deactivation_hook(
    __FILE__,
    array( '\WBLS_WhistleBlower\Free\WBLS_WhistleBlower', 'deactivate' )
);

// Boot the plugin.
WBLS_WhistleBlower();